/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.validation.Schema;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.KeyInValueHashMap;
import org.teiid.designer.roles.DataRole;
import org.teiid.designer.vdb.AbstractVdbObject;
import org.teiid.designer.vdb.AllowedLanguages;
import org.teiid.designer.vdb.TranslatorOverride;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.VdbImportVdbEntry;
import org.teiid.designer.vdb.VdbPlugin;
import org.teiid.designer.vdb.VdbUtil;
import org.teiid.designer.vdb.XmiVdb;
import org.teiid.designer.vdb.dynamic.DynamicVdb;
import org.teiid.designer.vdb.manifest.VdbElement;
import org.xml.sax.SAXException;

public abstract class BasicVdb
extends AbstractVdbObject
implements Vdb {
    private IFile sourceFile;
    private int version = 1;
    private String connectionType;
    private boolean preview;
    private int queryTimeout = 0;
    private AllowedLanguages allowedLanguages = new AllowedLanguages(this);
    private String securityDomain;
    private String gssPattern;
    private String passwordPattern;
    private String authenticationType;
    private Date validateDateTime;
    private String validationVersion;
    private boolean autoGenerateRESTWar;
    private KeyInValueHashMap<String, VdbImportVdbEntry> importVdbs = new KeyInValueHashMap((KeyInValueHashMap.KeyFromValueAdapter)new ImportVdbKeyAdapter());
    private KeyInValueHashMap<String, TranslatorOverride> translatorOverrides = new KeyInValueHashMap((KeyInValueHashMap.KeyFromValueAdapter)new TranslatorOverrideKeyAdapter());
    private KeyInValueHashMap<String, DataRole> dataRoles = new KeyInValueHashMap((KeyInValueHashMap.KeyFromValueAdapter)new DataRoleKeyAdapter());
    private final CopyOnWriteArrayList<PropertyChangeListener> listeners = new CopyOnWriteArrayList();
    private IStatus currentStatus;

    protected BasicVdb() {
    }

    protected BasicVdb(IFile sourceFile) throws Exception {
        this.sourceFile = sourceFile;
        this.setName(FileUtils.getNameWithoutExtension((IResource)sourceFile));
        File stagingFolder = this.getStagingFolder();
        if (stagingFolder != null) {
            stagingFolder.mkdirs();
        }
        this.read(sourceFile);
        this.setChanged(false);
        this.currentStatus = Status.OK_STATUS;
    }

    public abstract void read(IFile var1) throws Exception;

    @Override
    public void setDescription(String newDescription) {
        if (StringUtilities.isEmpty((String)newDescription)) {
            newDescription = null;
        }
        String oldDescription = this.getDescription();
        if (StringUtilities.isEmpty((String)newDescription)) {
            oldDescription = null;
        }
        if (StringUtilities.areDifferent((String)oldDescription, (String)newDescription)) {
            super.setDescription(newDescription);
            this.setModified(this, "description", oldDescription, newDescription);
        }
    }

    @Override
    public boolean addDataRole(DataRole dataRole) {
        if (this.dataRoles.add((Object)dataRole)) {
            dataRole.setVdb(this);
            this.setModified(this, "dataPolicyAdded", null, dataRole);
            return true;
        }
        return false;
    }

    @Override
    public VdbImportVdbEntry addImport(String vdbName, int version) {
        VdbImportVdbEntry importVdbEntry = new VdbImportVdbEntry((Vdb)this, vdbName);
        importVdbEntry.setVersion(version);
        this.importVdbs.add((Object)importVdbEntry);
        this.setModified(this, "importVdbEntryAdded", null, importVdbEntry);
        return importVdbEntry;
    }

    @Override
    public boolean addImport(VdbImportVdbEntry vdbImport) {
        if (this.importVdbs.add((Object)vdbImport)) {
            vdbImport.setVdb(this);
            this.setModified(this, "importVdbEntryAdded", null, vdbImport);
            return true;
        }
        return false;
    }

    @Override
    public boolean addTranslator(TranslatorOverride translatorOverride) {
        if (this.translatorOverrides.add((Object)translatorOverride)) {
            translatorOverride.setVdb(this);
            this.setModified(this, "translatorOverrideAdded", null, translatorOverride);
            return true;
        }
        return false;
    }

    @Override
    public JAXBContext getJaxbContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{VdbElement.class});
    }

    @Override
    public Schema getManifestSchema() throws SAXException {
        return VdbUtil.getManifestSchema();
    }

    @Override
    public String getConnectionType() {
        return this.connectionType;
    }

    @Override
    public Collection<DataRole> getDataRoles() {
        return Collections.unmodifiableCollection(this.dataRoles.values());
    }

    @Override
    public Collection<VdbImportVdbEntry> getImports() {
        return Collections.unmodifiableCollection(this.importVdbs.values());
    }

    @Override
    public File getStagingFolder() {
        return VdbPlugin.singleton().getStateLocation().append(this.getSourceFile().getFullPath()).toFile();
    }

    @Override
    public IFile getSourceFile() {
        return this.sourceFile;
    }

    protected void setSourceFile(IFile file) {
        this.sourceFile = file;
    }

    @Override
    public String getFileName() {
        if (this.sourceFile == null) {
            return null;
        }
        return this.sourceFile.getName();
    }

    @Override
    public Collection<TranslatorOverride> getTranslators() {
        return Collections.unmodifiableCollection(this.translatorOverrides.values());
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isPreview() {
        return this.preview;
    }

    @Override
    public boolean removeDataRole(String dataRoleToRemove) {
        DataRole dataRole = (DataRole)this.dataRoles.get((Object)dataRoleToRemove);
        if (dataRole == null) {
            return false;
        }
        if ((dataRole = (DataRole)this.dataRoles.remove((Object)dataRole)) != null) {
            this.setModified(this, "dataPolicyRemoved", dataRole, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeImport(VdbImportVdbEntry importToRemove) {
        if (this.importVdbs.remove((Object)importToRemove) != null) {
            this.setModified(this, "importVdbEntryRemoved", importToRemove, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeImport(String importToRemove) {
        VdbImportVdbEntry importEntry = (VdbImportVdbEntry)this.importVdbs.get((Object)importToRemove);
        if (importEntry == null) {
            return false;
        }
        return this.removeImport(importEntry);
    }

    @Override
    public void removeAllImports() {
        ArrayList entries = new ArrayList(this.importVdbs.values());
        if (entries.isEmpty()) {
            return;
        }
        this.importVdbs.clear();
        this.setModified(this, "importVdbEntryRemoved", entries, null);
    }

    @Override
    public boolean removeTranslator(TranslatorOverride translatorOverride) {
        if (this.translatorOverrides.remove((Object)translatorOverride) != null) {
            this.setModified(this, "translatorOverrideRemoved", translatorOverride, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeTranslator(String name) {
        TranslatorOverride translatorOverride = (TranslatorOverride)this.translatorOverrides.get((Object)name);
        if (translatorOverride == null) {
            return false;
        }
        return this.removeTranslator(translatorOverride);
    }

    @Override
    public void setConnectionType(String newConnectionType) {
        if (StringUtilities.areDifferent((String)this.connectionType, (String)newConnectionType)) {
            this.connectionType = newConnectionType;
            this.setChanged(true);
        }
    }

    @Override
    public void setPreview(boolean newPreview) {
        if (this.preview != newPreview) {
            this.preview = newPreview;
            this.setChanged(true);
        }
    }

    @Override
    public void setVersion(int intVersion) {
        int oldVersion = this.version;
        if (oldVersion == intVersion) {
            return;
        }
        this.version = intVersion;
        this.setModified(this, "version", oldVersion, intVersion);
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int valueInSeconds) {
        int oldTimeout = this.queryTimeout;
        if (oldTimeout == valueInSeconds) {
            return;
        }
        this.queryTimeout = valueInSeconds;
        this.setModified(this, "queryTimeout", oldTimeout, valueInSeconds);
    }

    @Override
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    @Override
    public void setSecurityDomain(String newValue) {
        String old = this.securityDomain;
        if (old == null && (newValue == null || newValue.length() == 0) || newValue.equals(old)) {
            return;
        }
        this.securityDomain = newValue.length() == 0 ? null : newValue;
        this.setModified(this, "securityDomain", old, newValue);
    }

    @Override
    public String getGssPattern() {
        return this.gssPattern;
    }

    @Override
    public void setGssPattern(String newValue) {
        String old = this.gssPattern;
        if (old == null && (newValue == null || newValue.length() == 0) || newValue.equals(old)) {
            return;
        }
        this.gssPattern = newValue.length() == 0 ? null : newValue;
        this.setModified(this, "gssPattern", old, newValue);
    }

    @Override
    public String getPasswordPattern() {
        return this.passwordPattern;
    }

    @Override
    public void setPasswordPattern(String newValue) {
        String old = this.passwordPattern;
        if (old == null && (newValue == null || newValue.length() == 0) || newValue.equals(old)) {
            return;
        }
        this.passwordPattern = newValue.length() == 0 ? null : newValue;
        this.setModified(this, "passwordPattern", old, newValue);
    }

    @Override
    public String getAuthenticationType() {
        return this.authenticationType;
    }

    @Override
    public void setAuthenticationType(String newValue) {
        String old = this.authenticationType;
        if (old == null && (newValue == null || newValue.length() == 0) || newValue.equals(old)) {
            return;
        }
        this.authenticationType = newValue.length() == 0 ? null : newValue;
        this.setModified(this, "authenticationType", old, newValue);
    }

    @Override
    public AllowedLanguages getAllowedLanguages() {
        return this.allowedLanguages;
    }

    @Override
    public boolean addAllowedLanguage(String name) {
        this.allowedLanguages.addAllowedLanguage(name);
        if (this.allowedLanguages.isChanged()) {
            this.setModified(this, "allowed-languages", name, name);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAllowedLanguage(String name) {
        this.allowedLanguages.removeAllowedLanguage(name);
        if (this.allowedLanguages.isChanged()) {
            this.setModified(this, "allowed-languages", name, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean isAutoGenerateRESTWar() {
        return this.autoGenerateRESTWar;
    }

    @Override
    public void setAutoGenerateRESTWar(boolean autoGenerateRESTWar) {
        boolean oldValue = this.autoGenerateRESTWar;
        if (oldValue == autoGenerateRESTWar) {
            return;
        }
        this.autoGenerateRESTWar = autoGenerateRESTWar;
        this.setModified(this, "autoGenerateRESTWAR", oldValue, autoGenerateRESTWar);
    }

    @Override
    public void setValidationVersion(String valVersion) {
        String oldVersion = this.validationVersion;
        if (StringUtilities.equals((String)oldVersion, (String)valVersion)) {
            return;
        }
        this.validationVersion = valVersion;
        this.setModified(this, "generalProperty", oldVersion, valVersion);
    }

    @Override
    public Date getValidationDateTime() {
        return this.validateDateTime;
    }

    @Override
    public void setValidationDateTime(Date dateTime) {
        Date oldDateTime = this.validateDateTime;
        if (oldDateTime != null && oldDateTime.equals(dateTime)) {
            return;
        }
        this.validateDateTime = dateTime;
        this.setModified(this, "generalProperty", oldDateTime, dateTime);
    }

    @Override
    public String getValidationVersion() {
        return this.validationVersion;
    }

    @Override
    public void setProperty(String key, String value) {
        super.setProperty(key, value);
        this.setModified(this, "generalProperty", null, value);
    }

    @Override
    public String removeProperty(String key) {
        String prop = super.removeProperty(key);
        this.setModified(this, "generalProperty", null, prop);
        return prop;
    }

    @Override
    public IStatus getStatus() {
        return this.currentStatus;
    }

    @Override
    public void setStatus(IStatus currentStatus) {
        this.currentStatus = currentStatus;
    }

    @Override
    public void notifyChangeListeners(Object source, String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = null;
        if (!this.isPreview()) {
            for (PropertyChangeListener listener : this.listeners) {
                if (event == null) {
                    event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
                }
                listener.propertyChange(event);
            }
        }
    }

    @Override
    public void addChangeListener(PropertyChangeListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void removeChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isModified() {
        return this.isChanged();
    }

    @Override
    public void setModified(Object source, String propertyName, Object oldValue, Object newValue) {
        this.setChanged(true);
        this.notifyChangeListeners(source, propertyName, oldValue, newValue);
    }

    @Override
    public void close() {
        this.setDescription("");
        if (this.isModified()) {
            this.setChanged(false);
        }
        this.notifyChangeListeners(this, "closed", null, null);
        this.listeners.clear();
    }

    @Override
    public IMarker[] getProblems() throws Exception {
        IFile file = this.getSourceFile();
        if (file == null) {
            return new IMarker[0];
        }
        return file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
    }

    protected void populateVdb(BasicVdb vdb) {
        Properties existingProps = this.getProperties();
        vdb.setName(this.getName());
        vdb.setDescription(this.getDescription());
        String validationVersion = existingProps.getProperty("validationVersion");
        if (validationVersion != null) {
            vdb.setValidationVersion(validationVersion);
            existingProps.remove("validationVersion");
        } else {
            vdb.setValidationVersion(ModelerCore.getTeiidServerVersion().toString());
        }
        String validationDateTime = existingProps.getProperty("validationDateTime");
        if (validationDateTime != null) {
            existingProps.remove("validationDateTime");
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
                Date dtIn = simpleDateFormat.parse(validationDateTime);
                vdb.setValidationDateTime(dtIn);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                vdb.setValidationDateTime(new Date());
            }
        } else {
            vdb.setValidationDateTime(new Date());
        }
        for (Map.Entry<Object, Object> entry : existingProps.entrySet()) {
            if (entry.getKey().toString().equals("validationVersion") || entry.getKey().toString().equals("validationDateTime")) continue;
            vdb.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        if (vdb.getSourceFile() == null) {
            vdb.setSourceFile(this.sourceFile);
        }
        vdb.setVersion(this.getVersion());
        vdb.setConnectionType(this.getConnectionType());
        vdb.setPreview(this.isPreview());
        vdb.setQueryTimeout(this.getQueryTimeout());
        String[] stringArray = this.getAllowedLanguages().getAllowedLanguageValues();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            vdb.addAllowedLanguage(string);
            ++n2;
        }
        vdb.setSecurityDomain(this.getSecurityDomain());
        vdb.setGssPattern(this.getGssPattern());
        vdb.setPasswordPattern(this.getPasswordPattern());
        vdb.setAuthenticationType(this.getAuthenticationType());
        vdb.setValidationDateTime(this.getValidationDateTime());
        vdb.setAutoGenerateRESTWar(this.isAutoGenerateRESTWar());
        if (this.getProperties().keySet().contains("UseConnectorMetadata")) {
            vdb.setProperty("UseConnectorMetadata", this.getProperties().getProperty("UseConnectorMetadata"));
        }
        for (VdbImportVdbEntry vdbImportVdbEntry : this.getImports()) {
            VdbImportVdbEntry clone = vdbImportVdbEntry.clone();
            vdb.addImport(clone);
        }
        for (TranslatorOverride translatorOverride : this.getTranslators()) {
            TranslatorOverride clone = translatorOverride.clone();
            vdb.addTranslator(clone);
        }
        for (DataRole dataRole : this.getDataRoles()) {
            DataRole clone = dataRole.clone();
            vdb.addDataRole(clone);
        }
        vdb.setChanged(this.isChanged());
    }

    public abstract XmiVdb xmiVdbConvert(IFile var1, Properties var2) throws Exception;

    public abstract DynamicVdb dynVdbConvert(IFile var1, Properties var2) throws Exception;

    @Override
    public <V extends Vdb> V convert(Class<V> vdbType, IFile destination, Properties options) throws Exception {
        CoreArgCheck.isNotNull(vdbType);
        CoreArgCheck.isNotNull((Object)destination);
        if (DynamicVdb.class.equals(vdbType)) {
            return (V)this.dynVdbConvert(destination, options);
        }
        if (XmiVdb.class.equals(vdbType)) {
            return (V)this.xmiVdbConvert(destination, options);
        }
        throw new UnsupportedOperationException();
    }

    private class DataRoleKeyAdapter
    implements KeyInValueHashMap.KeyFromValueAdapter<String, DataRole> {
        private DataRoleKeyAdapter() {
        }

        public String getKey(DataRole value) {
            return value.getName();
        }
    }

    private class ImportVdbKeyAdapter
    implements KeyInValueHashMap.KeyFromValueAdapter<String, VdbImportVdbEntry> {
        private ImportVdbKeyAdapter() {
        }

        public String getKey(VdbImportVdbEntry value) {
            return value.getName();
        }
    }

    private class TranslatorOverrideKeyAdapter
    implements KeyInValueHashMap.KeyFromValueAdapter<String, TranslatorOverride> {
        private TranslatorOverrideKeyAdapter() {
        }

        public String getKey(TranslatorOverride value) {
            return value.getName();
        }
    }

    private class VdbEntryKeyAdapter
    implements KeyInValueHashMap.KeyFromValueAdapter<String, VdbEntry> {
        private VdbEntryKeyAdapter() {
        }

        public String getKey(VdbEntry value) {
            return value.getName();
        }
    }
}

