/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.core.designer.properties.PropertyDefinition;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.translators.TranslatorOverrideProperty;
import org.teiid.designer.core.translators.TranslatorPropertyDefinition;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbPlugin;
import org.teiid.designer.vdb.VdbUnit;
import org.teiid.designer.vdb.manifest.PropertyElement;
import org.teiid.designer.vdb.manifest.TranslatorElement;

public class TranslatorOverride
extends VdbUnit
implements Comparable<TranslatorOverride>,
PropertyChangeListener {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(TranslatorOverride.class);
    public static final TranslatorOverride[] NO_TRANSLATORS = new TranslatorOverride[0];
    private final Map<String, TranslatorOverrideProperty> overrideProps = new HashMap<String, TranslatorOverrideProperty>();
    private final String type;

    public static String validateName(String proposedName) {
        if (StringUtilities.isEmpty((String)proposedName)) {
            return VdbPlugin.UTIL.getString(String.valueOf(PREFIX) + "emptyTranslatorName", new Object[0]);
        }
        char[] cArray = proposedName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '-') {
                return VdbPlugin.UTIL.getString(String.valueOf(PREFIX) + "invalidTranslatorName", (Object)proposedName);
            }
            ++n2;
        }
        if (!Character.isLetter(proposedName.charAt(0))) {
            return VdbPlugin.UTIL.getString(String.valueOf(PREFIX) + "translatorNameMustStartWithLetter", new Object[0]);
        }
        return null;
    }

    public static String validateType(String proposedType) {
        if (StringUtilities.isEmpty((String)proposedType)) {
            return VdbPlugin.UTIL.getString(String.valueOf(PREFIX) + "emptyTranslatorType", new Object[0]);
        }
        char[] cArray = proposedType.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetterOrDigit(c) && c != '-') {
                return VdbPlugin.UTIL.getString(String.valueOf(PREFIX) + "invalidTranslatorType", (Object)proposedType);
            }
            ++n2;
        }
        if (!Character.isLetter(proposedType.charAt(0))) {
            return VdbPlugin.UTIL.getString(String.valueOf(PREFIX) + "translatorTypeMustStartWithLetter", new Object[0]);
        }
        return null;
    }

    public TranslatorOverride(Vdb vdb, String name, String type, String description) {
        assert (name != null);
        assert (type != null);
        this.type = type;
        this.setVdb(vdb);
        this.setName(name == null ? "" : name);
        this.setDescription(description == null ? "" : description);
    }

    public TranslatorOverride(Vdb vdb, TranslatorElement element) {
        this(vdb, element.getName(), element.getType(), element.getDescription());
        for (PropertyElement property : element.getProperties()) {
            TranslatorPropertyDefinition propDefn = new TranslatorPropertyDefinition(property.getName(), property.getValue());
            TranslatorOverrideProperty prop = new TranslatorOverrideProperty(propDefn, property.getValue());
            this.overrideProps.put(propDefn.getId(), prop);
            prop.addListener((PropertyChangeListener)this);
        }
    }

    public void addProperty(TranslatorOverrideProperty newProperty) {
        this.addProperty(newProperty, true);
    }

    public void addProperty(TranslatorOverrideProperty newProperty, boolean firePropertyEvent) {
        assert (newProperty != null);
        TranslatorOverrideProperty obj = this.overrideProps.put(newProperty.getDefinition().getId(), newProperty);
        newProperty.addListener((PropertyChangeListener)this);
        if (firePropertyEvent) {
            this.setModified(this, "translatorOverrideProperty", obj, newProperty);
        }
    }

    @Override
    public int compareTo(TranslatorOverride vdbTranslator) {
        return this.getName().compareTo(vdbTranslator.getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.getName().equals(((TranslatorOverride)obj).getName());
    }

    public TranslatorOverrideProperty[] getOverrideProperties() {
        TranslatorOverrideProperty[] props = new TranslatorOverrideProperty[this.overrideProps.size()];
        int i = 0;
        for (TranslatorOverrideProperty property : this.overrideProps.values()) {
            props[i++] = property;
        }
        return props;
    }

    public List<String> getPropertyNames() {
        return Arrays.asList(this.overrideProps.keySet().toArray(new String[this.overrideProps.size()]));
    }

    public String getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    public void markAsUserDefined(TranslatorOverrideProperty property) {
        property.getDefinition().markAsUserDefined(property.getOverriddenValue());
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        TranslatorOverrideProperty property = (TranslatorOverrideProperty)event.getSource();
        this.setModified(this, "translatorOverrideProperty", event.getOldValue(), property);
    }

    public boolean removeOverrideProperty(String propName) {
        return this.removeOverrideProperty(propName, true);
    }

    public boolean removeOverrideProperty(String propName, boolean firePropertyEvent) {
        assert (propName != null);
        assert (this.overrideProps.containsKey(propName));
        TranslatorOverrideProperty prop = this.overrideProps.remove(propName);
        prop.removeListener((PropertyChangeListener)this);
        if (prop.getDefinition().isUserDefined()) {
            this.setModified(this, "translatorOverrideProperty", prop, null);
        }
        return false;
    }

    public void setOverrideValue(TranslatorPropertyDefinition propDefn, String newValue) {
        this.setOverrideValue(propDefn, newValue, true);
    }

    public void setOverrideValue(TranslatorPropertyDefinition propDefn, String newValue, boolean firePropertyEvent) {
        assert (propDefn != null);
        assert (this.overrideProps.containsKey(propDefn.getId()));
        TranslatorOverrideProperty prop = this.overrideProps.get(propDefn.getId());
        String oldValue = prop.getOverriddenValue();
        if (StringUtilities.equals((String)newValue, (String)oldValue)) {
            return;
        }
        prop.setValue(newValue);
        if (firePropertyEvent) {
            this.setModified(this, "translatorOverrideProperty", null, prop);
        }
    }

    public void updatePropertyDefinition(String propertyName, PropertyDefinition newServerPropDefn) {
        this.updatePropertyDefinition(propertyName, newServerPropDefn, true);
    }

    public void updatePropertyDefinition(String propertyName, PropertyDefinition newServerPropDefn, boolean firePropertyEvent) {
        assert (!StringUtilities.isEmpty((String)propertyName));
        assert (newServerPropDefn != null);
        TranslatorOverrideProperty prop = this.overrideProps.get(propertyName);
        if (prop != null) {
            prop.setDefinition(newServerPropDefn);
            if (firePropertyEvent) {
                this.setModified(this, "translatorOverrideProperty", null, prop);
            }
        }
    }

    @Override
    public TranslatorOverride clone() {
        TranslatorOverride clone = new TranslatorOverride(this.getVdb(), this.getName(), this.getType(), this.getDescription());
        this.cloneVdbObject(clone);
        for (TranslatorOverrideProperty property : this.overrideProps.values()) {
            TranslatorPropertyDefinition definition = property.getDefinition();
            TranslatorPropertyDefinition cloneDefn = new TranslatorPropertyDefinition(definition.getId(), definition.getDefaultValue());
            TranslatorOverrideProperty cloneProp = new TranslatorOverrideProperty(cloneDefn, property.getOverriddenValue());
            clone.addProperty(cloneProp, false);
        }
        return clone;
    }
}

