/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.io.File;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.teiid.core.designer.util.ChecksumUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.OperationUtil;
import org.teiid.core.designer.util.ZipUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbUnit;
import org.teiid.designer.vdb.manifest.EntryElement;
import org.teiid.designer.vdb.manifest.PropertyElement;

@ThreadSafe
public abstract class VdbEntry
extends VdbUnit {
    private IPath path;
    private final AtomicReference<Synchronization> synchronization = new AtomicReference<Synchronization>(Synchronization.NotApplicable);
    private long checksum;
    private final ReadWriteLock checksumLock = new ReentrantReadWriteLock();

    public VdbEntry(Vdb vdb, EntryElement element) throws Exception {
        this(vdb, Path.fromPortableString((String)element.getPath()));
        long propChecksum = -1L;
        for (PropertyElement property : element.getProperties()) {
            String name = property.getName();
            if (!"checksum".equals(name)) continue;
            propChecksum = Long.parseLong(property.getValue());
        }
        if (Synchronization.Synchronized.equals((Object)this.getSynchronization()) && this.checksum != propChecksum) {
            this.setSynchronization(Synchronization.NotSynchronized);
        }
        this.setDescription(element.getDescription() == null ? "" : element.getDescription());
    }

    public VdbEntry(Vdb vdb, IPath path) throws Exception {
        super(vdb);
        this.path = path;
        this.setName(path.removeFileExtension().lastSegment());
        this.setSynchronization(this.synchronizeEntry());
    }

    public IPath getPath() {
        return this.path;
    }

    public void setPath(IPath path) {
        this.path = path;
        super.setName(path.removeFileExtension().lastSegment());
    }

    public String getPathName() {
        if (this.path == null) {
            return null;
        }
        return this.path.lastSegment();
    }

    public String getDirectory() {
        if (this.path == null) {
            return null;
        }
        return this.path.removeLastSegments(1).toOSString();
    }

    private long computeChecksum(final IFile file) throws Exception {
        return (Long)OperationUtil.perform((OperationUtil.ReturningUnreliable)new OperationUtil.ReturningUnreliable<Long>(){
            private InputStream stream = null;

            public void doIfFails() {
                VdbEntry.this.setSynchronization(Synchronization.NotSynchronized);
            }

            public void finallyDo() throws Exception {
                if (this.stream != null) {
                    this.stream.close();
                }
            }

            public Long tryToDo() throws Exception {
                this.stream = file.getContents();
                if (this.stream == null) {
                    return -1L;
                }
                return ChecksumUtil.computeChecksum((InputStream)this.stream).getValue();
            }
        });
    }

    public void dispose() {
        new File(this.getVdb().getStagingFolder(), this.getPath().lastSegment()).delete();
    }

    public final boolean fileExistsInWorkspace() {
        return this.findFileInWorkspace() != null;
    }

    public IFile findFileInWorkspace() {
        IResource resource = ModelerCore.getWorkspace().getRoot().findMember(this.getPath());
        if (resource == null && this.getVdb() != null && this.getVdb().getSourceFile() != null && this.getVdb().getSourceFile().getProject() != null) {
            IProject vdbProject = this.getVdb().getSourceFile().getProject();
            resource = vdbProject.findMember(this.getPath());
        }
        if (!(resource instanceof IFile)) {
            this.setSynchronization(Synchronization.NotApplicable);
            return null;
        }
        return (IFile)resource;
    }

    public final long getChecksum() {
        this.checksumLock.readLock().lock();
        try {
            long l = this.checksum;
            return l;
        }
        finally {
            this.checksumLock.readLock().unlock();
        }
    }

    public final Synchronization getSynchronization() {
        return this.synchronization.get();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VdbEntry other = (VdbEntry)obj;
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public void save(ZipOutputStream out) throws Exception {
        String zipName = this.getPath().toString();
        if ((zipName = zipName.replace("\\", "/")).startsWith("/")) {
            zipName = zipName.substring(1, zipName.length());
        }
        ZipEntry zipEntry = new ZipEntry(zipName);
        zipEntry.setComment(this.getDescription());
        this.save(out, zipEntry, new File(this.getVdb().getStagingFolder(), this.getPath().toOSString()));
    }

    protected final void save(ZipOutputStream out, ZipEntry zipEntry, File file) throws Exception {
        ZipUtil.copy((File)file, (ZipEntry)zipEntry, (ZipOutputStream)out);
    }

    public void setSynchronization(Synchronization synchronization) {
        Synchronization oldSynchronization = this.getSynchronization();
        if (oldSynchronization == synchronization) {
            return;
        }
        this.synchronization.set(synchronization);
        this.setModified(this, "entry.synchronization", (Object)oldSynchronization, (Object)synchronization);
    }

    public void synchronize() throws Exception {
        if (this.synchronization.get() != Synchronization.NotSynchronized) {
            return;
        }
        this.setSynchronization(this.synchronizeEntry());
    }

    protected Synchronization synchronizeEntry() throws Exception {
        IFile workspaceFile = this.findFileInWorkspace();
        if (workspaceFile == null) {
            return Synchronization.NotApplicable;
        }
        long oldChecksum = 0L;
        this.checksumLock.writeLock().lock();
        try {
            oldChecksum = this.checksum;
            this.checksum = this.computeChecksum(workspaceFile);
            FileUtils.copy((File)workspaceFile.getLocation().toFile(), (File)new File(this.getVdb().getStagingFolder(), this.getPath().toOSString()).getParentFile(), (boolean)true);
        }
        finally {
            this.checksumLock.writeLock().unlock();
        }
        this.setModified(this, "entry.checksum", oldChecksum, this.checksum);
        return Synchronization.Synchronized;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("(name=");
        builder.append(this.getName());
        builder.append(", synchronization=");
        builder.append(this.synchronization);
        builder.append(", description=");
        builder.append(this.getDescription());
        this.toString(builder);
        builder.append(')');
        return builder.toString();
    }

    protected void toString(StringBuilder builder) {
    }

    public static enum Synchronization {
        Synchronized,
        NotSynchronized,
        NotApplicable;

    }
}

