/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.util.concurrent.atomic.AtomicReference;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbUnit;
import org.teiid.designer.vdb.manifest.ImportVdbElement;

public class VdbImportVdbEntry
extends VdbUnit {
    final AtomicReference<Integer> version = new AtomicReference();
    final AtomicReference<Boolean> importDataPolicies = new AtomicReference();

    public VdbImportVdbEntry(Vdb vdb, String importVdbName) {
        this.setVdb(vdb);
        this.setName(importVdbName);
        this.version.set(1);
        this.importDataPolicies.set(false);
    }

    public VdbImportVdbEntry(Vdb vdb, ImportVdbElement element) {
        this(vdb, element.getName());
        this.version.set(element.getVersion());
        this.importDataPolicies.set(element.isImportDataPolicies());
    }

    public int getVersion() {
        return this.version.get();
    }

    public void setVersion(int version) {
        int oldVersion = this.version.get();
        if (version == oldVersion) {
            return;
        }
        this.version.set(version);
        this.setModified(this, "importVdbEntryVersion", oldVersion, version);
    }

    public boolean isImportDataPolicies() {
        return this.importDataPolicies.get();
    }

    public void setImportDataPolicies(boolean importDataPolicies) {
        boolean oldImportDataPolicies = this.importDataPolicies.get();
        if (importDataPolicies == oldImportDataPolicies) {
            return;
        }
        this.importDataPolicies.set(importDataPolicies);
        this.setModified(this, "importVdbEntryDataPolicies", oldImportDataPolicies, importDataPolicies);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.importDataPolicies == null ? 0 : this.importDataPolicies.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VdbImportVdbEntry other = (VdbImportVdbEntry)obj;
        if (this.importDataPolicies == null ? other.importDataPolicies != null : !this.importDataPolicies.equals(other.importDataPolicies)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    @Override
    public VdbImportVdbEntry clone() {
        VdbImportVdbEntry clone = new VdbImportVdbEntry(this.getVdb(), this.getName());
        this.cloneVdbObject(clone);
        clone.setImportDataPolicies(this.isImportDataPolicies());
        clone.setVersion(this.getVersion());
        return clone;
    }
}

