/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbSource;

public class VdbSourceInfo {
    public static final String DEFAULT_SOURCE_NAME = "default";
    private Vdb vdb;
    private List<VdbSource> sources;
    private boolean supportsMultiSourceBindings;
    private boolean addColumn;
    private String columnAlias;

    public VdbSourceInfo(Vdb vdb) {
        this.vdb = vdb;
        this.sources = new ArrayList<VdbSource>();
    }

    public Vdb getVdb() {
        return this.vdb;
    }

    public Collection<VdbSource> getSources() {
        return this.sources;
    }

    public boolean add(String name, String jndiName, String translatorName) {
        if (this.getSource(name) != null) {
            return false;
        }
        for (VdbSource source : this.getSources()) {
            if (!source.getJndiName().equals(jndiName) || !source.getTranslatorName().equals(translatorName)) continue;
            return false;
        }
        VdbSource vdbSource = new VdbSource(this.getVdb(), name, jndiName, translatorName);
        this.sources.add(vdbSource);
        this.getVdb().setModified(this, "modelEntry.sources", null, vdbSource);
        return true;
    }

    public boolean removeSource(VdbSource source) {
        CoreArgCheck.isNotNull((Object)source, (String)"source");
        Iterator<VdbSource> iter = this.sources.iterator();
        while (iter.hasNext()) {
            VdbSource theSource = iter.next();
            if (!theSource.getName().equalsIgnoreCase(source.getName())) continue;
            iter.remove();
            this.getVdb().setModified(this, "modelEntry.sources", theSource, null);
            return true;
        }
        return false;
    }

    private VdbSource getSource(String name) {
        VdbSource result = null;
        for (VdbSource source : this.sources) {
            if (!source.getName().equalsIgnoreCase(name)) continue;
            result = source;
            break;
        }
        return result;
    }

    public VdbSource getSource(int index) {
        if (this.sources.isEmpty()) {
            this.add(DEFAULT_SOURCE_NAME, null, null);
        }
        if (index >= 0 && index < this.sources.size()) {
            VdbSource source = this.sources.get(index);
            return source;
        }
        return null;
    }

    public int getSourceCount() {
        return this.sources.size();
    }

    public boolean isEmpty() {
        return this.sources.isEmpty();
    }

    public boolean isMultiSource() {
        return this.supportsMultiSourceBindings;
    }

    public void setIsMultiSource(boolean value) {
        if (value != this.supportsMultiSourceBindings) {
            this.supportsMultiSourceBindings = value;
            this.getVdb().setModified(this, "modelEntry.sources", !value, value);
        }
    }

    public String getColumnAlias() {
        return this.columnAlias;
    }

    public void setColumnAlias(String columnAlias) {
        if (!StringUtilities.equals((String)this.columnAlias, (String)columnAlias)) {
            this.columnAlias = columnAlias;
            this.getVdb().setModified(this, "modelEntry.sources", this.columnAlias, columnAlias);
        }
    }

    public boolean isAddColumn() {
        return this.addColumn;
    }

    public void setAddColumn(boolean addColumn) {
        if (addColumn != this.addColumn) {
            this.addColumn = addColumn;
            this.getVdb().setModified(this, "modelEntry.sources", !addColumn, addColumn);
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("VdbSourceInfo : ");
        text.append("\tvdb name =").append(this.getVdb().getName());
        text.append("\n\tsource count =").append(this.getSourceCount());
        text.append("\n\tis multi-source = ").append(this.isMultiSource());
        text.append("\n\tis add column = ").append(this.isAddColumn());
        text.append("\n\tcolumn alias =").append(this.getColumnAlias());
        return text.toString();
    }
}

