/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.FileUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.ModelType;
import org.teiid.core.designer.util.OperationUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.VdbModelBuilder;
import org.teiid.designer.core.util.VdbHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.roles.DataRole;
import org.teiid.designer.transformation.ddl.TeiidModelToDdlGenerator;
import org.teiid.designer.vdb.BasicVdb;
import org.teiid.designer.vdb.TranslatorOverride;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbConstants;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.VdbFileEntry;
import org.teiid.designer.vdb.VdbImportInfo;
import org.teiid.designer.vdb.VdbImportVdbEntry;
import org.teiid.designer.vdb.VdbModelEntry;
import org.teiid.designer.vdb.VdbPlugin;
import org.teiid.designer.vdb.VdbSchemaEntry;
import org.teiid.designer.vdb.VdbSource;
import org.teiid.designer.vdb.VdbSourceInfo;
import org.teiid.designer.vdb.dynamic.DynamicModel;
import org.teiid.designer.vdb.dynamic.DynamicVdb;
import org.teiid.designer.vdb.dynamic.Metadata;
import org.teiid.designer.vdb.manifest.DataRoleElement;
import org.teiid.designer.vdb.manifest.EntryElement;
import org.teiid.designer.vdb.manifest.ImportVdbElement;
import org.teiid.designer.vdb.manifest.ModelElement;
import org.teiid.designer.vdb.manifest.PropertyElement;
import org.teiid.designer.vdb.manifest.TranslatorElement;
import org.teiid.designer.vdb.manifest.VdbElement;

@ThreadSafe
public final class XmiVdb
extends BasicVdb {
    private static final String WORKING_FILES = "working-files";
    private CopyOnWriteArraySet<VdbFileEntry> fileEntries;
    private CopyOnWriteArraySet<VdbFileEntry> udfJarEntries;
    private CopyOnWriteArraySet<VdbSchemaEntry> schemaEntries;
    private CopyOnWriteArraySet<VdbModelEntry> modelEntries;
    private VdbModelBuilder builder;
    private boolean excludeSourceMetadata;

    public static String getPreviewVdbPrefix(IResource resource) {
        String prefix;
        CoreArgCheck.isNotNull((Object)resource, (String)"resource is null");
        char delim = '_';
        StringBuilder name = new StringBuilder("PREVIEW_" + ModelerCore.workspaceUuid().toString() + delim);
        if (resource instanceof IFile) {
            IPath path = resource.getParent().getFullPath();
            String[] stringArray = path.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                name.append(segment).append(delim);
                ++n2;
            }
        }
        if ((prefix = name.toString()).contains(" ")) {
            prefix = prefix.replaceAll(" ", "_");
        }
        return prefix;
    }

    public XmiVdb() {
    }

    public XmiVdb(IFile file, boolean preview) throws Exception {
        super(file);
        this.setPreview(preview);
    }

    public XmiVdb(IFile file) throws Exception {
        this(file, false);
    }

    private Set<VdbFileEntry> fileEntries() {
        if (this.fileEntries == null) {
            this.fileEntries = new CopyOnWriteArraySet();
        }
        return this.fileEntries;
    }

    private Set<VdbFileEntry> udfJarEntries() {
        if (this.udfJarEntries == null) {
            this.udfJarEntries = new CopyOnWriteArraySet();
        }
        return this.udfJarEntries;
    }

    private Set<VdbSchemaEntry> schemaEntries() {
        if (this.schemaEntries == null) {
            this.schemaEntries = new CopyOnWriteArraySet();
        }
        return this.schemaEntries;
    }

    private Set<VdbModelEntry> modelEntries() {
        if (this.modelEntries == null) {
            this.modelEntries = new CopyOnWriteArraySet();
        }
        return this.modelEntries;
    }

    private VdbModelBuilder builder() {
        if (this.builder == null) {
            this.builder = new VdbModelBuilder();
        }
        return this.builder;
    }

    @Override
    public void read(final IFile file) throws Exception {
        CoreArgCheck.isNotNull((Object)file);
        if (!file.exists()) {
            return;
        }
        if (file.getLocation().toFile().length() == 0L) {
            return;
        }
        this.setSourceFile(file);
        final boolean[] previewable = new boolean[1];
        final int[] vdbVersion = new int[1];
        final int[] queryTimeout = new int[1];
        final String[] valDateTime = new String[1];
        final String[] valVersion = new String[1];
        final boolean[] autoGen = new boolean[1];
        final String[] secDomain = new String[1];
        final String[] gssPatt = new String[1];
        final String[] pwdPatt = new String[1];
        final String[] authType = new String[1];
        OperationUtil.perform((OperationUtil.Unreliable)new OperationUtil.Unreliable(){
            ZipFile archive = null;
            InputStream entryStream = null;

            public void doIfFails() {
            }

            public void finallyDo() throws Exception {
                if (this.entryStream != null) {
                    this.entryStream.close();
                }
                if (this.archive != null) {
                    this.archive.close();
                }
            }

            public void tryToDo() throws Exception {
                XmiVdb vdb = XmiVdb.this;
                this.archive = new ZipFile(file.getLocation().toString());
                Enumeration<? extends ZipEntry> iter = this.archive.entries();
                while (iter.hasMoreElements()) {
                    ZipEntry zipEntry = iter.nextElement();
                    try {
                        this.entryStream = this.archive.getInputStream(zipEntry);
                        if (zipEntry.getName().equals("META-INF/vdb.xml")) {
                            VdbSchemaEntry vdbSchemaEntry;
                            IPath path;
                            Unmarshaller unmarshaller = XmiVdb.this.getJaxbContext().createUnmarshaller();
                            unmarshaller.setSchema(XmiVdb.this.getManifestSchema());
                            VdbElement manifest = (VdbElement)unmarshaller.unmarshal(this.entryStream);
                            XmiVdb.this.setDescription(manifest.getDescription());
                            vdbVersion[0] = manifest.getVersion();
                            vdb.setName(manifest.getName());
                            for (PropertyElement propertyElement : manifest.getProperties()) {
                                String name = propertyElement.getName();
                                String value = propertyElement.getValue();
                                if ("preview".equals(name)) {
                                    previewable[0] = Boolean.parseBoolean(value);
                                    continue;
                                }
                                if ("query-timeout".equals(name)) {
                                    int timeoutMillis = Integer.parseInt(value);
                                    if (timeoutMillis <= 0) continue;
                                    queryTimeout[0] = timeoutMillis / 1000;
                                    continue;
                                }
                                if ("allowed-languages".equals(name)) {
                                    String[] langs;
                                    String[] stringArray = langs = StringUtilities.parseCommaDelimitedString((String)value);
                                    int n = langs.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String lang = stringArray[n2];
                                        XmiVdb.this.addAllowedLanguage(lang);
                                        ++n2;
                                    }
                                    continue;
                                }
                                if ("validationDateTime".equals(name)) {
                                    valDateTime[0] = value;
                                    continue;
                                }
                                if ("validationVersion".equals(name)) {
                                    valVersion[0] = value;
                                    continue;
                                }
                                if ("security-domain".equals(name)) {
                                    secDomain[0] = value;
                                    continue;
                                }
                                if ("gss-pattern".equals(name)) {
                                    gssPatt[0] = value;
                                    continue;
                                }
                                if ("password-pattern".equals(name)) {
                                    pwdPatt[0] = value;
                                    continue;
                                }
                                if ("authentication-type".equals(name)) {
                                    authType[0] = value;
                                    continue;
                                }
                                if ("{http://teiid.org/rest}auto-generate".equals(name)) {
                                    autoGen[0] = Boolean.parseBoolean(value);
                                    continue;
                                }
                                XmiVdb.this.setProperty(name, value);
                            }
                            for (ModelElement modelElement : manifest.getModels()) {
                                path = null;
                                if (modelElement.getPath() != null) {
                                    path = Path.fromPortableString((String)modelElement.getPath());
                                }
                                if (path != null && ModelUtil.isXsdFile((IPath)path)) {
                                    vdbSchemaEntry = new VdbSchemaEntry(XmiVdb.this, (EntryElement)modelElement);
                                    XmiVdb.this.schemaEntries().add(vdbSchemaEntry);
                                    continue;
                                }
                                XmiVdb.this.modelEntries().add(new VdbModelEntry(XmiVdb.this, modelElement));
                            }
                            for (VdbModelEntry vdbModelEntry : XmiVdb.this.modelEntries()) {
                                vdbModelEntry.initializeImports();
                            }
                            for (EntryElement entryElement : manifest.getEntries()) {
                                path = Path.fromPortableString((String)entryElement.getPath());
                                if (ModelUtil.isXsdFile((IPath)path)) {
                                    vdbSchemaEntry = new VdbSchemaEntry(XmiVdb.this, entryElement);
                                    XmiVdb.this.schemaEntries().add(vdbSchemaEntry);
                                    continue;
                                }
                                VdbFileEntry vdbFileEntry = new VdbFileEntry((Vdb)XmiVdb.this, entryElement);
                                switch (vdbFileEntry.getFileType()) {
                                    case UDFJar: {
                                        XmiVdb.this.udfJarEntries().add(vdbFileEntry);
                                        break;
                                    }
                                    case UserFile: {
                                        XmiVdb.this.fileEntries().add(vdbFileEntry);
                                    }
                                }
                            }
                            for (ImportVdbElement importVdbElement : manifest.getImportVdbEntries()) {
                                if (XmiVdb.this.getImportVdbEntry(importVdbElement.getName()) != null) continue;
                                XmiVdb.this.addImport(new VdbImportVdbEntry((Vdb)XmiVdb.this, importVdbElement));
                            }
                            for (TranslatorElement translatorElement : manifest.getTranslators()) {
                                XmiVdb.this.addTranslator(new TranslatorOverride(XmiVdb.this, translatorElement));
                            }
                            for (DataRoleElement dataRoleElement : manifest.getDataPolicies()) {
                                DataRole dataRole = new DataRole(dataRoleElement);
                                XmiVdb.this.addDataRole(dataRole);
                            }
                            continue;
                        }
                        if (zipEntry.isDirectory()) continue;
                        FileUtils.copy((InputStream)this.entryStream, (File)new File(XmiVdb.this.getStagingFolder(), zipEntry.getName()));
                    }
                    finally {
                        if (this.entryStream != null) {
                            this.entryStream.close();
                        }
                    }
                }
                XmiVdb.this.setChanged(false);
            }
        });
        this.setPreview(previewable[0]);
        this.setVersion(vdbVersion[0]);
        this.setQueryTimeout(queryTimeout[0]);
        this.setAutoGenerateRESTWar(autoGen[0]);
        this.setSecurityDomain(secDomain[0]);
        this.setGssPattern(gssPatt[0]);
        this.setPasswordPattern(pwdPatt[0]);
        this.setAuthenticationType(authType[0]);
        if (valDateTime[0] != null) {
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
            this.setValidationDateTime(format.parse(valDateTime[0]));
        }
        this.setValidationVersion(valVersion[0]);
    }

    @Override
    public final <T extends VdbEntry> T addEntry(IPath path) throws Exception {
        CoreArgCheck.isNotNull((Object)path);
        if (ModelUtil.isXsdFile((IPath)path)) {
            return (T)this.addSchemaEntry(path);
        }
        if (ModelUtil.isModelFile((IPath)path) && !ModelUtil.isXsdFile((IPath)path)) {
            return (T)this.addModelEntry(path);
        }
        String fileType = FileUtil.guessFileType((File)path.toFile());
        VdbFileEntry.FileEntryType fileEntryType = VdbFileEntry.FileEntryType.UserFile;
        if ("application/java-archive".equals(fileType)) {
            fileEntryType = VdbFileEntry.FileEntryType.UDFJar;
        }
        return (T)this.addFileEntry(path, fileEntryType);
    }

    private VdbSchemaEntry addSchemaEntry(IPath path) throws Exception {
        VdbSchemaEntry schemaEntry = new VdbSchemaEntry(this, path);
        VdbSchemaEntry addedEntry = this.addEntry(schemaEntry, this.schemaEntries());
        if (schemaEntry == addedEntry) {
            schemaEntry.synchronizeSchemaEntry();
        } else {
            schemaEntry = addedEntry;
        }
        return schemaEntry;
    }

    private VdbFileEntry addFileEntry(IPath name, VdbFileEntry.FileEntryType entryType) throws Exception {
        CoreArgCheck.isNotNull((Object)((Object)entryType));
        Set<VdbFileEntry> entries = null;
        switch (entryType) {
            case UDFJar: {
                entries = this.udfJarEntries();
                break;
            }
            case UserFile: {
                entries = this.fileEntries();
            }
        }
        return this.addEntry(new VdbFileEntry(this, name, entryType), entries);
    }

    private <T extends VdbEntry> T addEntry(T entry, Set<T> entries) {
        if (!entries.add(entry)) {
            for (VdbEntry existingEntry : entries) {
                if (!existingEntry.equals(entry)) continue;
                return (T)existingEntry;
            }
        }
        this.setModified(this, "entryAdded", null, entry);
        return entry;
    }

    private VdbModelEntry addModelEntry(IPath name) throws Exception {
        VdbModelEntry modelEntry = new VdbModelEntry(this, name);
        VdbModelEntry addedEntry = this.addEntry(modelEntry, this.modelEntries());
        if (modelEntry == addedEntry) {
            modelEntry.synchronizeModelEntry();
        } else {
            modelEntry = addedEntry;
        }
        return modelEntry;
    }

    @Override
    public final void synchronizeUdfJars(Set<VdbFileEntry> newJarEntries) {
        HashSet<VdbFileEntry> allRequiredUdfJars = new HashSet<VdbFileEntry>(newJarEntries);
        for (VdbModelEntry entry : this.modelEntries()) {
            Set<VdbFileEntry> jarEntries = entry.getUdfJars();
            allRequiredUdfJars.addAll((Collection<VdbFileEntry>)jarEntries);
        }
        HashMap<String, VdbFileEntry> allRequiredJarsMap = new HashMap<String, VdbFileEntry>();
        for (VdbFileEntry fileEntry : allRequiredUdfJars) {
            allRequiredJarsMap.put(fileEntry.getPath().toOSString(), fileEntry);
        }
        Set<String> currentUdfJarNames = this.getUdfJarNames();
        boolean jarsAdded = false;
        for (VdbFileEntry modelUdfJar : allRequiredUdfJars) {
            if (currentUdfJarNames.contains(modelUdfJar.getPath().toString())) continue;
            this.udfJarEntries().add(modelUdfJar);
            jarsAdded = true;
        }
        boolean jarsRemoved = false;
        currentUdfJarNames = this.getUdfJarNames();
        for (String currentJarName : currentUdfJarNames) {
            Set allRequiredJarNames = allRequiredJarsMap.keySet();
            if (allRequiredJarNames.contains(currentJarName)) continue;
            for (VdbEntry vdbEntry : this.udfJarEntries()) {
                String entryPath = vdbEntry.getPath().toOSString();
                if (entryPath == null || !entryPath.equals(currentJarName)) continue;
                this.udfJarEntries().remove(vdbEntry);
                break;
            }
            jarsRemoved = true;
        }
        if (jarsAdded || jarsRemoved) {
            this.setModified(this, "udfJarsModified", null, null);
        }
    }

    @Override
    public final void close() {
        this.fileEntries().clear();
        this.udfJarEntries().clear();
        this.schemaEntries().clear();
        this.modelEntries().clear();
        FileUtils.removeDirectoryAndChildren((File)VdbPlugin.singleton().getStateLocation().append(this.getSourceFile().getFullPath().segment(0)).toFile());
        super.close();
    }

    public final Set<VdbEntry> getEntries() {
        HashSet<VdbEntry> entries = new HashSet<VdbEntry>();
        entries.addAll(this.schemaEntries());
        entries.addAll(this.fileEntries());
        entries.addAll(this.udfJarEntries());
        return Collections.unmodifiableSet(entries);
    }

    @Override
    public final Set<VdbSchemaEntry> getSchemaEntries() {
        return Collections.unmodifiableSet(this.schemaEntries());
    }

    @Override
    public final Set<VdbFileEntry> getUdfJarEntries() {
        return Collections.unmodifiableSet(this.udfJarEntries());
    }

    @Override
    public final Set<String> getUdfJarNames() {
        HashSet<String> udfJarNames = new HashSet<String>();
        for (VdbFileEntry entry : this.udfJarEntries()) {
            String entryPath = entry.getPath().toOSString();
            udfJarNames.add(entryPath);
        }
        return Collections.unmodifiableSet(udfJarNames);
    }

    @Override
    public final Set<VdbFileEntry> getUserFileEntries() {
        return Collections.unmodifiableSet(this.fileEntries());
    }

    @Override
    public final Set<VdbModelEntry> getModelEntries() {
        HashSet<VdbModelEntry> entries = new HashSet<VdbModelEntry>();
        for (VdbModelEntry entry : this.modelEntries()) {
            if (entry.isBuiltIn()) continue;
            entries.add(entry);
        }
        return Collections.unmodifiableSet(entries);
    }

    private final Collection<File> convertEntries(Collection<? extends VdbEntry> entries) {
        ArrayList<File> entryFiles = new ArrayList<File>();
        for (VdbEntry vdbEntry : entries) {
            entryFiles.add(new File(this.getStagingFolder().getAbsolutePath(), vdbEntry.getPath().toOSString()));
        }
        return Collections.unmodifiableCollection(entryFiles);
    }

    @Override
    public final Collection<File> getModelFiles() {
        return this.convertEntries(this.getModelEntries());
    }

    @Override
    public final Collection<File> getSchemaFiles() {
        return this.convertEntries(this.getSchemaEntries());
    }

    private final VdbImportVdbEntry getImportVdbEntry(String vdbName) {
        for (VdbImportVdbEntry entry : this.getImports()) {
            if (!entry.getName().equalsIgnoreCase(vdbName)) continue;
            return entry;
        }
        return null;
    }

    private final void handleRemovedVdbModelEntry(String vdbModelEntryName) {
        this.removeStaleVdbImports();
    }

    @Override
    public final boolean isSynchronized() {
        for (VdbModelEntry vdbModelEntry : this.modelEntries()) {
            if (vdbModelEntry.getSynchronization() != VdbEntry.Synchronization.NotSynchronized) continue;
            return false;
        }
        for (VdbEntry vdbEntry : this.getEntries()) {
            if (vdbEntry.getSynchronization() != VdbEntry.Synchronization.NotSynchronized) continue;
            return false;
        }
        return true;
    }

    public final void registerImportVdbs(Collection<VdbImportInfo> vdbImports, String modelName) {
        this.removeStaleVdbImports();
        for (VdbImportInfo vdbImport : vdbImports) {
            if (this.getImportVdbEntry(vdbImport.getName()) != null) continue;
            this.addImport(vdbImport.getName(), vdbImport.getVersion());
        }
    }

    private final void removeStaleVdbImports() {
        HashSet<String> allImportVdbNames = new HashSet<String>();
        for (VdbModelEntry entry : this.getModelEntries()) {
            allImportVdbNames.addAll(entry.getImportVdbNames());
        }
        HashSet<VdbImportVdbEntry> staleImports = new HashSet<VdbImportVdbEntry>();
        for (VdbImportVdbEntry entry : this.getImports()) {
            if (allImportVdbNames.contains(entry.getName())) continue;
            staleImports.add(entry);
        }
        for (VdbImportVdbEntry entry : staleImports) {
            this.removeImport(entry);
        }
    }

    @Override
    public final boolean removeEntry(VdbEntry entry) {
        boolean removed = false;
        entry.dispose();
        if (entry instanceof VdbModelEntry) {
            String entryPath = entry.getPath().toOSString();
            removed = this.modelEntries().remove(entry);
            this.synchronizeUdfJars(new HashSet<VdbFileEntry>());
            this.handleRemovedVdbModelEntry(entryPath);
        } else if (entry instanceof VdbSchemaEntry) {
            String entryName = entry.getPath().toOSString();
            removed = this.schemaEntries().remove(entry);
            this.handleRemovedVdbModelEntry(entryName);
        } else {
            removed = this.fileEntries().remove(entry);
            if (!removed) {
                removed = this.udfJarEntries().remove(entry);
            }
        }
        if (removed) {
            this.setModified(this, "entryRemoved", entry, null);
        }
        return removed;
    }

    @Override
    public void save() throws Exception {
        final VdbElement vdbElement = new VdbElement(this);
        final File tmpFolder = VdbPlugin.singleton().getStateLocation().toFile();
        OperationUtil.perform((OperationUtil.Unreliable)new OperationUtil.Unreliable(){
            ZipOutputStream out = null;

            public void doIfFails() {
            }

            public void finallyDo() throws Exception {
                if (this.out != null) {
                    this.out.close();
                }
            }

            public void tryToDo() throws Exception {
                IPath path = XmiVdb.this.getSourceFile().getFullPath();
                File tmpArchive = File.createTempFile(path.removeFileExtension().toString(), String.valueOf('.') + path.getFileExtension(), tmpFolder);
                tmpArchive.getParentFile().mkdirs();
                this.out = new ZipOutputStream(new FileOutputStream(tmpArchive));
                try {
                    IMarker[] markers;
                    ZipEntry zipEntry = new ZipEntry("META-INF/vdb.xml");
                    zipEntry.setComment(XmiVdb.this.getDescription());
                    this.out.putNextEntry(zipEntry);
                    try {
                        Marshaller marshaller = XmiVdb.this.getJaxbContext().createMarshaller();
                        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                        marshaller.setSchema(XmiVdb.this.getManifestSchema());
                        marshaller.marshal((Object)vdbElement, (OutputStream)this.out);
                    }
                    finally {
                        this.out.closeEntry();
                    }
                    IFile file = XmiVdb.this.getSourceFile();
                    if (file != null && file.exists() && (markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2)) != null) {
                        IMarker[] iMarkerArray = markers;
                        int n = markers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMarker marker = iMarkerArray[n2];
                            marker.delete();
                            ++n2;
                        }
                    }
                    for (VdbEntry entry : XmiVdb.this.getEntries()) {
                        entry.save(this.out);
                    }
                    for (VdbEntry entry : XmiVdb.this.modelEntries()) {
                        ((VdbModelEntry)entry).save(this.out);
                    }
                }
                finally {
                    this.out.close();
                    this.out = null;
                }
                File archiveFile = XmiVdb.this.getSourceFile().getLocation().toFile();
                try {
                    Files.deleteIfExists(archiveFile.toPath());
                }
                catch (Exception ex) {
                    throw new Exception(VdbPlugin.UTIL.getString("unableToDelete", (Object)archiveFile), ex);
                }
                if (!tmpArchive.renameTo(archiveFile)) {
                    throw new Exception(VdbPlugin.UTIL.getString("unableToRename", new Object[]{tmpArchive, archiveFile}));
                }
                if (XmiVdb.this.isModified()) {
                    XmiVdb.this.setChanged(false);
                }
                XmiVdb.this.notifyChangeListeners(this, "saved", null, null);
            }
        });
    }

    private final void synchronize(Collection<VdbEntry> entries) throws Exception {
        for (VdbEntry entry : entries) {
            if (entry.getSynchronization() != VdbEntry.Synchronization.NotSynchronized) continue;
            entry.synchronize();
        }
    }

    @Override
    public final void synchronize() throws Exception {
        this.getBuilder().start();
        this.synchronize(new HashSet<VdbEntry>(this.modelEntries()));
        this.synchronize(this.getEntries());
        this.getBuilder().stop();
    }

    public VdbModelBuilder getBuilder() {
        return this.builder();
    }

    public boolean excludeSourceMetadata() {
        return this.excludeSourceMetadata;
    }

    public void setExcludeSourceMetadata(boolean excludeSourceMetadata) {
        this.excludeSourceMetadata = excludeSourceMetadata;
    }

    @Override
    public void addDynamicModel(DynamicModel model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<DynamicModel> getDynamicModels() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeDynamicModel(String modelToRemove) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XmiVdb xmiVdbConvert(IFile destination, Properties options) throws Exception {
        return this;
    }

    @Override
    public DynamicVdb dynVdbConvert(IFile destination, Properties options) throws Exception {
        try {
            VdbPlugin.singleton().setConversionInProgress(true);
            DynamicVdb dynVdb = new DynamicVdb(destination);
            this.populateVdb(dynVdb);
            dynVdb.getProperties().remove("preview");
            this.getProperties().remove("preview");
            MultiStatus generateStatus = new MultiStatus(VdbConstants.PLUGIN_ID, 0, "Exported Dynamic VDB", null);
            for (VdbFileEntry vdbFileEntry : this.getUdfJarEntries()) {
                dynVdb.getProperties().setProperty(VdbHelper.VdbFolders.UDF.getWriteFolder(), vdbFileEntry.getName());
                generateStatus.add((IStatus)new Status(2, PLUGIN_ID, VdbPlugin.UTIL.getString("XmiVdb.udfPropertyAdded", (Object)vdbFileEntry.getName())));
            }
            for (VdbModelEntry vdbModelEntry : this.getModelEntries()) {
                VdbSourceInfo sourceInfo = vdbModelEntry.getSourceInfo();
                DynamicModel model = new DynamicModel();
                model.setName(vdbModelEntry.getName());
                model.setDescription(vdbModelEntry.getDescription());
                model.setVisible(vdbModelEntry.isVisible());
                for (Map.Entry<Object, Object> prop : vdbModelEntry.getProperties().entrySet()) {
                    String name = prop.getKey().toString();
                    if ("indexName".equals(name) || "checksum".equals(name)) continue;
                    model.setProperty(name, prop.getValue().toString());
                }
                DynamicModel.Type type = DynamicModel.Type.fromString(vdbModelEntry.getType());
                model.setModelType(type);
                model.setAllowMultiSource(sourceInfo.isMultiSource());
                model.setAddColumn(sourceInfo.isAddColumn());
                model.setColumnAlias(sourceInfo.getColumnAlias());
                for (VdbSource source : sourceInfo.getSources()) {
                    VdbSource clone = source.clone();
                    model.addSource(clone);
                }
                boolean isNonRelationalModel = false;
                if (vdbModelEntry.getType().equals(ModelType.Type.VIRTUAL.getName()) || !this.excludeSourceMetadata) {
                    TeiidModelToDdlGenerator generator = new TeiidModelToDdlGenerator();
                    IFile entryFile = null;
                    entryFile = VdbEntry.Synchronization.Synchronized == vdbModelEntry.getSynchronization() ? vdbModelEntry.findFileInWorkspace() : this.createEntryFile(vdbModelEntry);
                    ModelWorkspaceManager workspaceManager = ModelWorkspaceManager.getModelWorkspaceManager();
                    ModelResource modelResource = (ModelResource)workspaceManager.findModelWorkspaceItem((IResource)entryFile, true);
                    if (modelResource == null) {
                        throw new Exception("Failed to get model resource for " + entryFile.getLocation().toOSString());
                    }
                    if ("http://www.metamatrix.com/metamodels/WebService".equalsIgnoreCase(modelResource.getPrimaryMetamodelUri()) || "http://www.metamatrix.com/metamodels/MetaMatrixFunction".equalsIgnoreCase(modelResource.getPrimaryMetamodelUri()) || "http://www.eclipse.org/xsd/2002/XSD".equalsIgnoreCase(modelResource.getPrimaryMetamodelUri()) || "http://www.metamatrix.com/metamodels/XmlDocument".equalsIgnoreCase(modelResource.getPrimaryMetamodelUri()) || "http://www.metamatrix.com/metamodels/Extension".equalsIgnoreCase(modelResource.getPrimaryMetamodelUri())) {
                        isNonRelationalModel = true;
                        generateStatus.add((IStatus)new Status(2, PLUGIN_ID, VdbPlugin.UTIL.getString("XmiVdb.modelNotIncludedMessage", (Object)vdbModelEntry.getName())));
                    }
                    if (!isNonRelationalModel) {
                        String ddl = generator.generate(modelResource);
                        Metadata metadata = new Metadata(ddl, Metadata.Type.DDL);
                        model.setMetadata(metadata);
                    }
                }
                if (isNonRelationalModel) continue;
                dynVdb.addDynamicModel(model);
            }
            HashSet<VdbEntry> hashSet = new HashSet<VdbEntry>();
            hashSet.addAll(this.getSchemaEntries());
            hashSet.addAll(this.getUserFileEntries());
            for (VdbEntry entry : hashSet) {
                generateStatus.add((IStatus)new Status(2, PLUGIN_ID, VdbPlugin.UTIL.getString("XmiVdb.fileNotIncludedMessage", (Object)entry.getPath())));
            }
            dynVdb.setStatus((IStatus)generateStatus);
            DynamicVdb dynamicVdb = dynVdb;
            return dynamicVdb;
        }
        finally {
            VdbPlugin.singleton().setConversionInProgress(false);
        }
    }

    private IFile createEntryFile(VdbModelEntry entry) throws Exception {
        IFile entryFile;
        File realFile = new File(this.getStagingFolder(), entry.getPath().toOSString());
        if (!realFile.exists()) {
            throw new FileNotFoundException(realFile.getAbsolutePath());
        }
        IProject vdbProject = this.getSourceFile().getProject();
        IFolder workingFolder = vdbProject.getFolder(WORKING_FILES);
        if (!workingFolder.exists()) {
            workingFolder.create(4096, true, null);
        }
        if ((entryFile = workingFolder.getFile(entry.getPathName())).exists()) {
            entryFile.delete(true, null);
        }
        entryFile.createLink((IPath)new Path(realFile.getAbsolutePath()), 4096, null);
        return entryFile;
    }

    @Override
    public XmiVdb clone() {
        try {
            XmiVdb clone = new XmiVdb(this.getSourceFile());
            return clone;
        }
        catch (Exception ex) {
            VdbPlugin.UTIL.log((Throwable)ex);
            return null;
        }
    }
}

