/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.dynamic;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.comments.Commentable;
import org.teiid.designer.vdb.manifest.ConditionElement;
import org.teiid.designer.vdb.manifest.DataRoleElement;
import org.teiid.designer.vdb.manifest.EntryElement;
import org.teiid.designer.vdb.manifest.ImportVdbElement;
import org.teiid.designer.vdb.manifest.MaskElement;
import org.teiid.designer.vdb.manifest.MetadataElement;
import org.teiid.designer.vdb.manifest.ModelElement;
import org.teiid.designer.vdb.manifest.PermissionElement;
import org.teiid.designer.vdb.manifest.ProblemElement;
import org.teiid.designer.vdb.manifest.PropertyElement;
import org.teiid.designer.vdb.manifest.SourceElement;
import org.teiid.designer.vdb.manifest.TranslatorElement;
import org.teiid.designer.vdb.manifest.VdbElement;
import org.teiid.designer.vdb.manifest.Visitor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class CommentReader
extends DefaultHandler2
implements Commentable,
StringConstants {
    private final VdbElement manifest;
    private Stack<String> comments = new Stack();
    private MyElement currentElement;

    public CommentReader(VdbElement manifest) {
        this.manifest = manifest;
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        if (value.length() == 0) {
            return;
        }
        this.comments.push(value);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String elementType = localName == null || localName.isEmpty() ? qName : localName;
        this.currentElement = new MyElement(elementType, this.currentElement);
        this.currentElement.setAttributes(attributes);
        this.currentElement.setComments(this.comments);
        this.comments.clear();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length).trim();
        this.currentElement.setValue(value);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentElement == null) {
            return;
        }
        if (this.currentElement.parent() != null) {
            this.currentElement = this.currentElement.parent();
        }
    }

    public void read(File xmlFile) throws Exception {
        try (FileInputStream xmlStream = null;){
            SAXParserFactory factory = SAXParserFactory.newInstance();
            xmlStream = new FileInputStream(xmlFile);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            saxParser.parse((InputStream)xmlStream, (DefaultHandler)this);
            ManifestVisitor visitor = new ManifestVisitor(this.currentElement);
            this.manifest.accept(visitor);
        }
    }

    private static class ManifestVisitor
    implements Visitor {
        private MyElement context;

        public ManifestVisitor(MyElement context) {
            this.context = context;
            while (this.context.parent() != null) {
                this.context = this.context.parent();
            }
        }

        private boolean checkContext(String elementType) {
            if (this.context == null) {
                return false;
            }
            return this.context.type().equals(elementType);
        }

        private String attribute(String attrName) {
            if (this.context == null || this.context.attributes() == null) {
                return "";
            }
            return this.context.attributes().getProperty(attrName);
        }

        private boolean nameAttribute(String name) {
            if (name == null) {
                return false;
            }
            return name.equals(this.attribute("name"));
        }

        @Override
        public void visit(ConditionElement element) {
            if (!this.checkContext("condition")) {
                return;
            }
            element.getComments().addCommentSet("", this.context.comments());
        }

        @Override
        public void visit(DataRoleElement drElement) {
            if (!this.checkContext("data-role")) {
                return;
            }
            if (!this.nameAttribute(drElement.getName())) {
                return;
            }
            drElement.getComments().addCommentSet("", this.context.comments());
            MyElement drContext = this.context;
            Iterator<MyElement> iterator = drContext.children().iterator();
            while (iterator.hasNext()) {
                MyElement child;
                this.context = child = iterator.next();
                if (this.checkContext("description")) {
                    drElement.getComments().addCommentSet(this.context.type(), this.context.comments());
                    continue;
                }
                if (this.checkContext("mapped-role-name")) {
                    drElement.getComments().addCommentSet(String.valueOf(this.context.type()) + "-" + this.context.value(), this.context.comments());
                    continue;
                }
                if (!this.checkContext("permission")) continue;
                for (PermissionElement pe : drElement.getPermissions()) {
                    pe.accept(this);
                }
            }
            this.context = drContext;
        }

        @Override
        public void visit(EntryElement element) {
        }

        @Override
        public void visit(ImportVdbElement element) {
            if (!this.checkContext("import-vdb")) {
                return;
            }
            if (!this.nameAttribute(element.getName())) {
                return;
            }
            element.getComments().addCommentSet("", this.context.comments());
        }

        @Override
        public void visit(MaskElement element) {
            if (!this.checkContext("mask")) {
                return;
            }
            element.getComments().addCommentSet("", this.context.comments());
        }

        @Override
        public void visit(MetadataElement element) {
            if (!this.checkContext("metadata")) {
                return;
            }
            element.getComments().addCommentSet("", this.context.comments());
        }

        @Override
        public void visit(ModelElement modelElement) {
            if (!this.checkContext("model")) {
                return;
            }
            if (!this.nameAttribute(modelElement.getName())) {
                return;
            }
            modelElement.getComments().addCommentSet("", this.context.comments());
            MyElement modelContext = this.context;
            Iterator<MyElement> iterator = modelContext.children().iterator();
            while (iterator.hasNext()) {
                MyElement child;
                this.context = child = iterator.next();
                if (this.checkContext("description")) {
                    modelElement.getComments().addCommentSet(this.context.type(), this.context.comments());
                    continue;
                }
                if (this.checkContext("property")) {
                    for (PropertyElement pe : modelElement.getProperties()) {
                        pe.accept(this);
                    }
                    continue;
                }
                if (this.checkContext("source")) {
                    for (SourceElement se : modelElement.getSources()) {
                        se.accept(this);
                    }
                    continue;
                }
                if (!this.checkContext("metadata")) continue;
                for (MetadataElement me : modelElement.getMetadata()) {
                    me.accept(this);
                }
            }
            this.context = modelContext;
        }

        @Override
        public void visit(PermissionElement element) {
            MyElement child;
            if (!this.checkContext("permission")) {
                return;
            }
            String resourceName = null;
            MyElement permContext = this.context;
            Iterator<MyElement> iterator = this.context.children().iterator();
            while (iterator.hasNext()) {
                this.context = child = iterator.next();
                if (!this.checkContext("resource-name")) continue;
                resourceName = child.value();
                break;
            }
            this.context = permContext;
            if (!element.getResourceName().equals(resourceName)) {
                return;
            }
            element.getComments().addCommentSet("", this.context.comments());
            permContext = this.context;
            iterator = this.context.children().iterator();
            while (iterator.hasNext()) {
                this.context = child = iterator.next();
                if (this.checkContext("resource-name")) {
                    element.getComments().addCommentSet("resource-name", this.context.comments());
                    continue;
                }
                if (this.checkContext("mask")) {
                    element.getMask().accept(this);
                    continue;
                }
                if (this.checkContext("condition")) {
                    element.getCondition().accept(this);
                    continue;
                }
                if (!this.checkContext("allow-create") && !this.checkContext("allow-read") && !this.checkContext("allow-update") && !this.checkContext("allow-delete") && !this.checkContext("allow-execute") && !this.checkContext("allow-alter") && !this.checkContext("allow-language")) continue;
                element.getComments().addCommentSet(this.context.type(), this.context.comments());
            }
            this.context = permContext;
        }

        @Override
        public void visit(ProblemElement element) {
        }

        @Override
        public void visit(PropertyElement element) {
            if (!this.checkContext("property")) {
                return;
            }
            if (!this.nameAttribute(element.getName())) {
                return;
            }
            element.getComments().addCommentSet("", this.context.comments());
        }

        @Override
        public void visit(SourceElement element) {
            if (!this.checkContext("source")) {
                return;
            }
            if (!this.nameAttribute(element.getName())) {
                return;
            }
            element.getComments().addCommentSet("", this.context.comments());
        }

        @Override
        public void visit(TranslatorElement trElement) {
            if (!this.checkContext("translator")) {
                return;
            }
            if (!this.nameAttribute(trElement.getName())) {
                return;
            }
            trElement.getComments().addCommentSet("", this.context.comments());
            MyElement trContext = this.context;
            Iterator<MyElement> iterator = trContext.children().iterator();
            while (iterator.hasNext()) {
                MyElement child;
                this.context = child = iterator.next();
                if (!this.checkContext("property")) continue;
                for (PropertyElement pe : trElement.getProperties()) {
                    pe.accept(this);
                }
            }
            this.context = trContext;
        }

        @Override
        public void visit(VdbElement vdbElement) {
            if (!this.checkContext("vdb")) {
                return;
            }
            vdbElement.getComments().addCommentSet("", this.context.comments());
            MyElement vdbContext = this.context;
            Iterator<MyElement> iterator = vdbContext.children().iterator();
            while (iterator.hasNext()) {
                MyElement child;
                this.context = child = iterator.next();
                if (this.checkContext("description") || this.checkContext("connection-type")) {
                    vdbElement.getComments().addCommentSet(this.context.type(), this.context.comments());
                    continue;
                }
                if (this.checkContext("property")) {
                    for (PropertyElement pe : vdbElement.getProperties()) {
                        pe.accept(this);
                    }
                    continue;
                }
                if (this.checkContext("import-vdb")) {
                    for (ImportVdbElement ive : vdbElement.getImportVdbEntries()) {
                        ive.accept(this);
                    }
                    continue;
                }
                if (this.checkContext("model")) {
                    for (ModelElement me : vdbElement.getModels()) {
                        me.accept(this);
                    }
                    continue;
                }
                if (this.checkContext("translator")) {
                    for (TranslatorElement te : vdbElement.getTranslators()) {
                        te.accept(this);
                    }
                    continue;
                }
                if (!this.checkContext("data-role")) continue;
                for (DataRoleElement dre : vdbElement.getDataPolicies()) {
                    dre.accept(this);
                }
            }
            this.context = vdbContext;
        }
    }

    private static class MyElement {
        private String type;
        private String value;
        private int index;
        private Properties attributes = new Properties();
        private List<String> comments;
        private MyElement parent;
        private List<MyElement> children;

        public MyElement(String type, MyElement parent) {
            this.type = type;
            this.parent = parent;
            if (this.parent != null) {
                parent.addChild(this);
            }
        }

        public List<MyElement> children() {
            return Collections.unmodifiableList(this.children);
        }

        private void addChild(MyElement child) {
            if (this.children == null) {
                this.children = new ArrayList<MyElement>();
            }
            this.children.add(child);
            int index = 0;
            for (MyElement kid : this.children) {
                if (kid == child) {
                    kid.setIndex(index);
                    break;
                }
                if (!kid.type().equals(child.type())) continue;
                ++index;
            }
            child.setParent(this);
        }

        public MyElement parent() {
            return this.parent;
        }

        private void setParent(MyElement parent) {
            this.parent = parent;
        }

        public String type() {
            return this.type;
        }

        public int index() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String value() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public Properties attributes() {
            return this.attributes;
        }

        public void setAttributes(Attributes attributes) {
            int i = 0;
            while (i < attributes.getLength()) {
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                this.attributes.put(name, value);
                ++i;
            }
        }

        public List<String> comments() {
            if (this.comments == null) {
                return Collections.emptyList();
            }
            return this.comments;
        }

        public void setComments(List<String> comments) {
            this.comments = new ArrayList<String>();
            this.comments.addAll(comments);
        }
    }
}

