/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.dynamic;

import java.util.List;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.comments.CommentSets;
import org.teiid.designer.comments.Commentable;
import org.teiid.designer.vdb.manifest.ConditionElement;
import org.teiid.designer.vdb.manifest.DataRoleElement;
import org.teiid.designer.vdb.manifest.EntryElement;
import org.teiid.designer.vdb.manifest.ImportVdbElement;
import org.teiid.designer.vdb.manifest.MaskElement;
import org.teiid.designer.vdb.manifest.MetadataElement;
import org.teiid.designer.vdb.manifest.ModelElement;
import org.teiid.designer.vdb.manifest.PermissionElement;
import org.teiid.designer.vdb.manifest.ProblemElement;
import org.teiid.designer.vdb.manifest.PropertyElement;
import org.teiid.designer.vdb.manifest.SourceElement;
import org.teiid.designer.vdb.manifest.TranslatorElement;
import org.teiid.designer.vdb.manifest.VdbElement;
import org.teiid.designer.vdb.manifest.Visitor;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CommentWriter
implements Visitor,
Commentable,
StringConstants {
    private Document document;
    private Node context;

    public CommentWriter(Document document) {
        this.document = document;
        this.context = this.child(document, "vdb");
    }

    private boolean checkContext(String elementType) {
        if (this.context == null) {
            return false;
        }
        return this.context.getNodeName().equals(elementType);
    }

    private String attribute(String attrName) {
        if (this.context == null || this.context.getAttributes() == null) {
            return "";
        }
        NamedNodeMap attributes = this.context.getAttributes();
        Node item = attributes.getNamedItem(attrName);
        return item == null ? "" : item.getNodeValue();
    }

    private boolean nameAttribute(String name) {
        if (name == null) {
            return false;
        }
        return name.equals(this.attribute("name"));
    }

    private void insertComments(Node followingNode, List<String> comments) {
        if (comments == null) {
            return;
        }
        Node parent = followingNode.getParentNode();
        for (String comment : comments) {
            Comment commentNode = this.document.createComment(comment);
            parent.insertBefore(commentNode, followingNode);
        }
    }

    private Node child(Node parent, String name) {
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child instanceof Element && name.equals(child.getNodeName())) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    @Override
    public void visit(ConditionElement element) {
        if (!this.checkContext("condition")) {
            return;
        }
        CommentSets comments = element.getComments();
        this.insertComments(this.context, comments.getElementCommentSet());
    }

    @Override
    public void visit(DataRoleElement drElement) {
        if (!this.checkContext("data-role")) {
            return;
        }
        if (!this.nameAttribute(drElement.getName())) {
            return;
        }
        CommentSets commentSets = drElement.getComments();
        List<String> comments = commentSets.getElementCommentSet();
        this.insertComments(this.context, comments);
        Node drContext = this.context;
        this.context = drContext.getFirstChild();
        while (this.context != null) {
            if (this.checkContext("description")) {
                comments = commentSets.getCommentSet("description");
                this.insertComments(this.context, comments);
                this.context = this.context.getNextSibling();
                continue;
            }
            if (this.checkContext("mapped-role-name")) {
                comments = commentSets.getCommentSet("mapped-role-name-" + this.context.getTextContent());
                this.insertComments(this.context, comments);
                this.context = this.context.getNextSibling();
                continue;
            }
            if (this.checkContext("permission")) {
                for (PermissionElement pe : drElement.getPermissions()) {
                    pe.accept(this);
                }
            }
            this.context = this.context.getNextSibling();
        }
        this.context = drContext;
    }

    @Override
    public void visit(EntryElement element) {
    }

    @Override
    public void visit(ImportVdbElement element) {
        if (!this.checkContext("import-vdb")) {
            return;
        }
        if (!this.nameAttribute(element.getName())) {
            return;
        }
        CommentSets comments = element.getComments();
        this.insertComments(this.context, comments.getElementCommentSet());
    }

    @Override
    public void visit(MaskElement element) {
        if (!this.checkContext("mask")) {
            return;
        }
        CommentSets comments = element.getComments();
        this.insertComments(this.context, comments.getElementCommentSet());
    }

    @Override
    public void visit(MetadataElement element) {
        if (!this.checkContext("metadata")) {
            return;
        }
        CommentSets comments = element.getComments();
        this.insertComments(this.context, comments.getElementCommentSet());
    }

    @Override
    public void visit(ModelElement modelElement) {
        if (!this.checkContext("model")) {
            return;
        }
        if (!this.nameAttribute(modelElement.getName())) {
            return;
        }
        CommentSets commentSets = modelElement.getComments();
        List<String> comments = commentSets.getElementCommentSet();
        this.insertComments(this.context, comments);
        Node modelContext = this.context;
        this.context = modelContext.getFirstChild();
        while (this.context != null) {
            if (this.checkContext("description")) {
                comments = commentSets.getCommentSet("description");
                this.insertComments(this.context, comments);
                this.context = this.context.getNextSibling();
                continue;
            }
            if (this.checkContext("property")) {
                for (PropertyElement pe : modelElement.getProperties()) {
                    pe.accept(this);
                }
                this.context = this.context.getNextSibling();
                continue;
            }
            if (this.checkContext("source")) {
                for (SourceElement se : modelElement.getSources()) {
                    se.accept(this);
                }
                this.context = this.context.getNextSibling();
                continue;
            }
            if (this.checkContext("metadata")) {
                for (MetadataElement me : modelElement.getMetadata()) {
                    me.accept(this);
                }
            }
            this.context = this.context.getNextSibling();
        }
        this.context = modelContext;
    }

    @Override
    public void visit(PermissionElement permElement) {
        if (!this.checkContext("permission")) {
            return;
        }
        String resourceName = null;
        Node permContext = this.context;
        this.context = permContext.getFirstChild();
        while (this.context != null) {
            if (this.checkContext("resource-name")) {
                resourceName = this.context.getTextContent();
                break;
            }
            this.context = this.context.getNextSibling();
        }
        this.context = permContext;
        if (!permElement.getResourceName().equals(resourceName)) {
            return;
        }
        CommentSets commentSets = permElement.getComments();
        List<String> comments = commentSets.getElementCommentSet();
        this.insertComments(this.context, comments);
        this.context = permContext.getFirstChild();
        while (this.context != null) {
            if (this.checkContext("resource-name")) {
                comments = commentSets.getCommentSet("resource-name");
                this.insertComments(this.context, comments);
                this.context = this.context.getNextSibling();
                continue;
            }
            if (this.checkContext("mask") && permElement.getMask() != null) {
                permElement.getMask().accept(this);
                this.context = this.context.getNextSibling();
                continue;
            }
            if (this.checkContext("condition") && permElement.getCondition() != null) {
                permElement.getCondition().accept(this);
                this.context = this.context.getNextSibling();
                continue;
            }
            if (this.checkContext("allow-create") || this.checkContext("allow-read") || this.checkContext("allow-update") || this.checkContext("allow-delete") || this.checkContext("allow-execute") || this.checkContext("allow-alter") || this.checkContext("allow-language")) {
                comments = commentSets.getCommentSet(this.context.getNodeName());
                this.insertComments(this.context, comments);
            }
            this.context = this.context.getNextSibling();
        }
        this.context = permContext;
    }

    @Override
    public void visit(ProblemElement element) {
    }

    @Override
    public void visit(PropertyElement element) {
        if (!this.checkContext("property")) {
            return;
        }
        if (!this.nameAttribute(element.getName())) {
            return;
        }
        CommentSets comments = element.getComments();
        this.insertComments(this.context, comments.getElementCommentSet());
    }

    @Override
    public void visit(SourceElement element) {
        if (!this.checkContext("source")) {
            return;
        }
        if (!this.nameAttribute(element.getName())) {
            return;
        }
        CommentSets comments = element.getComments();
        this.insertComments(this.context, comments.getElementCommentSet());
    }

    @Override
    public void visit(TranslatorElement trElement) {
        if (!this.checkContext("translator")) {
            return;
        }
        if (!this.nameAttribute(trElement.getName())) {
            return;
        }
        CommentSets comments = trElement.getComments();
        this.insertComments(this.context, comments.getElementCommentSet());
        Node trContext = this.context;
        this.context = trContext.getFirstChild();
        while (this.context != null) {
            if (this.checkContext("property")) {
                for (PropertyElement pe : trElement.getProperties()) {
                    pe.accept(this);
                }
            }
            this.context = this.context.getNextSibling();
        }
        this.context = trContext;
    }

    @Override
    public void visit(VdbElement vdbElement) {
        if (!this.checkContext("vdb")) {
            return;
        }
        CommentSets commentSets = vdbElement.getComments();
        List<String> comments = commentSets.getElementCommentSet();
        this.insertComments(this.context, comments);
        Node vdbContext = this.context;
        this.context = vdbContext.getFirstChild();
        while (this.context != null) {
            if (this.checkContext("description") || this.checkContext("connection-type")) {
                comments = commentSets.getCommentSet("description");
                this.insertComments(this.context, comments);
                this.context = this.context.getNextSibling();
                continue;
            }
            if (this.checkContext("property")) {
                for (PropertyElement pe : vdbElement.getProperties()) {
                    pe.accept(this);
                }
                this.context = this.context.getNextSibling();
                continue;
            }
            if (this.checkContext("import-vdb")) {
                for (ImportVdbElement ive : vdbElement.getImportVdbEntries()) {
                    ive.accept(this);
                }
                this.context = this.context.getNextSibling();
                continue;
            }
            if (this.checkContext("model")) {
                for (ModelElement me : vdbElement.getModels()) {
                    me.accept(this);
                }
                this.context = this.context.getNextSibling();
                continue;
            }
            if (this.checkContext("translator")) {
                for (TranslatorElement te : vdbElement.getTranslators()) {
                    te.accept(this);
                }
                this.context = this.context.getNextSibling();
                continue;
            }
            if (this.checkContext("data-role")) {
                for (DataRoleElement dre : vdbElement.getDataPolicies()) {
                    dre.accept(this);
                }
            }
            this.context = this.context.getNextSibling();
        }
        this.context = vdbContext;
    }
}

