/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.file;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.vdb.VdbConstants;
import org.teiid.designer.vdb.file.IVdbFileCallback;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ValidationVersionCallback
implements IVdbFileCallback,
VdbConstants {
    private final IFile vdbFile;
    private ITeiidServerVersion version;
    private Exception exception;

    public ValidationVersionCallback(IFile vdbFile) {
        this.vdbFile = vdbFile;
    }

    @Override
    public IFile getVdb() {
        return this.vdbFile;
    }

    public ITeiidServerVersion getValidationVersion() {
        return this.version;
    }

    @Override
    public List<String> getFilesOfInterest() {
        return Collections.singletonList("META-INF/vdb.xml");
    }

    @Override
    public void processStream(String fileName, InputStream inputStream) {
        CoreArgCheck.isNotNull((Object)inputStream);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "/vdb/property[@name='validationVersion']";
            Node versionNode = (Node)xPath.compile(expression).evaluate(document, XPathConstants.NODE);
            if (versionNode == null) {
                return;
            }
            NamedNodeMap attributes = versionNode.getAttributes();
            if (attributes == null) {
                return;
            }
            Node valueAttribute = attributes.getNamedItem("value");
            if (valueAttribute == null) {
                return;
            }
            this.version = new TeiidServerVersion(valueAttribute.getNodeValue());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    @Override
    public void exceptionThrown(Exception ex) {
        this.exception = ex;
    }

    public boolean hasException() {
        return this.exception != null;
    }
}

