/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import org.fusesource.ide.foundation.core.functions.ReturnType;
import org.fusesource.ide.foundation.core.util.ReflectionHelper;
import org.fusesource.ide.foundation.core.util.Strings;

public class Objects {
    public static boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        return a != null && b != null && a.equals(b);
    }

    public static int compare(Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable) {
            Comparable comparable = (Comparable)a;
            return comparable.compareTo(b);
        }
        int answer = a.getClass().getName().compareTo(b.getClass().getName());
        if (answer == 0) {
            answer = a.hashCode() - b.hashCode();
        }
        return answer;
    }

    public static String typeName(Object value) {
        return value == null ? "null" : value.getClass().getCanonicalName();
    }

    public static Class<?> getReturnType(Object object) {
        if (object instanceof ReturnType) {
            ReturnType rt = (ReturnType)object;
            return rt.getReturnType();
        }
        return null;
    }

    public static boolean isNumberType(Class<?> aType) {
        if (aType != null && aType != Boolean.TYPE && aType != Boolean.class) {
            return aType.isPrimitive() || Number.class.isAssignableFrom(aType);
        }
        return false;
    }

    public static void setField(Object owner, String name, Object newValue, Class<?> definedIn) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ReflectionHelper.setField(owner, name, newValue, definedIn);
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static Integer parseInt(String text) {
        if (!Strings.isBlank(text)) {
            return Integer.parseInt(text);
        }
        return null;
    }

    public static String makeString(String prefix, String separator, String postfix, Object[] values) {
        StringBuilder buffer = new StringBuilder(prefix);
        boolean first = true;
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(object);
            ++n2;
        }
        buffer.append(postfix);
        return buffer.toString();
    }

    public static String makeString(String prefix, String separator, String postfix, long[] values) {
        StringBuilder buffer = new StringBuilder(prefix);
        boolean first = true;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long object = lArray[n2];
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append("" + object);
            ++n2;
        }
        buffer.append(postfix);
        return buffer.toString();
    }

    public static String makeString(String prefix, String separator, String postfix, Iterable<?> values) {
        StringBuilder buffer = new StringBuilder(prefix);
        boolean first = true;
        for (Object object : values) {
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(object);
        }
        buffer.append(postfix);
        return buffer.toString();
    }

    @Deprecated
    public static <T> T[] getArrayOf(Collection<?> coll, Class<T> aType) {
        return ReflectionHelper.getArrayOf(coll, aType);
    }

    @Deprecated
    public static <T> T getField(Object instance, String fieldName, Class<? extends Object> aClass) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        return ReflectionHelper.getField(instance, fieldName, aClass);
    }

    @Deprecated
    public static Field getFieldDescriptor(Object instance, String fieldName) throws NoSuchFieldException {
        return ReflectionHelper.getFieldDescriptor(instance, fieldName);
    }

    @Deprecated
    public static Field getFieldDescriptor(Object instance, String fieldName, Class<? extends Object> aClass) throws NoSuchFieldException {
        return ReflectionHelper.getFieldDescriptor(instance, fieldName, aClass);
    }

    @Deprecated
    public static Method getMethodDescriptor(Object instance, String methodName, Class<? extends Object> aClass, Class<?> ... parameters) throws NoSuchMethodException {
        return ReflectionHelper.getMethodDescriptor(instance, methodName, aClass, parameters);
    }

    public static <T> T getOrElse(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static <T> T notNull(T value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }
}

