/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(OidSyntaxChecker.class);

    public OidSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.38");
    }

    @Override
    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (Chars.isDigit((char)strValue.charAt(0))) {
            if (!Oid.isOid((String)strValue)) {
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        if (Chars.isAlphaASCII((String)strValue, (int)0)) {
            for (int index = 0; index < strValue.length(); ++index) {
                char c = strValue.charAt(index);
                if (Chars.isAlphaDigitMinus((char)c)) continue;
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        LOG.debug("Syntax invalid for '{}'", value);
        return false;
    }
}

