/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.util.UUID;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UuidSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(UuidSyntaxChecker.class);

    public UuidSyntaxChecker() {
        super("1.3.6.1.1.16.1");
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        if (value instanceof UUID) {
            return true;
        }
        if (!(value instanceof String)) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        return Strings.isValidUuid((String)((String)value));
    }
}

