/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.ui.runtime;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.fragment.LicenseWizardFragment;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.ui.Messages;
import org.fusesource.ide.server.karaf.ui.runtime.KarafWizardDataModel;
import org.fusesource.ide.server.karaf.ui.runtime.RTITargetFolderWizardFragment;

public abstract class AbstractKarafRuntimeComposite
extends Composite
implements Listener {
    public static final String SEPARATOR = File.separator;
    protected final Composite parent;
    protected final IWizardHandle wizardHandle;
    protected Text txtKarafDir;
    protected final KarafWizardDataModel model;
    protected boolean valid = false;
    protected IInstallableRuntime ir;
    protected Job installRuntimeJob;
    protected IJobChangeListener jobListener;
    protected Button btnBrowseButton;
    protected Button btnDownloadAndInstallButton;
    protected Label installLabel;
    protected IRuntimeWorkingCopy runtimeWC;

    public AbstractKarafRuntimeComposite(Composite parent, IWizardHandle wizardHandle, KarafWizardDataModel model) {
        super(parent, 0);
        this.parent = parent;
        this.wizardHandle = wizardHandle;
        this.model = model;
        wizardHandle.setTitle(Messages.AbstractKarafRuntimeComposite_wizard_tite);
        wizardHandle.setDescription(Messages.AbstractKarafRuntimeComposite_wizard_desc);
        wizardHandle.setImageDescriptor(ImageResource.getImageDescriptor((String)"newServerWiz"));
    }

    public void handleEvent(Event event) {
        boolean valid = false;
        if (event.type == 15) {
            this.handleFocusEvent(event);
        } else if (event.widget == this.txtKarafDir && (valid = this.validate())) {
            String installDir = this.txtKarafDir.getText();
            this.model.setKarafInstallDir(installDir);
        }
        this.wizardHandle.update();
    }

    protected void cancel() {
        if (this.installRuntimeJob != null) {
            this.installRuntimeJob.cancel();
        }
    }

    public void handleFocusEvent(Event event) {
        if (event.widget == this.txtKarafDir) {
            this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_txt_info_msg, 0);
        }
    }

    protected abstract boolean doClassPathEntiresExist(String var1);

    protected abstract String getKarafPropFileLocation(String var1);

    public boolean validate() {
        this.valid = false;
        String dirLocation = this.txtKarafDir.getText().trim();
        if (dirLocation != null && !"".equals(dirLocation)) {
            File file = new File(dirLocation);
            if (!file.exists()) {
                this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_no_dir, 3);
            } else if (!file.isDirectory()) {
                this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_not_a_dir, 3);
            } else {
                File binKaraf = new File(String.valueOf(dirLocation) + SEPARATOR + Messages.AbstractKarafRuntimeComposite_bin_karaf);
                File binKarafBat = new File(String.valueOf(dirLocation) + SEPARATOR + Messages.AbstractKarafRuntimeComposite_bin_karaf_bat);
                File confFile = new File(this.getKarafPropFileLocation(dirLocation));
                if ((binKaraf.exists() || binKarafBat.exists()) && confFile.exists() && this.doClassPathEntiresExist(dirLocation)) {
                    this.valid = true;
                    this.wizardHandle.setMessage("", 0);
                } else {
                    this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_invalid_dir, 3);
                }
            }
        } else {
            this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_wizard_help_msg, 0);
        }
        return this.valid;
    }

    void createContents() {
        this.setLayout((Layout)new GridLayout(3, false));
        Label lblKarafInstallDir = new Label((Composite)this, 0);
        lblKarafInstallDir.setText(Messages.AbstractKarafRuntimeComposite_install_dir_label);
        this.txtKarafDir = new Text((Composite)this, 2048);
        this.txtKarafDir.addListener(24, (Listener)this);
        this.txtKarafDir.setText(this.model.getKarafInstallDir());
        GridData txtKarafDirGridData = new GridData();
        txtKarafDirGridData.grabExcessHorizontalSpace = true;
        txtKarafDirGridData.horizontalAlignment = 4;
        this.txtKarafDir.setLayoutData((Object)txtKarafDirGridData);
        this.btnBrowseButton = new Button((Composite)this, 8);
        this.btnBrowseButton.setText(Messages.AbstractKarafRuntimeComposite_browse_text);
        this.btnBrowseButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                DirectoryDialog dd = new DirectoryDialog(Display.getDefault().getActiveShell(), 4096);
                dd.setFilterPath(AbstractKarafRuntimeComposite.this.txtKarafDir.getText());
                String dir = dd.open();
                if (dir != null) {
                    AbstractKarafRuntimeComposite.this.txtKarafDir.setText(dd.getFilterPath());
                }
            }
        });
        this.installLabel = new Label((Composite)this, 0);
        this.installLabel.setText(Messages.AbstractKarafRuntimeComposite_runtimeinstall_label);
        GridData installLabelGridData = new GridData();
        installLabelGridData.grabExcessHorizontalSpace = true;
        installLabelGridData.horizontalAlignment = 4;
        installLabelGridData.horizontalSpan = 2;
        this.installLabel.setLayoutData((Object)installLabelGridData);
        this.btnDownloadAndInstallButton = new Button((Composite)this, 8);
        this.btnDownloadAndInstallButton.setText(Messages.AbstractKarafRuntimeComposite_downloadAndInstall_text);
        this.btnDownloadAndInstallButton.setToolTipText(Messages.AbstractKarafRuntimeComposite_downloadAndInstall_description);
        this.btnDownloadAndInstallButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                AbstractKarafRuntimeComposite.this.ir = ServerPlugin.findInstallableRuntime((String)AbstractKarafRuntimeComposite.this.runtimeWC.getRuntimeType().getId());
                AbstractKarafRuntimeComposite.this.btnDownloadAndInstallButton.setEnabled(AbstractKarafRuntimeComposite.this.ir != null);
                if (AbstractKarafRuntimeComposite.this.ir == null) {
                    return;
                }
                String license = null;
                try {
                    license = AbstractKarafRuntimeComposite.this.ir.getLicense((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ex) {
                    Activator.getLogger().error((Throwable)ex);
                }
                TaskModel taskModel = new TaskModel();
                taskModel.putObject("license", (Object)license);
                TaskWizard wizard2 = new TaskWizard(Messages.AbstractKarafRuntimeComposite_jboss_fuse_rt_label, new WizardFragment(){

                    protected void createChildFragments(List<WizardFragment> list) {
                        list.add((WizardFragment)new LicenseWizardFragment());
                        list.add(new RTITargetFolderWizardFragment());
                    }
                }, taskModel);
                WizardDialog dialog2 = new WizardDialog(AbstractKarafRuntimeComposite.this.getShell(), (IWizard)wizard2);
                if (dialog2.open() == 1) {
                    return;
                }
                final String selectedDirectory = (String)taskModel.getObject("fuseRTLoc");
                if (selectedDirectory != null) {
                    Path installPath = new Path(selectedDirectory);
                    AbstractKarafRuntimeComposite.this.installRuntimeJob = new Job("Installing server runtime " + AbstractKarafRuntimeComposite.this.ir.getName() + "...", (IPath)installPath){
                        private final /* synthetic */ IPath val$installPath;
                        {
                            this.val$installPath = iPath;
                            super($anonymous0);
                        }

                        public boolean belongsTo(Object family) {
                            return "org.eclipse.wst.server.core".equals(family);
                        }

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((this).this).AbstractKarafRuntimeComposite.this.installLabel.setText(this.getName());
                                        ((this).this).AbstractKarafRuntimeComposite.this.btnBrowseButton.setEnabled(false);
                                        ((this).this).AbstractKarafRuntimeComposite.this.btnDownloadAndInstallButton.setEnabled(false);
                                        ((this).this).AbstractKarafRuntimeComposite.this.txtKarafDir.setEnabled(false);
                                        ((this).this).AbstractKarafRuntimeComposite.this.parent.update();
                                    }
                                });
                                (this).AbstractKarafRuntimeComposite.this.ir.install(this.val$installPath, monitor);
                            }
                            catch (CoreException ce) {
                                return ce.getStatus();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    AbstractKarafRuntimeComposite.this.jobListener = new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!AbstractKarafRuntimeComposite.this.isDisposed()) {
                                        ((this).this).AbstractKarafRuntimeComposite.this.installLabel.setText("Installation of " + ((this).this).AbstractKarafRuntimeComposite.this.ir.getName() + " completed.");
                                        ((this).this).AbstractKarafRuntimeComposite.this.btnBrowseButton.setEnabled(true);
                                        ((this).this).AbstractKarafRuntimeComposite.this.btnDownloadAndInstallButton.setEnabled(true);
                                        ((this).this).AbstractKarafRuntimeComposite.this.txtKarafDir.setEnabled(true);
                                        ((this).this).AbstractKarafRuntimeComposite.this.txtKarafDir.setText(selectedDirectory);
                                        ((this).this).AbstractKarafRuntimeComposite.this.parent.update();
                                    }
                                }
                            });
                            (this).AbstractKarafRuntimeComposite.this.installRuntimeJob.removeJobChangeListener((IJobChangeListener)this);
                            (this).AbstractKarafRuntimeComposite.this.installRuntimeJob = null;
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!AbstractKarafRuntimeComposite.this.isDisposed()) {
                                        AbstractKarafRuntimeComposite.this.validate();
                                    }
                                }
                            });
                        }
                    };
                    AbstractKarafRuntimeComposite.this.installRuntimeJob.addJobChangeListener(AbstractKarafRuntimeComposite.this.jobListener);
                    AbstractKarafRuntimeComposite.this.installRuntimeJob.schedule();
                }
            }
        });
        this.wizardHandle.update();
    }

    protected void setRuntime(IRuntimeWorkingCopy newRuntime) {
        this.runtimeWC = newRuntime == null ? null : newRuntime;
        if (this.runtimeWC == null) {
            this.ir = null;
            this.btnDownloadAndInstallButton.setEnabled(false);
            this.installLabel.setText("");
        } else {
            this.ir = ServerPlugin.findInstallableRuntime((String)this.runtimeWC.getRuntimeType().getId());
            if (this.ir != null) {
                this.btnDownloadAndInstallButton.setEnabled(true);
            }
        }
        this.init();
        this.validate();
    }

    protected void init() {
        if (this.runtimeWC.getLocation() != null) {
            this.txtKarafDir.setText(this.runtimeWC.getLocation().toOSString());
        } else {
            this.txtKarafDir.setText("");
        }
    }

    void performFinish() {
    }

    protected boolean isValid() {
        return this.valid;
    }
}

