/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.aspects.sql;

import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.xml.XmlAttribute;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.xml.PluginConstants;
import org.teiid.designer.xml.aspects.sql.AbstractXmlDocumentEntitySqlAspect;
import org.teiid.designer.xml.aspects.sql.XmlElementSqlAspect;

public class XmlAttributeSqlAspect
extends AbstractXmlDocumentEntitySqlAspect
implements SqlColumnAspect {
    private static char NAME_PREFIX = (char)64;

    public XmlAttributeSqlAspect(MetamodelEntity entity) {
        super(entity);
    }

    public boolean isRecordType(char recordType) {
        return recordType == 'G';
    }

    public String getName(EObject eObject) {
        CoreArgCheck.isInstanceOf(XmlAttribute.class, (Object)eObject);
        Path path = new Path(this.getShortName(eObject));
        EObject parent = eObject.eContainer();
        SqlAspect parentAspect = AspectManager.getSqlAspect((EObject)parent);
        while (parentAspect != null) {
            if (parentAspect instanceof SqlColumnAspect) {
                String name = null;
                name = parentAspect instanceof AbstractXmlDocumentEntitySqlAspect ? ((AbstractXmlDocumentEntitySqlAspect)parentAspect).getShortName(parent) : parentAspect.getName(parent);
                path = new Path("").append(name).append((IPath)path);
            } else if (parentAspect instanceof SqlTableAspect) break;
            parent = parent.eContainer();
            parentAspect = AspectManager.getSqlAspect((EObject)parent);
        }
        return path.toString().replace('/', '.');
    }

    @Override
    protected String getShortName(EObject eObject) {
        CoreArgCheck.isInstanceOf(XmlAttribute.class, (Object)eObject);
        XmlAttribute xmlAttribute = (XmlAttribute)eObject;
        String name = String.valueOf(NAME_PREFIX) + xmlAttribute.getName();
        return name;
    }

    @Override
    protected String getParentFullName(EObject eObject) {
        EObject parent = eObject.eContainer();
        if (parent != null) {
            SqlAspect parentAspect = AspectManager.getSqlAspect((EObject)parent);
            while (parentAspect != null) {
                if (parentAspect instanceof SqlTableAspect) {
                    return parentAspect.getFullName(parent);
                }
                if ((parent = parent.eContainer()) != null) {
                    parentAspect = AspectManager.getSqlAspect((EObject)parent);
                    continue;
                }
                return null;
            }
        }
        return null;
    }

    public int getCharOctetLength(EObject eObject) {
        return 0;
    }

    public String getNativeType(EObject eObject) {
        return null;
    }

    public EObject getDatatype(EObject eObject) {
        CoreArgCheck.isInstanceOf(XmlAttribute.class, (Object)eObject);
        XmlAttribute xmlAttribute = (XmlAttribute)eObject;
        XmlElement xmlElement = xmlAttribute.getElement();
        if (xmlElement != null) {
            XmlElementSqlAspect elementAspect = this.getXmlElementAspect((EObject)xmlElement);
            Map elementMap = elementAspect.getMappingInfo((EObject)xmlAttribute);
            Object lookupObj = elementMap.get(xmlAttribute);
            if (lookupObj != null) {
                CoreArgCheck.isInstanceOf(MappingClassColumn.class, lookupObj, null);
                MappingClassColumn mapingColumn = (MappingClassColumn)lookupObj;
                return mapingColumn.getType();
            }
            try {
                return ModelerCore.getDatatypeManager((EObject)eObject).getBuiltInDatatype("string");
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public String getDatatypeName(EObject eObject) {
        EObject datatype = this.getDatatype(eObject);
        DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true);
        String dtName = dtMgr.getName(datatype);
        return dtName == null ? "string" : dtName;
    }

    public String getDatatypeObjectID(EObject eObject) {
        DatatypeManager dtMgr;
        EObject datatype = this.getDatatype(eObject);
        try {
            if (datatype == null) {
                datatype = ModelerCore.getWorkspaceDatatypeManager().getBuiltInDatatype("string");
            }
        }
        catch (Throwable throwable) {}
        return (dtMgr = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true)).getUuidString(datatype) == null ? "" : dtMgr.getUuidString(datatype);
    }

    public String getDefaultValue(EObject eObject) {
        return XmlElementSqlAspect.DEFAULT_VALUE;
    }

    public String getFormat(EObject eObject) {
        return XmlElementSqlAspect.FORMAT;
    }

    public int getLength(EObject eObject) {
        return 0;
    }

    public Object getMaxValue(EObject eObject) {
        return XmlElementSqlAspect.MIN_VALUE;
    }

    public Object getMinValue(EObject eObject) {
        return XmlElementSqlAspect.MAX_VALUE;
    }

    public int getDistinctValues(EObject eObject) {
        return 0;
    }

    public int getNullValues(EObject eObject) {
        return 0;
    }

    public int getNullType(EObject eObject) {
        return 1;
    }

    public int getPosition(EObject eObject) {
        return 0;
    }

    public int getPrecision(EObject eObject) {
        return 0;
    }

    public int getRadix(EObject eObject) {
        return 0;
    }

    public String getRuntimeType(EObject eObject) {
        EObject datatype = this.getDatatype(eObject);
        DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true);
        String rtt = dtMgr.getRuntimeTypeName(datatype);
        return rtt == null ? "string" : rtt;
    }

    public int getScale(EObject eObject) {
        return 0;
    }

    public int getSearchType(EObject eObject) {
        return 0;
    }

    public boolean isAutoIncrementable(EObject eObject) {
        return false;
    }

    public boolean isCaseSensitive(EObject eObject) {
        return false;
    }

    public boolean isCurrency(EObject eObject) {
        return false;
    }

    public boolean isFixedLength(EObject eObject) {
        return false;
    }

    public boolean isSelectable(EObject eObject) {
        return true;
    }

    public boolean isSigned(EObject eObject) {
        return false;
    }

    public boolean isTranformationInputParameter(EObject eObject) {
        return false;
    }

    public boolean isUpdatable(EObject eObject) {
        return false;
    }

    public boolean canSetDatatype() {
        return false;
    }

    public void setDatatype(EObject eObject, EObject datatype) {
        throw new UnsupportedOperationException(PluginConstants.Util.getString("XmlAttributeSqlAspect.Datatype_cannot_be_set_on_an_XMLAttribute_1", new Object[0]));
    }

    public boolean canSetLength() {
        return false;
    }

    public void setLength(EObject eObject, int length) {
        throw new UnsupportedOperationException(PluginConstants.Util.getString("XmlAttributeSqlAspect.Length_cannot_be_set_on_an_XMLAttribute_2", new Object[0]));
    }

    public boolean canSetNullType() {
        return false;
    }

    public void setNullType(EObject eObject, int nullType) {
        throw new UnsupportedOperationException(PluginConstants.Util.getString("XmlAttributeSqlAspect.NullType_cannot_be_set_on_an_XMLAttribute_3", new Object[0]));
    }

    private XmlElementSqlAspect getXmlElementAspect(EObject eObject) {
        CoreArgCheck.isInstanceOf(XmlElement.class, (Object)eObject);
        XmlElement element = (XmlElement)eObject;
        return (XmlElementSqlAspect)AspectManager.getSqlAspect((EObject)element);
    }

    public void updateObject(EObject targetObject, EObject sourceObject) {
    }

    public boolean isDatatypeFeature(EObject eObject, EStructuralFeature eFeature) {
        return false;
    }
}

