/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.factory.DefaultMappableTree;
import org.teiid.designer.mapping.factory.FragmentMappingAdapter;
import org.teiid.designer.metamodels.xml.ProcessingInstruction;
import org.teiid.designer.metamodels.xml.XmlAttribute;
import org.teiid.designer.metamodels.xml.XmlComment;
import org.teiid.designer.metamodels.xml.XmlContainerNode;
import org.teiid.designer.metamodels.xml.XmlDocumentNode;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.metamodels.xml.XmlFragment;
import org.teiid.designer.metamodels.xml.XmlFragmentUse;
import org.teiid.designer.metamodels.xml.XmlNamespace;
import org.teiid.designer.metamodels.xml.XmlRoot;
import org.teiid.designer.metamodels.xsd.XsdUtil;
import org.teiid.designer.xml.PluginConstants;

public class XmlMappableTree
extends DefaultMappableTree
implements PluginConstants.PreferenceKeys {
    private static EObject stringDatatype;
    private FragmentMappingAdapter fragmentAdapter;

    public XmlMappableTree(EObject treeRoot) {
        super(treeRoot);
        this.fragmentAdapter = new FragmentMappingAdapter(treeRoot);
    }

    public Collection getChildren(EObject node) {
        Collection children = super.getChildren(node);
        ArrayList result = new ArrayList(children.size());
        int attributeIndex = 0;
        for (Object child : children) {
            if (child instanceof XmlFragmentUse) {
                XmlRoot root;
                EObject childToAdd = (EObject)child;
                XmlFragment fragment = (XmlFragment)this.fragmentAdapter.getFragment(childToAdd);
                if (fragment != null && (root = fragment.getRoot()) != null) {
                    childToAdd = root;
                }
                result.add(child);
                continue;
            }
            if (child instanceof XmlNamespace || child instanceof XmlComment || child instanceof ProcessingInstruction) continue;
            if (child instanceof XmlAttribute) {
                result.add(attributeIndex++, child);
                continue;
            }
            result.add(child);
        }
        return result;
    }

    public List getExternalRoots(boolean recurseFragments) {
        return super.getExternalRoots(recurseFragments);
    }

    public EObject getParent(EObject node) {
        return super.getParent(node);
    }

    public boolean isExternal(EObject node) {
        return !this.getTreeRoot().equals(this.getFragmentRoot(node));
    }

    public EObject getFragmentRoot(EObject node) {
        XmlFragment result = null;
        while (node != null) {
            if (node instanceof XmlFragment) {
                result = (XmlFragment)node;
                break;
            }
            node = node.eContainer();
        }
        return result;
    }

    public EObject getDatatype(EObject node) {
        boolean useXsdType = true;
        IEclipsePreferences prefs = new InstanceScope().getNode("org.teiid.designer.xml");
        if (prefs.get("mappingTypeFromXsd", null) == null) {
            IEclipsePreferences defaultPrefs = new DefaultScope().getNode("org.teiid.designer.xml");
            useXsdType = defaultPrefs.getBoolean("mappingTypeFromXsd", useXsdType);
        } else {
            useXsdType = prefs.getBoolean("mappingTypeFromXsd", useXsdType);
        }
        if (!useXsdType) {
            return XmlMappableTree.getStringDatatype();
        }
        XSDSimpleTypeDefinition result = null;
        XSDComponent schemaNode = null;
        if (node instanceof XmlElement) {
            schemaNode = ((XmlElement)node).getXsdComponent();
        } else if (node instanceof XmlAttribute) {
            schemaNode = ((XmlAttribute)node).getXsdComponent();
        }
        if (schemaNode != null) {
            result = XsdUtil.getSimpleType((XSDComponent)schemaNode);
        }
        if (result == null) {
            result = XmlMappableTree.getStringDatatype();
        }
        return result;
    }

    private static EObject getStringDatatype() {
        if (stringDatatype == null) {
            try {
                stringDatatype = ModelerCore.getWorkspaceDatatypeManager().getBuiltInDatatype("string");
            }
            catch (ModelerCoreException e) {
                PluginConstants.Util.log((Throwable)e);
            }
        }
        return stringDatatype;
    }

    public boolean areEquivalent(EObject objA, EObject objB) {
        return false;
    }

    public String getUniqueName(EObject node) {
        if (node instanceof XmlDocumentNode) {
            String name = ((XmlDocumentNode)node).getName();
            EObject parent = node.eContainer();
            while (parent != null && parent instanceof XmlContainerNode) {
                parent = parent.eContainer();
            }
            if (parent != null && parent instanceof XmlDocumentNode) {
                return String.valueOf(name) + '_' + ((XmlDocumentNode)parent).getName();
            }
        }
        return super.getUniqueName(node);
    }

    public boolean isVisibleNode(EObject node) {
        return !(node instanceof XmlNamespace);
    }
}

