/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xml.aspects.uml;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AbstractMetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.uml.UmlPackage;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.XmlDocumentPlugin;

public class XmlDocumentAspect
extends AbstractMetamodelAspect
implements UmlPackage {
    public static final String ASPECT_ID = "umlDiagramAspect";

    public XmlDocumentAspect(MetamodelEntity entity) {
        super.setMetamodelEntity(entity);
        super.setID(ASPECT_ID);
    }

    public String getStereotype(Object eObject) {
        EmfResource emfResource;
        String theStereoType = null;
        theStereoType = XmlDocumentPlugin.Util.getString("_UI_XmlDocument_type", new Object[0]);
        if (theStereoType == null) {
            theStereoType = "XML Document";
        }
        if ((emfResource = (EmfResource)((EObject)eObject).eResource()).getModelAnnotation() != null) {
            ModelType type = emfResource.getModelAnnotation().getModelType();
            if (type.equals(ModelType.VIRTUAL_LITERAL)) {
                theStereoType = XmlDocumentPlugin.Util.getString("_UI_XmlDocument_type", new Object[0]);
            } else if (type.equals(ModelType.LOGICAL_LITERAL)) {
                theStereoType = XmlDocumentPlugin.Util.getString("_UI_XmlMessageStructure_type", new Object[0]);
            }
        }
        return theStereoType;
    }

    public IStatus setSignature(Object eObject, String newSignature) {
        try {
            XmlDocument xmlDoc = this.assertXmlDocument(eObject);
            xmlDoc.setName(newSignature);
        }
        catch (Throwable e) {
            return new Status(4, "org.teiid.designer.metamodels.xml", 0, e.getMessage(), e);
        }
        return new Status(0, "org.teiid.designer.metamodels.xml", 0, XmlDocumentPlugin.Util.getString("XmlDocumentAspect.Aspect.OK_1", new Object[0]), null);
    }

    public String getSignature(Object eObject, int showMask) {
        XmlDocument xmlDoc = this.assertXmlDocument(eObject);
        StringBuffer result = new StringBuffer();
        switch (showMask) {
            case 1: {
                result.append(xmlDoc.getName());
                break;
            }
            case 2: {
                result.append("<<");
                result.append(this.getStereotype(xmlDoc));
                result.append(">>");
                break;
            }
            case 3: {
                result.append("<<");
                result.append(this.getStereotype(xmlDoc));
                result.append(">> ");
                result.append(xmlDoc.getName());
                break;
            }
            default: {
                throw new TeiidDesignerRuntimeException(XmlDocumentPlugin.Util.getString("XmlDocumentAspect.Invalid_showMask_for_getSignature__2", (Object)showMask));
            }
        }
        return result.toString();
    }

    public String getEditableSignature(Object eObject) {
        return this.getSignature(eObject, 1);
    }

    public Object getImage(Object eObject) {
        this.assertXmlDocument(eObject);
        AdapterFactory adapterFactory = ModelerCore.getMetamodelRegistry().getAdapterFactory();
        IItemLabelProvider provider = (IItemLabelProvider)adapterFactory.adapt(eObject, IItemLabelProvider.class);
        return provider.getImage(eObject);
    }

    public int getVisibility(Object eObject) {
        return 100;
    }

    protected XmlDocument assertXmlDocument(Object eObject) {
        CoreArgCheck.isInstanceOf(XmlDocument.class, (Object)eObject);
        return (XmlDocument)eObject;
    }
}

