/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xml.aspects.validation;

import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.metamodels.xml.XmlContainerNode;
import org.teiid.designer.metamodels.xml.XmlDocumentNode;
import org.teiid.designer.metamodels.xml.aspects.validation.AbstractXmlAspect;

public abstract class AbstractXmlNodeAspect
extends AbstractXmlAspect {
    public AbstractXmlNodeAspect(MetamodelEntity entity) {
        super(entity);
    }

    public boolean shouldValidate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isNotNull((Object)eObject);
        String validationPref = context.getPreferenceValue("xmlPreferences.validateExcludedElements");
        if (CoreStringUtil.isEmpty((String)validationPref) || validationPref.equals("false")) {
            if (!context.shouldIgnore((Object)eObject)) {
                if (this.isExcluded(eObject, context)) {
                    return false;
                }
                EObject container = eObject.eContainer();
                while (container != null) {
                    if (this.isExcluded(container, context)) {
                        return false;
                    }
                    container = container.eContainer();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isExcluded(EObject eObject, ValidationContext context) {
        if (eObject != null) {
            boolean excluded = false;
            if (eObject instanceof XmlDocumentNode) {
                excluded = ((XmlDocumentNode)eObject).isExcludeFromDocument();
            } else if (eObject instanceof XmlContainerNode) {
                excluded = ((XmlContainerNode)eObject).isExcludeFromDocument();
            }
            if (excluded) {
                context.addObjectToIgnore(eObject, true);
                return true;
            }
        }
        return false;
    }
}

