/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleFinal;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.TransactionRunnable;
import org.teiid.designer.core.search.MetadataSearch;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.xsd.XsdUtil;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.forms.ComponentCategory;
import org.teiid.designer.ui.forms.ComponentSetEvent;
import org.teiid.designer.ui.forms.ComponentSetMonitor;
import org.teiid.designer.ui.forms.LinkedComponentSet;
import org.teiid.designer.ui.views.DatatypeHierarchyView;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;
import org.teiid.designer.xsd.ui.editor.AbstractFacetSet;
import org.teiid.designer.xsd.ui.editor.FacetHelper;
import org.teiid.designer.xsd.ui.editor.FacetValue;
import org.teiid.designer.xsd.ui.editor.GUIFacetHelper;
import org.teiid.designer.xsd.ui.editor.MultiFacetSet;

public class FacetModel
implements ComponentSetMonitor {
    static final String TITLE_BASE_NOT_ALLOWED = GUIFacetHelper.getString("FacetModel.title_BaseNotAllowed");
    static final String DESC_BASE_NOT_ALLOWED_SAME = GUIFacetHelper.getString("FacetModel.desc_BaseNotAllowedSame");
    static final String DESC_BASE_NOT_ALLOWED_CHILD = GUIFacetHelper.getString("FacetModel.desc_BaseNotAllowedChild");
    private ComponentCategory[] ccats = GUIFacetHelper.getCategories(this);
    XSDSimpleTypeDefinition simpleType;
    boolean isReadOnly;
    boolean editorIsReadOnly;
    boolean ignoreEvents;
    private Map idToFacet = new HashMap();
    private Map idToCategory = new HashMap();
    XSDSchema schema;

    public FacetModel() {
        int i = 0;
        while (i < this.ccats.length) {
            ComponentCategory cat = this.ccats[i];
            cat.setMonitor((ComponentSetMonitor)this);
            this.idToCategory.put(cat.getID(), cat);
            for (LinkedComponentSet set : cat.getComponentSets()) {
                this.idToFacet.put(set.getID(), set);
            }
            ++i;
        }
    }

    public ComponentCategory[] getCategories() {
        return this.ccats;
    }

    public XSDSimpleTypeDefinition getSimpleType() {
        return this.simpleType;
    }

    public void setSchema(XSDSchema schema) {
        this.schema = schema;
        LinkedComponentSet lcs = this.getComponentSet("namespace");
        lcs.setValue((Object)schema.getTargetNamespace());
        ModelResource mRes = ModelUtilities.getModelResourceForModelObject((EObject)schema);
        boolean readOnly = mRes != null ? mRes.isReadOnly() : true;
        lcs.setEditible(readOnly);
    }

    public void setSimpleType(XSDSimpleTypeDefinition simpleType) {
        this.simpleType = null;
        this.ignoreEvents = true;
        this.determineReadOnly(simpleType);
        if (simpleType != null) {
            this.clear();
            this.setFields(simpleType);
            this.resetDisplayedCategories(simpleType);
        } else {
            this.getCategory("id").setVisible(false);
            this.getCategory("inheritance").setVisible(false);
            this.getCategory("enterprise").setVisible(false);
            this.getCategory("bounds").setVisible(false);
            this.getCategory("numeric").setVisible(false);
            this.getCategory("format").setVisible(false);
            this.getCategory("length").setVisible(false);
        }
        this.ignoreEvents = false;
        this.simpleType = simpleType;
        this.setGUIReadOnly(this.isReadOnly);
    }

    void resetDisplayedCategories(XSDSimpleTypeDefinition simpleType) {
        boolean needsNumeric = FacetHelper.needsNumeric(simpleType);
        boolean needsBounds = FacetHelper.needsBounds(simpleType);
        this.getCategory("id").setVisible(true);
        this.getCategory("inheritance").setVisible(true);
        this.getCategory("enterprise").setVisible(true);
        this.getCategory("bounds").setVisible(needsBounds);
        this.getCategory("numeric").setVisible(needsNumeric);
        this.getCategory("format").setVisible(!needsBounds);
        this.getCategory("length").setVisible(!needsBounds);
    }

    private void determineReadOnly(XSDSimpleTypeDefinition simpleType) {
        ModelResource mRes = ModelUtilities.getModelResourceForModelObject((EObject)simpleType);
        this.isReadOnly = mRes != null ? mRes.isReadOnly() : true;
        ModelResource schemaModelResource = ModelUtilities.getModelResourceForModelObject((EObject)this.schema);
        if (schemaModelResource != null) {
            this.setEditorReadOnly(schemaModelResource.isReadOnly());
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setGUIReadOnly(boolean ro) {
        this.determineReadOnly(this.simpleType);
        if (ro || !this.isReadOnly) {
            int i = 0;
            while (i < this.ccats.length) {
                ComponentCategory cat = this.ccats[i];
                cat.setEnabled(!ro);
                ++i;
            }
        }
    }

    void setEditorReadOnly(boolean editorIsReadOnly) {
        this.editorIsReadOnly = editorIsReadOnly;
    }

    boolean isEditorReadOnly() {
        return this.editorIsReadOnly;
    }

    void setFields(XSDSimpleTypeDefinition simpleType) {
        boolean prevIgnore = this.ignoreEvents;
        this.ignoreEvents = true;
        this.getComponentSet("name").setValue((Object)simpleType.getName());
        this.getComponentSet("namespace").setValue((Object)simpleType.getTargetNamespace());
        this.getComponentSet("description").setValue((Object)CoreStringUtil.collapseWhitespace((String)ModelObjectUtilities.getDescription((EObject)simpleType)));
        this.getComponentSet("basetype").setValue((Object)simpleType.getBaseTypeDefinition());
        this.getComponentSet("links-and-prevent").setValue((Object)new Object[]{simpleType, FacetModel.getStringFinals((Collection)simpleType.getLexicalFinal())});
        FacetValue entFV = FacetHelper.getEnterpriseFacetValue(simpleType);
        final boolean isEnterprise = ModelerCore.getWorkspaceDatatypeManager().isEnterpriseDatatype((EObject)simpleType);
        this.getComponentSet("enterprise").setValue((Object)new Boolean(isEnterprise));
        final LinkedComponentSet entcs = this.getComponentSet("runtime");
        entcs.setValue((Object)entFV);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                entcs.setEditible(isEnterprise && !FacetModel.this.isReadOnly);
            }
        });
        Set setFacets = FacetHelper.getUsefulFacets(simpleType);
        HashSet<MultiFacetSet> multisToRefresh = new HashSet<MultiFacetSet>();
        for (EObject eobj : setFacets) {
            XSDConstrainingFacet facet;
            String facetID;
            LinkedComponentSet lcs;
            if (!(eobj instanceof XSDConstrainingFacet) || (lcs = this.getComponentSet(facetID = FacetHelper.getFacetName(facet = (XSDConstrainingFacet)eobj))) == null) continue;
            FacetValue fv = FacetHelper.getFacetValue(simpleType, facet);
            if (lcs instanceof MultiFacetSet) {
                MultiFacetSet mfs = (MultiFacetSet)lcs;
                mfs.addValue(fv, false);
                multisToRefresh.add(mfs);
                continue;
            }
            lcs.setValue((Object)fv);
        }
        for (MultiFacetSet mfs : multisToRefresh) {
            mfs.reflow();
        }
        this.ignoreEvents = prevIgnore;
    }

    void clear() {
        for (LinkedComponentSet lcs : this.idToFacet.values()) {
            if (lcs.getID() == "namespace") continue;
            lcs.setValue(null);
        }
    }

    LinkedComponentSet getComponentSet(String facetID) {
        if (facetID == "maxExclusive" || facetID == "maxInclusive") {
            facetID = "maximum";
        } else if (facetID == "minExclusive" || facetID == "minInclusive") {
            facetID = "minimum";
        }
        return (LinkedComponentSet)this.idToFacet.get(facetID);
    }

    private ComponentCategory getCategory(String catID) {
        return (ComponentCategory)this.idToCategory.get(catID);
    }

    private static Collection getStringFinals(Collection simpleFinals) {
        ArrayList<String> rv = new ArrayList<String>(simpleFinals.size());
        for (XSDSimpleFinal fin : simpleFinals) {
            rv.add(fin.getName());
        }
        return rv;
    }

    public void update(final ComponentSetEvent event) {
        if (!this.ignoreEvents && this.simpleType != null) {
            TransactionRunnable runnable = new TransactionRunnable(){

                public Object run(UnitOfWork uow) {
                    String id = event.componentSet.getID();
                    if (event.value instanceof FacetValue && !"runtime".equals(id)) {
                        FacetValue fv = (FacetValue)event.value;
                        if (fv.value instanceof FacetValue) {
                            fv = (FacetValue)fv.value;
                        }
                        if (event.isDelete) {
                            if (fv.facet != null) {
                                FacetHelper.removeFacet(FacetModel.this.simpleType, fv.facet);
                                fv.clear();
                            }
                        } else {
                            fv.facet = FacetHelper.addOrSetFacetValue(FacetModel.this.simpleType, id, fv);
                        }
                    } else if ("name" == id) {
                        ModelObjectUtilities.rename((EObject)FacetModel.this.simpleType, (String)((String)event.value), (Object)this);
                    } else if ("namespace" == id) {
                        XsdUtil.setTargetNamespace((XSDSchema)((XSDSchema)ModelObjectUtilities.getRealEObject((EObject)FacetModel.this.simpleType.getSchema())), (String)((String)event.value));
                        LinkedComponentSet baseType = FacetModel.this.getComponentSet("basetype");
                        baseType.setValue(null);
                        baseType.setValue((Object)FacetModel.this.simpleType.getBaseTypeDefinition());
                    } else if ("preventrestrictions" == id) {
                        EList current = FacetModel.this.simpleType.getLexicalFinal();
                        current.clear();
                        Set newVals = (Set)event.value;
                        for (String element : newVals) {
                            current.add(XSDSimpleFinal.get((String)element));
                        }
                    } else if ("runtime" == id) {
                        FacetValue fv = (FacetValue)event.value;
                        FacetHelper.setEnterpriseFacetValue(FacetModel.this.simpleType, fv);
                    } else if ("enterprise" == id) {
                        boolean isEnterprise = (Boolean)event.value;
                        LinkedComponentSet rtlcs = FacetModel.this.getComponentSet("runtime");
                        rtlcs.setEditible(isEnterprise);
                        if (isEnterprise) {
                            FacetHelper.setEnterpriseFacetValue(FacetModel.this.simpleType, ((AbstractFacetSet)rtlcs).getFacetValue());
                        } else {
                            ModelerCore.getModelEditor().unsetEnterpriseDatatypePropertyValue((EObject)FacetModel.this.simpleType);
                        }
                    } else if ("basetype" == id) {
                        XSDSimpleTypeDefinition newBaseType = (XSDSimpleTypeDefinition)event.value;
                        if (newBaseType == FacetModel.this.simpleType) {
                            event.doit = false;
                            MessageDialog.openError(null, (String)TITLE_BASE_NOT_ALLOWED, (String)DESC_BASE_NOT_ALLOWED_SAME);
                        } else if (FacetHelper.isSubtypeOf(newBaseType, FacetModel.this.simpleType)) {
                            event.doit = false;
                            MessageDialog.openError(null, (String)TITLE_BASE_NOT_ALLOWED, (String)DESC_BASE_NOT_ALLOWED_CHILD);
                        } else {
                            ModelerCore.getDatatypeManager((EObject)FacetModel.this.simpleType).setBasetypeDefinition(FacetModel.this.simpleType, newBaseType);
                            FacetModel.this.ignoreEvents = true;
                            FacetModel.this.clear();
                            FacetModel.this.resetDisplayedCategories(FacetModel.this.simpleType);
                            FacetModel.this.setFields(FacetModel.this.simpleType);
                            FacetModel.this.ignoreEvents = false;
                        }
                    } else if ("description" == id) {
                        ModelObjectUtilities.setDescription((EObject)FacetModel.this.simpleType, (String)((String)event.value), (Object)this);
                    } else if ("createsubtype" == id) {
                        if (FacetModel.this.isEditorReadOnly()) {
                            MessageDialog.openConfirm(null, (String)ModelerXsdUiConstants.Util.getString("FacetModel.read_only.title", new Object[0]), (String)ModelerXsdUiConstants.Util.getString("FacetModel.read_only.cannotCreateSubtypeMessage", new Object[0]));
                            return null;
                        }
                        final XSDSimpleTypeDefinition newType = GUIFacetHelper.createType(FacetModel.this.schema, FacetModel.this.simpleType);
                        if (newType != null) {
                            uow.setDescription(ModelerXsdUiConstants.Util.getString("FacetModel.transaction_create", (Object)newType.getName()));
                            uow.setSource((Object)FacetModel.this.schema);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    GUIFacetHelper.showObject((EObject)newType);
                                }
                            });
                        }
                    } else if ("findsubtypes" == id) {
                        MessageDialog.openInformation(null, (String)"Find subtypes", (String)("find subtypes not implemented; specified was: " + event.value));
                    } else if ("openhierarchy" == id) {
                        try {
                            DatatypeHierarchyView datatypes = (DatatypeHierarchyView)UiUtil.getWorkbenchPage().showView("views.datatypeHierarchyView");
                            datatypes.revealType((XSDTypeDefinition)FacetModel.this.simpleType);
                        }
                        catch (PartInitException ex) {
                            ModelerXsdUiConstants.Util.log((Throwable)ex);
                        }
                    } else if ("finduses" == id) {
                        MetadataSearch search = ModelerCore.createMetadataSearch();
                        search.setDatatype((EObject)FacetModel.this.simpleType, false);
                        search.execute((IProgressMonitor)new NullProgressMonitor());
                        List resultsl = search.getResults();
                        ListDialog ld = new ListDialog(null){

                            protected int getTableStyle() {
                                return 2818;
                            }
                        };
                        ld.setInput((Object)resultsl);
                        ld.setAddCancelButton(true);
                        ld.setBlockOnOpen(true);
                        ld.setContentProvider((IStructuredContentProvider)new ListSCP());
                        ld.setLabelProvider(ModelUtilities.getEMFLabelProvider());
                        ld.setMessage("Pat's zany message");
                        ld.setTitle("Pat's zany title");
                        ld.setInitialElementSelections(resultsl);
                        ld.open();
                        MessageDialog.openInformation(null, (String)"Find uses", (String)("find uses not implemented; specified was: " + event.value));
                    }
                    return null;
                }
            };
            try {
                ModelerCore.getModelEditor().executeAsTransaction(runnable, ModelerXsdUiConstants.Util.getString("FacetModel.Set_on_simple_data_type_properties", new Object[0]), true, true, (Object)this);
            }
            catch (ModelerCoreException mce) {
                ModelerXsdUiConstants.Util.log((Throwable)mce);
            }
        }
    }

    public class ListSCP
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement != null) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

