/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.designer.ui.forms.FormUtil;
import org.teiid.designer.xsd.ui.editor.FacetHelper;

public class FacetValue
implements Cloneable {
    public boolean isFixedLocal;
    public Object value;
    public Object defaultValue;
    public String description;
    public XSDSimpleTypeDefinition type;
    public XSDConstrainingFacet facet;

    public FacetValue() {
    }

    public FacetValue(FacetValue fv) {
        this.copyValuesOf(fv);
    }

    public void copyValuesOf(FacetValue fv) {
        if (fv != null) {
            this.isFixedLocal = fv.isFixedLocal;
            this.type = fv.type;
            this.value = fv.value;
            this.defaultValue = fv.defaultValue;
            this.description = fv.description;
            this.facet = fv.facet;
        } else {
            this.clear();
        }
    }

    public void clear() {
        this.isFixedLocal = false;
        this.type = null;
        this.value = null;
        this.defaultValue = null;
        this.description = null;
        this.facet = null;
    }

    public FacetValue cloneValue() {
        try {
            return (FacetValue)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return new FacetValue(this);
        }
    }

    public boolean isDefault() {
        return FormUtil.safeEquals((String)this.description, null, (boolean)true) && (this.facet == null || this.isFixedByParent() || FormUtil.safeEquals((Object)this.value, (Object)this.defaultValue));
    }

    public void resetToDefault() {
        this.value = this.defaultValue;
        this.description = null;
    }

    public boolean isInherited() {
        return this.facet != null && this.facet.getContainer() != this.type;
    }

    public boolean isFixedByParent() {
        return FacetHelper.isFixed(this.facet) && this.isInherited();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof FacetValue) {
            FacetValue fv = (FacetValue)obj;
            return this.isFixedLocal == fv.isFixedLocal && this.isInherited() == fv.isInherited() && FormUtil.safeEquals((Object)this.value, (Object)fv.value) && FormUtil.safeEquals((Object)this.description, (Object)fv.description);
        }
        return false;
    }

    public String toString() {
        return "FacetValue: isDefault=" + this.isDefault() + "; isFixedLocal=" + this.isFixedLocal + "; isInherited=" + this.isInherited() + "; value=" + this.value + "; desc=" + this.description;
    }
}

