/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.ui.forms.DialogProvider;
import org.teiid.designer.xsd.ui.editor.FacetValue;
import org.teiid.designer.xsd.ui.editor.GUIFacetHelper;

public class FacetValueEditorDialog
implements DialogProvider {
    private static final String EMPTY_STRING = "";
    private FacetValueDialog dlg;
    private boolean wasCancelled;

    public void showDialog(Shell shell, Object initialValue) {
        FacetValue fv;
        if (initialValue instanceof FacetValue) {
            fv = (FacetValue)initialValue;
        } else {
            fv = new FacetValue();
            fv.value = initialValue;
        }
        if (fv.value == null) {
            fv.value = EMPTY_STRING;
        }
        if (fv.description == null) {
            fv.description = EMPTY_STRING;
        }
        this.dlg = new FacetValueDialog(shell, GUIFacetHelper.getString("FacetValueEditor.title"), fv);
        this.dlg.setBlockOnOpen(true);
        this.wasCancelled = this.dlg.open() == 1;
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public Object getValue() {
        if (this.wasCancelled || this.dlg == null) {
            return null;
        }
        return this.dlg.getValue();
    }

    public String getLaunchButtonText() {
        return GUIFacetHelper.getString("FacetValueEditor.launch");
    }

    public static class FacetValueDialog
    extends Dialog {
        final FacetValue fv;
        private final String title;

        protected FacetValueDialog(Shell shell, String title, FacetValue value) {
            super(shell);
            this.title = title;
            this.fv = value;
            this.setShellStyle(0x10870 | FacetValueDialog.getDefaultOrientation());
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            if (this.title != null) {
                shell.setText(this.title);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout gl = (GridLayout)composite.getLayout();
            gl.numColumns = 2;
            Label l = new Label(composite, 0);
            l.setText(GUIFacetHelper.getString("FacetValueEditor.value"));
            l.setLayoutData((Object)new GridData(3, 1, false, false));
            final Text value = new Text(composite, 2048);
            value.setText((String)this.fv.value);
            value.setLayoutData((Object)new GridData(768));
            value.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    fv.value = value.getText();
                }
            });
            l = new Label(composite, 0);
            l.setText(GUIFacetHelper.getString("FacetValueEditor.desc"));
            l.setLayoutData((Object)new GridData(3, 1, false, false));
            final Text desc = new Text(composite, 2048);
            desc.setText(this.fv.description);
            desc.setLayoutData((Object)new GridData(768));
            desc.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    fv.description = desc.getText();
                }
            });
            return composite;
        }

        public FacetValue getValue() {
            return this.fv;
        }
    }
}

