/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleFinal;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDWhiteSpace;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.forms.CheckboxComponentSet;
import org.teiid.designer.ui.forms.ComponentCategory;
import org.teiid.designer.ui.forms.DialogProvider;
import org.teiid.designer.ui.forms.FormTextComponentSet;
import org.teiid.designer.ui.forms.HyperlinkComponentSet;
import org.teiid.designer.ui.forms.LinkedComponentSet;
import org.teiid.designer.ui.forms.MultiComponentSet;
import org.teiid.designer.ui.forms.TextComponentSet;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;
import org.teiid.designer.xsd.ui.ModelerXsdUiPlugin;
import org.teiid.designer.xsd.ui.editor.BaseTypeDialogProvider;
import org.teiid.designer.xsd.ui.editor.ComboFacetSet;
import org.teiid.designer.xsd.ui.editor.EnterpriseTypeDialogProvider;
import org.teiid.designer.xsd.ui.editor.FacetHelper;
import org.teiid.designer.xsd.ui.editor.FacetValueEditorDialog;
import org.teiid.designer.xsd.ui.editor.FormTextFacetSet;
import org.teiid.designer.xsd.ui.editor.SpinnerFacetSet;
import org.teiid.designer.xsd.ui.editor.TableFacetSet;
import org.teiid.designer.xsd.ui.editor.TextDialogProvider;
import org.teiid.designer.xsd.ui.editor.XsdSimpleDatatypesEditorPage;

public class GUIFacetHelper
extends FacetHelper {
    public static final String CATEGORY_NONE = "NONE";
    public static final String CATEGORY_FORMAT = "format";
    public static final String CATEGORY_NUMERIC = "numeric";
    public static final String CATEGORY_BOUNDS = "bounds";
    public static final String CATEGORY_LENGTH = "length";
    public static final String CATEGORY_ENTERPRISE = "enterprise";
    public static final String CATEGORY_INHERITANCE = "inheritance";
    public static final String CATEGORY_ID = "id";
    private static final String[] FACET_CATEGORIES = new String[]{"NONE", "id", "inheritance", "enterprise", "length", "format", "bounds", "numeric"};
    public static final String FAKE_FACET_PREVENT_RESTRICTIONS = "preventrestrictions";
    public static final String FAKE_FACET_RUNTIME = "runtime";
    public static final String FAKE_FACET_ENTERPRISE = "enterprise";
    public static final String FAKE_FACET_BASETYPE = "basetype";
    public static final String FAKE_FACET_DESCRIPTION = "description";
    public static final String FAKE_FACET_NAMESPACE = "namespace";
    public static final String FAKE_FACET_NAME = "name";
    public static final String FAKE_FACET_CREATE_SUBTYPE = "createsubtype";
    public static final String FAKE_FACET_FIND_SUBTYPES = "findsubtypes";
    public static final String FAKE_FACET_FIND_USES = "finduses";
    public static final String FAKE_FACET_OPEN_HIERARCHY = "openhierarchy";
    private static final String GROUP_INHERITANCE_LINKS = "inherit-links";
    public static final String GROUP_INHERITANCE_LINKS_AND_PREVENT = "links-and-prevent";
    public static final String FORM_CHANGE = GUIFacetHelper.getString("GUIFacetHelper.formChange");
    public static final String FORM_DESCRIPTION_ADD = GUIFacetHelper.getString("GUIFacetHelper.formDescription.add");
    private static final String DIALOG_NAME_TITLE_ID = "GUIFacetHelper.dialog.name.title";
    private static final String DIALOG_NAME_DESC_ID = "GUIFacetHelper.dialog.name.desc";
    private static final String DIALOG_NAMESPACE_TITLE_ID = "GUIFacetHelper.dialog.namespace.title";
    private static final String DIALOG_NAMESPACE_DESC_ID = "GUIFacetHelper.dialog.namespace.desc";
    private static final String DIALOG_CREATE_DESC = GUIFacetHelper.getString("GUIFacetHelper.dialog.create.desc");
    private static final String DIALOG_CREATE_TITLE = GUIFacetHelper.getString("GUIFacetHelper.dialog.create.title");
    static final String MESSAGE_NO_NAMESPACE = GUIFacetHelper.getString("GUIFacetHelper.message.noNamespace");
    private static final String PREFIX_CATEGORY = "GUIFacetHelper.facetcategory.";
    private static final String PREFIX_FACET = "GUIFacetHelper.facet.";
    private static final String PREFIX_RESTRICTION = "GUIFacetHelper.restriction.";
    private static final String PREFIX_WHITESPACE = "GUIFacetHelper.whitespace.";
    private static final String SUFFIX_NAME = ".name";
    private static final String SUFFIX_DESCRIPTION = ".desc";
    private static final String RESTRICTION_LIST = XSDSimpleFinal.LIST_LITERAL.getName();
    private static final String RESTRICTION_UNION = XSDSimpleFinal.UNION_LITERAL.getName();
    private static final String RESTRICTION_ATOMIC = XSDSimpleFinal.RESTRICTION_LITERAL.getName();
    private static final String[] RESTRICTION_OPTION_IDS = new String[]{RESTRICTION_ATOMIC, RESTRICTION_LIST, RESTRICTION_UNION};
    private static final String[] RESTRICTION_OPTION_NAMES = new String[]{GUIFacetHelper.getString("GUIFacetHelper.restriction." + RESTRICTION_ATOMIC), GUIFacetHelper.getString("GUIFacetHelper.restriction." + RESTRICTION_LIST), GUIFacetHelper.getString("GUIFacetHelper.restriction." + RESTRICTION_UNION)};
    private static final String WHITESPACE_PRESERVE = XSDWhiteSpace.PRESERVE_LITERAL.getName();
    private static final String WHITESPACE_REPLACE = XSDWhiteSpace.REPLACE_LITERAL.getName();
    public static final String WHITESPACE_COLLAPSE = XSDWhiteSpace.COLLAPSE_LITERAL.getName();
    private static final String[] WHITESPACE_OPTION_IDS = new String[]{WHITESPACE_PRESERVE, WHITESPACE_REPLACE, WHITESPACE_COLLAPSE};
    private static final String[] WHITESPACE_OPTION_NAMES = new String[]{GUIFacetHelper.getString("GUIFacetHelper.whitespace." + WHITESPACE_PRESERVE), GUIFacetHelper.getString("GUIFacetHelper.whitespace." + WHITESPACE_REPLACE), GUIFacetHelper.getString("GUIFacetHelper.whitespace." + WHITESPACE_COLLAPSE)};
    private static final int DEFAULT_MAX_SPIN = 999999;
    private static Map catIDtoFacetList = new HashMap();

    static {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(new FormTextComponentSet(FAKE_FACET_NAMESPACE, GUIFacetHelper.getString("GUIFacetHelper.facet.namespace"), FORM_CHANGE, false, (DialogProvider)new TextDialogProvider(FORM_CHANGE, DIALOG_NAMESPACE_TITLE_ID, DIALOG_NAMESPACE_DESC_ID)));
        catIDtoFacetList.put(CATEGORY_NONE, l);
        l = new ArrayList();
        l.add(new FormTextComponentSet(FAKE_FACET_NAME, GUIFacetHelper.getString("GUIFacetHelper.facet.name"), FORM_CHANGE, false, (DialogProvider)new TextDialogProvider(FORM_CHANGE, DIALOG_NAME_TITLE_ID, DIALOG_NAME_DESC_ID)));
        l.add(new TextComponentSet(FAKE_FACET_DESCRIPTION, GUIFacetHelper.getString("GUIFacetHelper.facet.description"), 2626));
        catIDtoFacetList.put(CATEGORY_ID, l);
        l = new ArrayList();
        l.add(new FormTextComponentSet(FAKE_FACET_BASETYPE, GUIFacetHelper.getString("GUIFacetHelper.facet.basetype"), FORM_CHANGE, true, new BaseTypeDialogProvider(FORM_CHANGE)){

            protected String getUserDisplayString(Object o) {
                if (o instanceof XSDSimpleTypeDefinition) {
                    XSDSimpleTypeDefinition std = (XSDSimpleTypeDefinition)o;
                    String targetNamespace = std.getTargetNamespace();
                    if (targetNamespace == null) {
                        targetNamespace = MESSAGE_NO_NAMESPACE;
                    }
                    return String.valueOf(std.getName()) + "</a>" + " (" + targetNamespace + ") " + "<a nowrap=\"true\" href=\"val\">";
                }
                return super.getUserDisplayString(o);
            }

            protected void valueClicked(Object value) {
                GUIFacetHelper.showObject((EObject)value);
            }
        });
        MultiComponentSet linkSet = new MultiComponentSet(GROUP_INHERITANCE_LINKS, new LinkedComponentSet[]{new HyperlinkComponentSet(FAKE_FACET_CREATE_SUBTYPE, GUIFacetHelper.getString("GUIFacetHelper.facet.createsubtype"), true), new HyperlinkComponentSet(FAKE_FACET_OPEN_HIERARCHY, GUIFacetHelper.getString("GUIFacetHelper.facet.openhierarchy"))}, 512);
        MultiComponentSet linkAndCheckSet = new MultiComponentSet(GROUP_INHERITANCE_LINKS_AND_PREVENT, new LinkedComponentSet[]{linkSet, new CheckboxComponentSet(FAKE_FACET_PREVENT_RESTRICTIONS, GUIFacetHelper.getString("GUIFacetHelper.facet.preventrestrictions"), RESTRICTION_OPTION_IDS, RESTRICTION_OPTION_NAMES, 512)}, 256);
        l.add(linkAndCheckSet);
        catIDtoFacetList.put(CATEGORY_INHERITANCE, l);
        l = new ArrayList();
        l.add(new CheckboxComponentSet("enterprise", GUIFacetHelper.getString("GUIFacetHelper.facet.enterprise")));
        l.add(new FormTextFacetSet(FAKE_FACET_RUNTIME, GUIFacetHelper.getString("GUIFacetHelper.facet.runtime"), null, false, new EnterpriseTypeDialogProvider(FORM_CHANGE)));
        catIDtoFacetList.put("enterprise", l);
        l = new ArrayList();
        l.add(new SpinnerFacetSet(CATEGORY_LENGTH, GUIFacetHelper.getString("GUIFacetHelper.facet.length"), false, 0, 999999));
        l.add(new SpinnerFacetSet("minLength", GUIFacetHelper.getString("GUIFacetHelper.facet.minLength"), false, 0, 999999));
        l.add(new SpinnerFacetSet("maxLength", GUIFacetHelper.getString("GUIFacetHelper.facet.maxLength"), false, 0, 999999));
        catIDtoFacetList.put(CATEGORY_LENGTH, l);
        l = new ArrayList();
        FacetValueEditorDialog dlp = new FacetValueEditorDialog();
        l.add(new ComboFacetSet("whitespace", GUIFacetHelper.getString("GUIFacetHelper.facet.whitespace"), WHITESPACE_OPTION_IDS, WHITESPACE_OPTION_NAMES, WHITESPACE_COLLAPSE));
        l.add(new TableFacetSet("enumeration", GUIFacetHelper.getString("GUIFacetHelper.facet.enumeration"), dlp));
        l.add(new TableFacetSet("pattern", GUIFacetHelper.getString("GUIFacetHelper.facet.pattern"), dlp));
        catIDtoFacetList.put(CATEGORY_FORMAT, l);
        l = new ArrayList();
        l.add(new SpinnerFacetSet("minimum", GUIFacetHelper.getString("GUIFacetHelper.facet.minimum"), true, -999999, 999999));
        l.add(new SpinnerFacetSet("maximum", GUIFacetHelper.getString("GUIFacetHelper.facet.maximum"), true, -999999, 999999));
        catIDtoFacetList.put(CATEGORY_BOUNDS, l);
        l = new ArrayList();
        l.add(new SpinnerFacetSet("totalDigits", GUIFacetHelper.getString("GUIFacetHelper.facet.totalDigits"), false, 0, 999999));
        l.add(new SpinnerFacetSet("fractionDigits", GUIFacetHelper.getString("GUIFacetHelper.facet.fractionDigits"), false, 0, 999999));
        catIDtoFacetList.put(CATEGORY_NUMERIC, l);
    }

    public static ComponentCategory[] getCategories(Object transactionSource) {
        ComponentCategory[] rv = new ComponentCategory[FACET_CATEGORIES.length];
        int i = 0;
        while (i < rv.length) {
            String id = FACET_CATEGORIES[i];
            String name = GUIFacetHelper.getString(PREFIX_CATEGORY + id + SUFFIX_NAME);
            String desc = GUIFacetHelper.getString(PREFIX_CATEGORY + id + SUFFIX_DESCRIPTION);
            rv[i] = new ComponentCategory(id, name, desc, id != CATEGORY_NONE);
            GUIFacetHelper.addFacets(rv[i], transactionSource);
            rv[i].setVisible(false);
            ++i;
        }
        return rv;
    }

    private static void addFacets(ComponentCategory category, Object transactionSource) {
        String id = category.getID();
        List l = (List)catIDtoFacetList.get(id);
        if (l != null) {
            Iterator itor = l.iterator();
            while (itor.hasNext()) {
                LinkedComponentSet lcs = ((LinkedComponentSet)itor.next()).cloneSet();
                lcs.setCategory(category);
                if (lcs instanceof TableFacetSet) {
                    TableFacetSet tfs = (TableFacetSet)lcs;
                    tfs.setTransactionSource(transactionSource);
                }
                category.addComponentSet(lcs);
            }
            category.setVisible(true);
        } else {
            category.setVisible(false);
        }
    }

    public static String getString(String i18id) {
        return ModelerXsdUiConstants.Util.getString(i18id, new Object[0]);
    }

    public static boolean isReady(Control c) {
        return c != null && !c.isDisposed();
    }

    public static void showObject(EObject o) {
        ModelResource mRes = ModelUtilities.getModelResourceForModelObject((EObject)o);
        if (mRes != null) {
            ModelEditorManager.open((EObject)o, (boolean)true);
        } else {
            ModelEditor me;
            IEditorPart activeEditor = ModelerXsdUiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage().getActiveEditor();
            if (activeEditor instanceof ModelEditor && (activeEditor = (me = (ModelEditor)activeEditor).getActiveEditor()) instanceof XsdSimpleDatatypesEditorPage) {
                XsdSimpleDatatypesEditorPage simpPage = (XsdSimpleDatatypesEditorPage)activeEditor;
                simpPage.openContext(o);
            }
        }
    }

    public static XSDSimpleTypeDefinition createType(XSDSchema location, XSDSimpleTypeDefinition baseType) {
        return GUIFacetHelper.createType(null, location, baseType);
    }

    public static XSDSimpleTypeDefinition createType(Shell s, XSDSchema location, XSDSimpleTypeDefinition baseType) {
        InputDialog idlg = new InputDialog(s, DIALOG_CREATE_TITLE, DIALOG_CREATE_DESC, "", null);
        idlg.setBlockOnOpen(true);
        idlg.open();
        String typeName = idlg.getValue();
        XSDSimpleTypeDefinition std = null;
        if (typeName != null) {
            std = FacetHelper.createAtomicSimpleTypeDefinintion(location, typeName, baseType);
        }
        return std;
    }
}

