/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.TransactionRunnable;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.ui.actions.ClipboardActionHandler;
import org.teiid.designer.ui.actions.ClipboardActionsAdapter;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.SystemClipboardUtilities;
import org.teiid.designer.ui.common.widget.AbstractTableLabelProvider;
import org.teiid.designer.ui.common.widget.DefaultContentProvider;
import org.teiid.designer.ui.forms.ComponentSetEvent;
import org.teiid.designer.ui.forms.ComponentSetMonitor;
import org.teiid.designer.ui.forms.DialogProvider;
import org.teiid.designer.ui.forms.LinkedComponentSet;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;
import org.teiid.designer.xsd.ui.editor.AbstractFacetSet;
import org.teiid.designer.xsd.ui.editor.FacetValue;
import org.teiid.designer.xsd.ui.editor.GUIFacetHelper;
import org.teiid.designer.xsd.ui.editor.MultiFacetSet;

public class TableFacetSet
extends AbstractFacetSet
implements MultiFacetSet {
    private static final String COL_SEP = "\t";
    static final String LINE_SEP = System.getProperty("line.separator");
    static final String TRANSACTION_PASTE = GUIFacetHelper.getString("TableFacetSet.transactionPaste");
    private static final String TRANSACTION_DELETE = GUIFacetHelper.getString("TableFacetSet.transactionDelete");
    private final DialogProvider provider;
    Object transactionSource;
    TableViewer viewer;
    private List dataList;
    private MyListener myList;
    private ComponentSetMonitor mon;

    public TableFacetSet(String id, String labelName, DialogProvider dlp) {
        super(id, labelName, false, false);
        this.provider = dlp;
    }

    public void setTransactionSource(Object transactionSource) {
        this.transactionSource = transactionSource;
    }

    @Override
    protected void addMainControl(Composite parent, FormToolkit ftk, ComponentSetMonitor mon) {
        this.mon = mon;
        this.init();
        this.viewer = new TableViewer(ftk.createTable(parent, 8456194));
        this.viewer.setContentProvider((IContentProvider)new MyContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MyTableLabelProvider());
        this.viewer.setSorter(new ViewerSorter());
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new TableWrapData(256, 256));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        new ClipboardActionsAdapter((Control)table, (ClipboardActionHandler)new MyClipActionHandler());
        TableColumn col = new TableColumn(table, 16384);
        col.setText(LABEL_VALUE);
        col = new TableColumn(table, 16384);
        col.setText(LABEL_DESCRIPTION);
        this.packColumns();
        this.viewer.setInput((Object)this.dataList);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this.myList);
        Composite c = ftk.createComposite(parent);
        c.setLayout((Layout)new FillLayout(512));
        Button add = ftk.createButton(c, LABEL_ADD, 0);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableFacetSet.this.addRowObject();
            }
        });
        final Button edit = ftk.createButton(c, this.provider.getLaunchButtonText(), 0);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                edit.setEnabled(SelectionUtilities.isSingleSelection((ISelection)event.getSelection()));
            }
        });
        edit.setEnabled(false);
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableFacetSet.this.editRowObject(SelectionUtilities.getSelectedObject((ISelection)TableFacetSet.this.viewer.getSelection()));
            }
        });
        final Button remove = ftk.createButton(c, LABEL_REMOVE, 0);
        remove.setEnabled(false);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                remove.setEnabled(!event.getSelection().isEmpty());
            }
        });
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableFacetSet.this.removeSelectedRows();
            }
        });
    }

    @Override
    protected void setMainValue(Object value) {
        if (value instanceof List) {
            this.init();
            List l = (List)value;
            this.dataList.clear();
            this.dataList.addAll(l);
            if (this.viewer != null) {
                this.viewer.refresh();
                this.reflow();
            }
        } else if (value == null) {
            this.clear();
        }
    }

    @Override
    public void addValue(FacetValue fv, boolean reflow) {
        this.init();
        this.dataList.add(fv);
        if (this.viewer != null) {
            this.viewer.add((Object)fv);
            if (reflow) {
                this.reflow();
            }
        }
    }

    @Override
    public void reflow() {
        this.packColumns();
        this.getCategory().reflowForm();
    }

    @Override
    public void clear() {
        this.init();
        this.dataList.clear();
        if (this.viewer != null) {
            this.viewer.refresh();
            this.reflow();
        }
    }

    private void init() {
        if (this.dataList == null) {
            this.dataList = new ArrayList();
            this.myList = new MyListener();
        }
    }

    private void packColumns() {
        Table table = this.viewer.getTable();
        int i = 0;
        while (i < table.getColumnCount()) {
            TableColumn col = table.getColumn(i);
            col.pack();
            if (col.getWidth() > 200) {
                col.setWidth(200);
            }
            ++i;
        }
    }

    void addRowObject() {
        this.provider.showDialog(this.viewer.getTable().getShell(), (Object)new FacetValue());
        if (!this.provider.wasCancelled()) {
            FacetValue newVal = (FacetValue)this.provider.getValue();
            this.addValue(newVal, true);
            this.fireChange(newVal, false);
        }
    }

    void editRowObject(Object selected) {
        this.provider.showDialog(this.viewer.getTable().getShell(), selected);
        if (!this.provider.wasCancelled()) {
            this.viewer.refresh(this.provider.getValue());
            this.packColumns();
            this.fireChange((FacetValue)selected, false);
        }
    }

    private void removeRowObjects(final List selected) {
        this.dataList.removeAll(selected);
        this.viewer.remove(selected.toArray());
        this.reflow();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) {
                for (FacetValue fv : selected) {
                    fv.value = null;
                    TableFacetSet.this.fireChange(fv, true);
                }
                return null;
            }
        };
        try {
            ModelerCore.getModelEditor().executeAsTransaction(runnable, TRANSACTION_DELETE, true, true, this.transactionSource);
        }
        catch (ModelerCoreException mce) {
            ModelerXsdUiConstants.Util.log((Throwable)mce);
        }
    }

    void fireChange(FacetValue newValue, boolean delete) {
        this.mon.update(new ComponentSetEvent((LinkedComponentSet)this, delete, (Object)newValue));
    }

    void removeSelectedRows() {
        this.removeRowObjects(SelectionUtilities.getSelectedObjects((ISelection)this.viewer.getSelection()));
    }

    class MyClipActionHandler
    implements ClipboardActionHandler {
        MyClipActionHandler() {
        }

        public void cut() {
            this.copy();
            this.delete();
        }

        public void copy() {
            StringBuffer toClip = new StringBuffer();
            List l = ((IStructuredSelection)TableFacetSet.this.viewer.getSelection()).toList();
            int size = l.size();
            int i = 0;
            while (i < size) {
                FacetValue fv = (FacetValue)l.get(i);
                if (i > 0) {
                    toClip.append(LINE_SEP);
                }
                toClip.append(fv.value).append(TableFacetSet.COL_SEP);
                if (fv.description != null && fv.description.length() > 0) {
                    toClip.append(fv.description);
                }
                ++i;
            }
            SystemClipboardUtilities.setContents((String)toClip.toString());
        }

        public void paste() {
            TransactionRunnable runnable = new TransactionRunnable(){

                public Object run(UnitOfWork uow) {
                    String contents = SystemClipboardUtilities.getContents();
                    if (contents != null) {
                        List toInsert = SystemClipboardUtilities.convertTableData((String)contents);
                        int i = 0;
                        while (i < toInsert.size()) {
                            List columns = (List)toInsert.get(i);
                            int size = columns.size();
                            if (size != 1 && size != 2) {
                                ModelerXsdUiConstants.Util.log((Object)ModelerXsdUiConstants.Util.getString("TableFacetSet.badRowFormat", (Object)columns.toString()));
                            } else {
                                FacetValue fv = new FacetValue();
                                fv.value = columns.get(0);
                                if (size == 2) {
                                    fv.description = (String)columns.get(1);
                                }
                                TableFacetSet.this.addValue(fv, false);
                                TableFacetSet.this.fireChange(fv, false);
                            }
                            ++i;
                        }
                    }
                    return null;
                }
            };
            try {
                ModelerCore.getModelEditor().executeAsTransaction(runnable, TRANSACTION_PASTE, true, true, TableFacetSet.this.transactionSource);
            }
            catch (ModelerCoreException mce) {
                ModelerXsdUiConstants.Util.log((Throwable)mce);
            }
            TableFacetSet.this.reflow();
        }

        public void delete() {
            TableFacetSet.this.removeSelectedRows();
        }

        public void selectAll() {
            TableFacetSet.this.viewer.getTable().selectAll();
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            TableFacetSet.this.viewer.addSelectionChangedListener(listener);
        }
    }

    static class MyContentProvider
    extends DefaultContentProvider {
        private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

        MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List l;
            if (inputElement instanceof List && (l = (List)inputElement).size() > 0) {
                return l.toArray();
            }
            return EMPTY_OBJECT_ARRAY;
        }
    }

    class MyListener
    implements IDoubleClickListener {
        MyListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            TableFacetSet.this.editRowObject(((IStructuredSelection)event.getSelection()).getFirstElement());
        }
    }

    static class MyTableLabelProvider
    extends AbstractTableLabelProvider
    implements ILabelProvider {
        private static final int VALUE_COLUMN = 0;
        private static final int DESC_COLUMN = 1;

        MyTableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof FacetValue) {
                FacetValue fv = (FacetValue)element;
                switch (columnIndex) {
                    case 0: {
                        return fv.value != null ? fv.value.toString() : null;
                    }
                    case 1: {
                        return fv.description;
                    }
                }
            }
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof FacetValue) {
                FacetValue fv = (FacetValue)element;
                return fv.value != null ? fv.value.toString() : fv.toString();
            }
            return element != null ? element.toString() : null;
        }
    }
}

