/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import java.util.Collections;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.provider.XSDSemanticItemProviderAdapterFactory;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.editors.AbstractModelEditorPageActionBarContributor;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.ModelEditorPageOutline;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;
import org.teiid.designer.xsd.ui.ModelerXsdUiPlugin;
import org.teiid.designer.xsd.ui.editor.XsdSemanticsEditorActionContributor;
import org.teiid.designer.xsd.ui.editor.XsdSemanticsNotificationHandler;

public class XsdSemanticsEditorPage
implements ModelEditorPage,
ISelectionChangedListener,
IGotoMarker {
    private static final String NAME = ModelerXsdUiConstants.Util.getString("xsdSemanticsEditor.name", new Object[0]);
    private static final String TOOLTIP = ModelerXsdUiConstants.Util.getString("xsdSemanticsEditor.tooltip", new Object[0]);
    TreeViewer treeViewer;
    private XSDSemanticItemProviderAdapterFactory semanticAdapterFactory;
    private INotifyChangedListener notificationListener;
    protected XSDSchema xsdSchema;
    private Resource xsdResource;
    private XsdSemanticsEditorActionContributor actionContributor;
    private IEditorSite theSite;
    private IEditorInput theInput;

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
    }

    public XSDSchema getXsdSchema() {
        XSDResourceImpl rsrc;
        if (this.xsdSchema != null && this.xsdSchema.eResource() != null) {
            return this.xsdSchema;
        }
        if (this.xsdResource != null && this.xsdResource instanceof XSDResourceImpl && (rsrc = (XSDResourceImpl)this.xsdResource) != null) {
            this.xsdSchema = rsrc.getSchema();
        }
        return this.xsdSchema;
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public boolean canDisplay(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ModelUtil.isXsdFile((IResource)((IFileEditorInput)input).getFile());
        }
        return false;
    }

    public boolean canOpenContext(Object input) {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent);
        this.semanticAdapterFactory = new XSDSemanticItemProviderAdapterFactory();
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.semanticAdapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.semanticAdapterFactory));
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!(parentElement instanceof EObject) && element instanceof XSDSimpleTypeDefinition) {
                    XSDSimpleTypeDefinition std = (XSDSimpleTypeDefinition)element;
                    return std.getSchema() == XsdSemanticsEditorPage.this.xsdSchema;
                }
                return true;
            }
        });
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.setInput((Object)new ItemProvider(Collections.singleton(this.getXsdSchema())));
        this.createContextMenu();
    }

    protected void createContextMenu() {
    }

    public void dispose() {
        if (this.semanticAdapterFactory != null) {
            this.semanticAdapterFactory.dispose();
        }
    }

    public void preDispose() {
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public AbstractModelEditorPageActionBarContributor getActionBarContributor() {
        if (this.actionContributor == null) {
            this.actionContributor = new XsdSemanticsEditorActionContributor(this);
        }
        return this.actionContributor;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public Control getControl() {
        return this.treeViewer.getControl();
    }

    public IEditorInput getEditorInput() {
        return this.theInput;
    }

    public IEditorSite getEditorSite() {
        return this.theSite;
    }

    public ISelectionChangedListener getModelObjectSelectionChangedListener() {
        return null;
    }

    public ISelectionProvider getModelObjectSelectionProvider() {
        return this.treeViewer;
    }

    public INotifyChangedListener getNotifyChangedListener() {
        if (this.notificationListener == null) {
            this.notificationListener = new XsdSemanticsNotificationHandler(this.treeViewer, this.xsdResource, (IWorkbenchPart)this.getSite().getPage().getActiveEditor());
        }
        return this.notificationListener;
    }

    public ModelEditorPageOutline getOutlineContribution() {
        return null;
    }

    public IWorkbenchPartSite getSite() {
        return this.theSite;
    }

    public String getTitle() {
        return NAME;
    }

    public Image getTitleImage() {
        return ModelerXsdUiPlugin.getDefault().getImage("icons/full/cview16/semantics.gif");
    }

    public String getTitleToolTip() {
        return TOOLTIP;
    }

    public void setTitleText(String title) {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.theSite = site;
        this.theInput = input;
        if (input instanceof IFileEditorInput) {
            try {
                IFile xsdFile = ((IFileEditorInput)input).getFile();
                if (xsdFile == null) {
                    String msg = ModelerXsdUiConstants.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_2", (Object)input.getName());
                    throw new PartInitException(msg);
                }
                String xsdLocation = xsdFile.getLocation().toString();
                URI xsdUri = URI.createFileURI((String)xsdLocation);
                this.xsdResource = ModelerCore.getModelContainer().getResource(xsdUri, true);
                if (this.xsdResource == null) {
                    String msg = ModelerXsdUiConstants.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_1", (Object)input.getName());
                    throw new PartInitException(msg);
                }
                xsdFile.getProject();
            }
            catch (ModelWorkspaceException e) {
                String msg = ModelerXsdUiConstants.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_2", (Object)input.getName());
                throw new PartInitException(msg, (Throwable)e);
            }
            catch (CoreException e) {
                String msg = ModelerXsdUiConstants.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_2", (Object)input.getName());
                throw new PartInitException(msg, (Throwable)e);
            }
        } else {
            throw new PartInitException(ModelerXsdUiConstants.Util.getString("XsdEditor.Invalid_Input__Must_be_IFileEditorInput._33", new Object[0]));
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void initializeEditorPage() {
    }

    public void openContext(Object input) {
    }

    public void openContext(Object input, boolean forceRefresh) {
    }

    public void removePropertyListener(IPropertyListener listener) {
    }

    public void setFocus() {
    }

    public void setLabelProvider(ILabelProvider provider) {
    }

    public void updateReadOnlyState(boolean isReadOnly) {
    }

    public void processEvent(EventObject obj) {
        ModelResourceEvent event = (ModelResourceEvent)obj;
        if (event.getType() == 6) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    XsdSemanticsEditorPage.this.treeViewer.setAutoExpandLevel(2);
                    XsdSemanticsEditorPage.this.treeViewer.setInput((Object)new ItemProvider(Collections.singleton(XsdSemanticsEditorPage.this.getXsdSchema())));
                }
            });
        }
    }

    public void openComplete() {
    }

    public boolean isSelectedFirst(IEditorInput input) {
        return false;
    }
}

