/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.xerces.util.EncodingMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDParser;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.editors.AbstractModelEditorPageActionBarContributor;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.ModelEditorPageOutline;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XsdTextEditorPage
extends TextEditor
implements ModelEditorPage,
ISelectionProvider,
IDocumentListener {
    private static final String NAME = ModelerXsdUiConstants.Util.getString("xsdTextEditor.name", new Object[0]);
    private static final String TOOLTIP = ModelerXsdUiConstants.Util.getString("xsdTextEditor.tooltip", new Object[0]);
    protected ISourceViewer sourceViewer;
    protected Timer timer = new Timer();
    protected TimerTask timerTask;
    protected boolean timerCancelled = false;
    protected ModelResource modelResource;
    protected XSDSchema xsdSchema;
    private Resource xsdResource;
    protected IDocument document;
    protected Collection selectionChangedListeners = new ArrayList();
    protected ISelection editorSelection;
    protected ISelectionChangedListener selectionChangedListener;
    protected INotifyChangedListener notifyChangedListener = new INotifyChangedListener(){

        public void notifyChanged(Notification notification) {
            Object changedObject;
            if (XsdTextEditorPage.this.getXsdSchema() != null && notification instanceof SourcedNotification && ((SourcedNotification)notification).getSource() != null && (changedObject = ModelerCore.getModelEditor().getChangedObject(notification)) != null) {
                ModelResource mr = null;
                if (changedObject instanceof EObject) {
                    mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)changedObject));
                } else if (changedObject instanceof ModelResource) {
                    mr = (ModelResource)changedObject;
                }
                if (mr != null && mr.equals(XsdTextEditorPage.this.modelResource)) {
                    XsdTextEditorPage.this.handleStructuredModelChange(true);
                } else if (changedObject.equals(XsdTextEditorPage.this.xsdSchema)) {
                    XsdTextEditorPage.this.handleStructuredModelChange(true);
                }
            }
        }
    };
    protected boolean handledStructuredModelChange = false;

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ISourceViewer result = super.createSourceViewer(parent, ruler, styles);
        result.getTextWidget().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                XsdTextEditorPage.this.handleSourceCaretPosition();
            }
        });
        result.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                switch (event.keyCode) {
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: 
                    case 0x1000005: 
                    case 0x1000006: {
                        XsdTextEditorPage.this.handleSourceCaretPosition();
                    }
                }
            }
        });
        this.sourceViewer = result;
        return result;
    }

    protected void initDocument() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Create XSD Editor Model", (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.createModel();
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        String encoding = this.determineEncoding();
        IEncodingSupport encodingSupport = (IEncodingSupport)this.getAdapter(IEncodingSupport.class);
        if (encodingSupport != null && encoding != null) {
            encodingSupport.setEncoding(encoding);
        }
        this.document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        this.document.addDocumentListener((IDocumentListener)this);
        this.modelResource = ModelUtilities.getModelResource((Resource)this.xsdResource, (boolean)false);
    }

    protected void createModel() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        progressMonitor.beginTask(ModelerXsdUiConstants.Util.getString("XsdEditor._22", new Object[0]), 10);
                        IFileEditorInput modelFile = (IFileEditorInput)XsdTextEditorPage.this.getEditorInput();
                        IFile file = modelFile.getFile();
                        Container resourceSet = ModelerCore.getModelContainer();
                        resourceSet.getLoadOptions().put(XSDResourceImpl.XSD_PROGRESS_MONITOR, progressMonitor);
                        XsdTextEditorPage.this.createResource(file.getLocation().toString(), (ResourceSet)resourceSet);
                        resourceSet.getLoadOptions().remove(XSDResourceImpl.XSD_PROGRESS_MONITOR);
                        progressMonitor.worked(1);
                        String msg = ModelerXsdUiConstants.Util.getString("_UI_Validating_message", new Object[0]);
                        progressMonitor.subTask(msg);
                        if (XsdTextEditorPage.this.isValidateSchemaPreferenceOn() && XsdTextEditorPage.this.getXsdSchema().getAllDiagnostics().isEmpty()) {
                            XsdTextEditorPage.this.getXsdSchema().validate();
                            XsdTextEditorPage.this.getXsdSchema().eResource().setModified(false);
                        }
                        progressMonitor.worked(1);
                        progressMonitor.subTask(ModelerXsdUiConstants.Util.getString("_UI_ReportingErrors_message", new Object[0]));
                        XsdTextEditorPage.this.handleDocumentChange(false);
                    }
                    catch (Throwable t) {
                        ModelerXsdUiConstants.Util.log(t);
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception exception) {
            ModelerXsdUiConstants.Util.log((Throwable)exception);
        }
    }

    boolean isValidateSchemaPreferenceOn() {
        boolean result = false;
        String pref = this.getValidateSchemaUserPreference();
        if (pref.equals("error") || pref.equals("warning") || pref.equals("info")) {
            result = true;
        }
        return result;
    }

    private String getValidateSchemaUserPreference() {
        IEclipsePreferences prefs = ModelerCore.getPreferences((String)"org.teiid.designer.core");
        String value = prefs.get("xsdPreferences.performValidation", null);
        if (value == null) {
            prefs = ModelerCore.getDefaultPreferences((String)"org.teiid.designer.core");
            value = prefs.get("xsdPreferences.performValidation", "warning");
        }
        return value;
    }

    private int getValidateSchemaUserPreferenceMarkerSeverity() {
        int result = -1;
        String pref = this.getValidateSchemaUserPreference();
        if (pref.equals("error")) {
            result = 2;
        } else if (pref.equals("warning")) {
            result = 1;
        } else if (pref.equals("info")) {
            result = 0;
        }
        return result;
    }

    protected void createResource(String uri, ResourceSet resourceSet) {
        this.extendedCreateResource(uri, resourceSet);
    }

    protected void extendedCreateResource(String uri, ResourceSet resourceSet) {
        resourceSet.getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
        try {
            XSDResourceImpl xsdResource = (XSDResourceImpl)resourceSet.getResource(URI.createFileURI((String)uri), true);
            this.xsdSchema = xsdResource.getSchema();
            this.getDocumentProvider().addElementStateListener(new IElementStateListener(){

                public void elementDirtyStateChanged(Object element, boolean isDirty) {
                }

                public void elementContentAboutToBeReplaced(Object element) {
                }

                public void elementContentReplaced(Object element) {
                }

                public void elementDeleted(Object element) {
                    Display display = XsdTextEditorPage.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).XsdTextEditorPage.this.sourceViewer != null) {
                                XsdTextEditorPage.this.getSite().getPage().closeEditor((IEditorPart)XsdTextEditorPage.this, false);
                            }
                        }
                    });
                }

                public void elementMoved(Object originalElement, Object movedElement) {
                }
            });
        }
        catch (Exception exception) {
            ModelerXsdUiConstants.Util.log((Throwable)exception);
        }
    }

    protected void handleDocumentChange(boolean setModified) {
        if (this.sourceViewer != null) {
            try {
                XSDParser xsdParser = new XSDParser(null);
                IDocument iDocument = this.sourceViewer.getDocument();
                if (iDocument != null) {
                    String documentContent = iDocument.get();
                    byte[] bytes = documentContent.getBytes();
                    xsdParser.parse((InputStream)new ByteArrayInputStream(bytes));
                    xsdParser.setSchema(this.getXsdSchema());
                    if (this.isValidateSchemaPreferenceOn() && this.getXsdSchema().getAllDiagnostics().isEmpty()) {
                        this.getXsdSchema().validate();
                    }
                    if (setModified) {
                        this.getXsdSchema().eResource().setModified(true);
                    }
                    this.handleDiagnostics(null);
                }
            }
            catch (Exception exception) {
                ModelerXsdUiConstants.Util.log((Throwable)exception);
            }
        }
    }

    protected void handleStructuredModelChange(boolean setModified) {
        final IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (this.getXsdSchema().getElement() == null) {
            this.getXsdSchema().updateElement();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.getXsdSchema().eResource().save((OutputStream)out, null);
            String encoding = this.determineEncoding();
            String newContent = encoding == null ? out.toString() : out.toString(encoding);
            String oldContent = document.get();
            int startIndex = 0;
            while (startIndex < newContent.length() && startIndex < oldContent.length() && newContent.charAt(startIndex) == oldContent.charAt(startIndex)) {
                ++startIndex;
            }
            int newEndIndex = newContent.length() - 1;
            int oldEndIndex = oldContent.length() - 1;
            while (newEndIndex >= startIndex && oldEndIndex >= startIndex && newContent.charAt(newEndIndex) == oldContent.charAt(oldEndIndex)) {
                --newEndIndex;
                --oldEndIndex;
            }
            final int start = startIndex;
            final String replacement = newContent.substring(startIndex, newEndIndex + 1);
            final int length = oldEndIndex - startIndex + 1;
            this.handledStructuredModelChange = true;
            UiUtil.runInSwtThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        document.replace(start, length, replacement);
                    }
                    catch (Exception exception) {
                        ModelerXsdUiConstants.Util.log((Throwable)exception);
                    }
                }
            }, (boolean)false);
            if (setModified) {
                this.getXsdSchema().eResource().setModified(true);
            }
        }
        catch (Exception exception) {
            ModelerXsdUiConstants.Util.log((Throwable)exception);
        }
    }

    protected String determineEncoding() {
        String encoding = (String)((XSDResourceImpl)this.getXsdSchema().eResource()).getDefaultSaveOptions().get(XSDResourceImpl.XSD_ENCODING);
        if (encoding != null && EncodingMap.getIANA2JavaMapping((String)encoding) != null) {
            encoding = EncodingMap.getIANA2JavaMapping((String)encoding);
        }
        return encoding;
    }

    protected void handleSourceCaretPosition() {
        if (this.sourceViewer != null) {
            int offset = this.sourceViewer.getTextWidget().getCaretOffset();
            Element element = this.getXsdSchema().getElement();
            if (element != null) {
                IDocument document = this.sourceViewer.getDocument();
                int line = 0;
                int lineOffset = 0;
                try {
                    line = document.getLineOfOffset(offset);
                    lineOffset = document.getLineOffset(line);
                }
                catch (BadLocationException badLocationException) {}
                int column = offset - lineOffset;
                Element bestElement = this.findBestElement(element, line + 1, column + 1);
                if (bestElement != null) {
                    this.handleSelectedNodes(Collections.singleton(bestElement));
                }
            }
        }
    }

    protected Element findBestElement(Element element, int line, int column) {
        int startLine = XSDParser.getStartLine((Node)element);
        int startColumn = XSDParser.getStartColumn((Node)element);
        int endLine = XSDParser.getEndLine((Node)element);
        int endColumn = XSDParser.getEndColumn((Node)element);
        Element candidate = null;
        if ((line == startLine ? column >= startColumn : line > startLine) && (line == endLine ? column <= endColumn : line < endLine)) {
            candidate = element;
            Node child = element.getFirstChild();
            while (child != null) {
                Element childElement;
                Element betterCandidate;
                if (child.getNodeType() == 1 && (betterCandidate = this.findBestElement(childElement = (Element)child, line, column)) != null) {
                    candidate = betterCandidate;
                    break;
                }
                child = child.getNextSibling();
            }
        }
        return candidate;
    }

    public void handleSelectedNodes(Collection nodes) {
        ArrayList<XSDConcreteComponent> selection = new ArrayList<XSDConcreteComponent>();
        for (Node node : nodes) {
            XSDConcreteComponent bestXSDConcreteComponent = this.getXsdSchema().getCorrespondingComponent(node);
            if (bestXSDConcreteComponent == null) continue;
            boolean add = true;
            XSDConcreteComponent parent = bestXSDConcreteComponent;
            while (parent != null) {
                if (selection.contains(parent)) {
                    add = false;
                    break;
                }
                parent = parent.getContainer();
            }
            if (!add) continue;
            XSDConcreteComponent container = bestXSDConcreteComponent.getContainer();
            if (container instanceof XSDParticle || container instanceof XSDAttributeUse) {
                bestXSDConcreteComponent = container;
            }
            selection.add(bestXSDConcreteComponent);
        }
        if (!selection.isEmpty()) {
            StructuredSelection newSelection = new StructuredSelection(selection.toArray());
            this.handleContentOutlineSelectionForTextEditor((ISelection)newSelection, false);
        }
    }

    public void handleContentOutlineSelectionForTextEditor(ISelection selection, boolean reveal) {
        Object o = ((IStructuredSelection)selection).iterator().next();
        if (o instanceof XSDConcreteComponent) {
            Element element;
            XSDParticle xsdParticle;
            XSDParticleContent content;
            XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)o;
            if (xsdConcreteComponent instanceof XSDParticle && (content = (xsdParticle = (XSDParticle)xsdConcreteComponent).getContent()) != null) {
                xsdConcreteComponent = content;
            }
            if ((element = xsdConcreteComponent.getElement()) != null) {
                try {
                    IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
                    int startLine = XSDParser.getStartLine((Node)element);
                    int startColumn = XSDParser.getStartColumn((Node)element);
                    int endLine = XSDParser.getEndLine((Node)element);
                    int endColumn = XSDParser.getEndColumn((Node)element);
                    int startOffset = document.getLineOffset(startLine - 1);
                    startOffset += startColumn - 1;
                    int endOffset = document.getLineOffset(endLine - 1);
                    endOffset += endColumn - 1;
                    if (startLine == endLine) {
                        this.setHighlightRange(startOffset, endOffset - startOffset, false);
                        if (reveal) {
                            this.selectAndReveal(startOffset, endOffset - startOffset);
                        }
                    } else {
                        this.setHighlightRange(startOffset, endOffset - startOffset, reveal);
                    }
                }
                catch (Exception exception) {
                    ModelerXsdUiConstants.Util.log((Throwable)exception);
                }
            }
        }
    }

    protected XSDSchema getXsdSchema() {
        XSDResourceImpl rsrc;
        if (this.xsdSchema != null && this.xsdSchema.eResource() != null) {
            return this.xsdSchema;
        }
        if (this.xsdResource != null && this.xsdResource instanceof XSDResourceImpl && (rsrc = (XSDResourceImpl)this.xsdResource) != null) {
            this.xsdSchema = rsrc.getSchema();
        }
        return this.xsdSchema;
    }

    protected void initializeMarkerPosition(IMarker marker, XSDDiagnostic xsdDiagnostic) throws CoreException {
        Node node = xsdDiagnostic.getNode();
        if (node != null && node.getNodeType() == 2) {
            node = ((Attr)node).getOwnerElement();
        }
        if (node != null && XSDParser.getUserData((Node)node) != null) {
            int startLine = XSDParser.getStartLine((Node)node) - 1;
            int startColumn = XSDParser.getStartColumn((Node)node);
            int endLine = XSDParser.getEndLine((Node)node) - 1;
            int endColumn = XSDParser.getEndColumn((Node)node);
            marker.setAttribute("lineNumber", startLine);
            try {
                IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
                marker.setAttribute("charStart", document.getLineOffset(startLine) + startColumn - 1);
                marker.setAttribute("charEnd", document.getLineOffset(endLine) + endColumn - 1);
            }
            catch (BadLocationException badLocationException) {}
        } else {
            marker.setAttribute("lineNumber", xsdDiagnostic.getLine());
        }
    }

    protected void handleDiagnostics(IProgressMonitor progressMonitor) {
        if (!this.isValidateSchemaPreferenceOn()) {
            return;
        }
        if (progressMonitor == null) {
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor localProgressMonitor) {
                    XsdTextEditorPage.this.handleDiagnostics(localProgressMonitor);
                }
            };
            try {
                ModelerCore.getWorkspace().run(operation, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                ModelerXsdUiConstants.Util.log((Throwable)exception);
            }
        } else {
            XSDConcreteComponent newSelection = null;
            try {
                int userPref = this.getValidateSchemaUserPreferenceMarkerSeverity();
                IFileEditorInput modelFile = (IFileEditorInput)this.getEditorInput();
                IFile file = modelFile.getFile();
                IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                ArrayList<IMarker> deletableMarkers = new ArrayList<IMarker>(Arrays.asList(markers));
                for (XSDDiagnostic xsdDiagnostic : this.getXsdSchema().getAllDiagnostics()) {
                    int severity;
                    String uriReferencePath = this.getXsdSchema().eResource().getURIFragment((EObject)xsdDiagnostic);
                    IMarker marker = null;
                    int i = 0;
                    while (i < markers.length) {
                        if (markers[i].getAttribute("diagnostic", ModelerXsdUiConstants.Util.getString("XsdEditor._29", new Object[0])).equals(uriReferencePath)) {
                            marker = markers[i];
                            deletableMarkers.remove(marker);
                            break;
                        }
                        ++i;
                    }
                    if (marker == null) {
                        marker = file.createMarker("org.eclipse.xsd.diagnostic");
                        marker.setAttribute("diagnostic", (Object)uriReferencePath);
                    }
                    this.initializeMarkerPosition(marker, xsdDiagnostic);
                    marker.setAttribute("message", (Object)xsdDiagnostic.getMessage());
                    switch (xsdDiagnostic.getSeverity().getValue()) {
                        case 0: 
                        case 1: {
                            if (newSelection == null) {
                                newSelection = xsdDiagnostic.getPrimaryComponent();
                            }
                            marker.setAttribute("severity", 2);
                            break;
                        }
                        case 2: {
                            marker.setAttribute("severity", 1);
                            break;
                        }
                        case 3: {
                            marker.setAttribute("severity", 0);
                        }
                    }
                    Object markerSeverity = marker.getAttribute("severity");
                    if (userPref == -1 || markerSeverity == null || !(markerSeverity instanceof Integer) || (severity = ((Integer)markerSeverity).intValue()) <= userPref) continue;
                    while (--severity > userPref) {
                    }
                    marker.setAttribute("severity", severity);
                }
                for (IMarker marker : deletableMarkers) {
                    marker.delete();
                }
            }
            catch (Exception exception) {
                ModelerXsdUiConstants.Util.log((Throwable)exception);
            }
            if (this.editorSelection != null) {
                this.setSelectionInternal(this.editorSelection);
            } else if (newSelection != null) {
                StructuredSelection errorSelection = new StructuredSelection(newSelection);
                this.getSite().getShell().getDisplay().asyncExec(new Runnable((IStructuredSelection)errorSelection){
                    private final /* synthetic */ IStructuredSelection val$errorSelection;
                    {
                        this.val$errorSelection = iStructuredSelection;
                    }

                    @Override
                    public void run() {
                        XsdTextEditorPage.this.setSelectionInternal((ISelection)this.val$errorSelection);
                        XsdTextEditorPage.this.handleSourceCaretPosition();
                    }
                });
            }
        }
    }

    public boolean canDisplay(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ModelUtil.isXsdFile((IResource)((IFileEditorInput)input).getFile());
        }
        return false;
    }

    public boolean canOpenContext(Object input) {
        return false;
    }

    public AbstractModelEditorPageActionBarContributor getActionBarContributor() {
        return null;
    }

    public Control getControl() {
        return super.getSourceViewer().getTextWidget();
    }

    public ISelectionChangedListener getModelObjectSelectionChangedListener() {
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    XsdTextEditorPage.this.setSelection(selectionChangedEvent.getSelection());
                }
            };
        }
        return this.selectionChangedListener;
    }

    public ISelectionProvider getModelObjectSelectionProvider() {
        return this;
    }

    public INotifyChangedListener getNotifyChangedListener() {
        return this.notifyChangedListener;
    }

    public ModelEditorPageOutline getOutlineContribution() {
        return null;
    }

    public void openContext(Object input) {
    }

    public void openContext(Object input, boolean forceRefresh) {
    }

    public void initializeEditorPage() {
    }

    public void setLabelProvider(ILabelProvider provider) {
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.handleStructuredModelChange(false);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof IFileEditorInput) {
            try {
                IFile xsdFile = ((IFileEditorInput)input).getFile();
                if (xsdFile == null) {
                    String msg = ModelerXsdUiConstants.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_2", (Object)input.getName());
                    throw new PartInitException(msg);
                }
                String xsdLocation = xsdFile.getLocation().toString();
                URI xsdUri = URI.createFileURI((String)xsdLocation);
                this.xsdResource = ModelerCore.getModelContainer().getResource(xsdUri, true);
                if (this.xsdResource == null) {
                    String msg = ModelerXsdUiConstants.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_1", (Object)input.getName());
                    throw new PartInitException(msg);
                }
                this.initDocument();
                ModelUtilities.addNotifyChangedListener((INotifyChangedListener)this.notifyChangedListener);
            }
            catch (ModelWorkspaceException e) {
                String msg = ModelerXsdUiConstants.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_2", (Object)input.getName());
                throw new PartInitException(msg, (Throwable)e);
            }
            catch (CoreException e) {
                String msg = ModelerXsdUiConstants.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_2", (Object)input.getName());
                throw new PartInitException(msg, (Throwable)e);
            }
        } else {
            throw new PartInitException(ModelerXsdUiConstants.Util.getString("XsdEditor.Invalid_Input__Must_be_IFileEditorInput._33", new Object[0]));
        }
    }

    public String getTitle() {
        return NAME;
    }

    public String getTitleToolTip() {
        return TOOLTIP;
    }

    public void setTitleText(String title) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null && !this.selectionChangedListeners.contains(listener)) {
            this.selectionChangedListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        EObject selectedObject;
        if (SelectionUtilities.isSingleSelection((ISelection)selection) && SelectionUtilities.isAllEObjects((ISelection)selection) && this.xsdResource.equals((selectedObject = SelectionUtilities.getSelectedEObject((ISelection)selection)).eResource())) {
            this.editorSelection = selection;
            this.handleContentOutlineSelectionForTextEditor(selection, true);
        }
    }

    void setSelectionInternal(ISelection selection) {
        this.editorSelection = selection;
        Iterator iter = this.selectionChangedListeners.iterator();
        while (iter.hasNext()) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            ((ISelectionChangedListener)iter.next()).selectionChanged(event);
        }
    }

    public void dispose() {
        this.cancelRunningTimer();
        if (this.document != null) {
            this.document.removeDocumentListener((IDocumentListener)this);
        }
        ModelUtilities.removeNotifyChangedListener((INotifyChangedListener)this.notifyChangedListener);
        this.notifyChangedListener = null;
        if (this.getSite() != null) {
            super.dispose();
        }
    }

    public void preDispose() {
        ModelUtilities.removeNotifyChangedListener((INotifyChangedListener)this.notifyChangedListener);
        if (this.document != null) {
            this.document.removeDocumentListener((IDocumentListener)this);
        }
        this.notifyChangedListener = null;
        this.cancelRunningTimer();
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private boolean cancelRunningTimer() {
        if (!this.timerCancelled) {
            this.timerCancelled = true;
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
            return true;
        }
        return false;
    }

    public void updateReadOnlyState(boolean isReadOnly) {
    }

    public boolean isDirty() {
        return false;
    }

    public void processEvent(EventObject obj) {
        IFile currentFile;
        ModelResourceEvent event;
        IResource file;
        if (this.getEditorInput() != null && (file = (event = (ModelResourceEvent)obj).getResource()).equals((Object)(currentFile = ((FileEditorInput)this.getEditorInput()).getFile())) && (event.getType() == 6 || event.getType() == 4)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    XsdTextEditorPage.this.setInput(XsdTextEditorPage.this.getEditorInput());
                    XsdTextEditorPage.this.handleStructuredModelChange(true);
                }
            });
        }
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    public void documentChanged(DocumentEvent documentEvent) {
        try {
            this.cancelRunningTimer();
            if (this.handledStructuredModelChange) {
                this.handledStructuredModelChange = false;
                this.handleDiagnostics(null);
            } else {
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        XsdTextEditorPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                XsdTextEditorPage.this.handleDocumentChange(true);
                            }
                        });
                    }
                };
                this.timerCancelled = false;
                this.timer.schedule(this.timerTask, 1000L);
            }
        }
        catch (Exception exception) {
            ModelerXsdUiConstants.Util.log((Throwable)exception);
        }
    }

    public void openComplete() {
    }

    public boolean isSelectedFirst(IEditorInput input) {
        return false;
    }
}

