/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.wizards;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.PluginUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.RelationalObjectBuilder;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;
import org.teiid.designer.xsd.ui.ModelerXsdUiPlugin;
import org.teiid.designer.xsd.ui.wizards.GenerateVirtualFromXsdHelper;
import org.teiid.designer.xsd.ui.wizards.GlobalEntitiesPage;

public class CreateVirtualModelFromSchemaWizard
extends AbstractWizard {
    public static boolean HEADLESS = false;
    private static final String TITLE = ModelerXsdUiConstants.Util.getString("CreateVirtualModelFromSchemaWizard.title", new Object[0]);
    private final PluginUtil Util = ModelerXsdUiConstants.Util;
    protected GlobalEntitiesPage complexSchemaTypesPage;
    private MultiStatus status;
    protected ISelection selection;
    private IWizardPage[] wizardPageArray;
    private Resource selectedResource;
    public ModelResource selectedModelResource;

    public CreateVirtualModelFromSchemaWizard() {
        super((AbstractUIPlugin)ModelerXsdUiPlugin.getDefault(), TITLE, null);
        this.setNeedsProgressMonitor(false);
    }

    public void addPages() {
        this.complexSchemaTypesPage = new GlobalEntitiesPage(this.selectedResource);
        this.addPage((IWizardPage)this.complexSchemaTypesPage);
    }

    public boolean finish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CreateVirtualModelFromSchemaWizard.this.doFinish(monitor);
            }
        };
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)this.getWindowTitle(), (Object)((Object)this));
        try {
            try {
                new ProgressMonitorDialog(this.getShell()).run(false, false, op);
            }
            catch (Throwable err) {
                this.Util.log(4, err, err.getMessage());
                if (startedTxn) {
                    ModelerCore.commitTxn();
                }
            }
        }
        finally {
            if (startedTxn) {
                ModelerCore.commitTxn();
            }
        }
        return true;
    }

    public void doFinish(IProgressMonitor monitor) {
        ModelResource newModel;
        if (this.complexSchemaTypesPage == null) {
            String msg = this.Util.getString("CreateVirtualModelFromSchemaWizard.noInit", new Object[0]);
            this.addStatus(4, msg, null);
            return;
        }
        IPath modelPath = this.complexSchemaTypesPage.getFilePath();
        IProject targetProject = this.complexSchemaTypesPage.getTargetProject();
        Collection typesList = this.complexSchemaTypesPage.getTypesToConvert();
        if (modelPath != null && targetProject != null && targetProject.exists() && !typesList.isEmpty() && (newModel = this.constructVirtualModel(targetProject, modelPath)) != null) {
            try {
                GenerateVirtualFromXsdHelper helper = new GenerateVirtualFromXsdHelper(this.getStatus(), newModel.getEmfResource(), typesList);
                helper.doBuild(monitor);
                ModelUtilities.saveModelResource((ModelResource)newModel, (IProgressMonitor)monitor, (boolean)true, (Object)((Object)this));
                ModelEditorManager.activate((ModelResource)newModel, (boolean)true);
            }
            catch (Exception err) {
                this.addStatus(4, err.getMessage(), err);
            }
        }
    }

    public MultiStatus getStatus() {
        if (this.status == null) {
            this.status = new MultiStatus("org.teiid.designer.xsd.ui", 0, this.Util.getString("CreateVirtualModelFromSchemaWizard.status", new Object[0]), null);
        }
        return this.status;
    }

    private void addStatus(int severity, String message, Throwable ex) {
        Status sts = new Status(severity, "org.teiid.designer.xsd.ui", 0, message, ex);
        this.getStatus().add((IStatus)sts);
    }

    private ModelResource constructVirtualModel(IProject targetProject, IPath modelPath) {
        IPath relativeModelPath = modelPath.removeFirstSegments(1);
        IFile modelFile = targetProject.getFile(relativeModelPath);
        ModelResource resrc = ModelerCore.create((IFile)modelFile);
        try {
            RelationalObjectBuilder builder = new RelationalObjectBuilder(resrc.getEmfResource());
            resrc.getModelAnnotation().setPrimaryMetamodelUri(builder.getRelationalPackageURI());
            resrc.getModelAnnotation().setModelType(ModelType.VIRTUAL_LITERAL);
            resrc.save(null, true);
        }
        catch (ModelWorkspaceException mwe) {
            this.addStatus(4, mwe.getMessage(), mwe);
        }
        return resrc;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        if (SelectionUtilities.isSingleSelection((ISelection)selection)) {
            Object sel = SelectionUtilities.getSelectedObject((ISelection)selection);
            if (sel instanceof IFile) {
                ModelResource modelResource;
                this.selectedModelResource = modelResource = ModelerCore.getModelWorkspace().findModelResource((IResource)((IFile)sel));
                try {
                    this.selectedResource = modelResource.getEmfResource();
                }
                catch (ModelWorkspaceException err) {
                    this.Util.log((Throwable)err);
                }
            } else if (sel instanceof Resource) {
                this.selectedResource = (Resource)sel;
            }
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.complexSchemaTypesPage) {
            return null;
        }
        int i = 0;
        while (i < this.wizardPageArray.length) {
            if (this.wizardPageArray[i] == page && i + 1 < this.wizardPageArray.length) {
                return this.wizardPageArray[i + 1];
            }
            ++i;
        }
        return null;
    }

    public boolean canFinish() {
        boolean result = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.complexSchemaTypesPage) {
            result = currentPage.isPageComplete();
        } else {
            boolean lastPage = currentPage == this.wizardPageArray[this.wizardPageArray.length - 1];
            result = lastPage && currentPage.isPageComplete();
        }
        return result;
    }

    public int getPageCount() {
        if (this.wizardPageArray != null) {
            return this.wizardPageArray.length + 1;
        }
        return 1;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.wizardPageArray == null || page == this.complexSchemaTypesPage) {
            return null;
        }
        if (page == this.wizardPageArray[0]) {
            return this.complexSchemaTypesPage;
        }
        int i = 1;
        while (i < this.wizardPageArray.length) {
            if (page == this.wizardPageArray[i]) {
                return this.wizardPageArray[i - 1];
            }
            ++i;
        }
        return null;
    }
}

