/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.widget.accumulator.AccumulatorPanel;
import org.teiid.designer.ui.common.widget.accumulator.IAccumulatedValuesChangeListener;
import org.teiid.designer.ui.common.widget.accumulator.IAccumulatorSource;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;

public class GlobalEntitiesPage
extends WizardPage
implements InternalUiConstants.Widgets,
IAccumulatedValuesChangeListener {
    private static final String TITLE = ModelerXsdUiConstants.Util.getString("ComplexSchemaTypesPage.title", new Object[0]);
    private static final String DESCRIPTION = ModelerXsdUiConstants.Util.getString("ComplexSchemaTypesPage.description", new Object[0]);
    private static final int STATUS_OK = 0;
    private static final int STATUS_NO_LOCATION = 1;
    private static final int STATUS_NO_FILENAME = 2;
    private static final int STATUS_BAD_FILENAME = 4;
    private static final int STATUS_CLOSED_PROJECT = 5;
    private static final int STATUS_NO_PROJECT_NATURE = 6;
    private final String leftHeader = ModelerXsdUiConstants.Util.getString("ComplexSchemaTypesPage.leftHeader", new Object[0]);
    private final String rightHeader = ModelerXsdUiConstants.Util.getString("ComplexSchemaTypesPage.rightHeader", new Object[0]);
    private final Collection globalElements = new HashSet();
    private final Collection globalTypes = new HashSet();
    private final ILabelProvider accumulatorLabelProvider = ModelUtilities.getEMFLabelProvider();
    Text containerText;
    Resource xsdRsrc;
    Text fileText;
    protected int currentStatus = 0;
    private String fileNameMessage = null;
    private String fileExtension = ".xmi";
    private TableViewer typeViewer;
    private AccumulatorPanel panel;
    private Collection typesToCreate;
    private IProject project;

    public GlobalEntitiesPage(Resource rsrc) {
        super("complexTypesPage");
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.initialize(rsrc);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Composite topComposite = new Composite(container, 0);
        GridData topCompositeGridData = new GridData(768);
        topComposite.setLayoutData((Object)topCompositeGridData);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        topComposite.setLayout((Layout)topLayout);
        GridData gd = null;
        Label locationLabel = new Label(topComposite, 0);
        locationLabel.setText(UiConstants.Util.getString("NewModelWizard.location", new Object[0]));
        this.containerText = new Text(topComposite, 2052);
        gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GlobalEntitiesPage.this.checkStatus();
            }
        });
        this.containerText.setEditable(false);
        Button browseButton = new Button(topComposite, 8);
        GridData buttonGridData = new GridData();
        browseButton.setLayoutData((Object)buttonGridData);
        browseButton.setText(UiConstants.Util.getString("NewModelWizard.browse", new Object[0]));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalEntitiesPage.this.handleBrowse();
            }
        });
        Label fileLabel = new Label(topComposite, 0);
        fileLabel.setText(UiConstants.Util.getString("NewModelWizard.fileName", new Object[0]));
        this.fileText = new Text(topComposite, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GlobalEntitiesPage.this.checkStatus();
            }
        });
        Composite bottomComposite = new Composite(container, 0);
        GridData bottomCompositeGridData = new GridData(1808);
        bottomComposite.setLayoutData((Object)bottomCompositeGridData);
        GridLayout bottomLayout = new GridLayout();
        bottomLayout.numColumns = 2;
        bottomComposite.setLayout((Layout)bottomLayout);
        GlobalEntitiesAccumulatorSource source = new GlobalEntitiesAccumulatorSource(this, bottomComposite);
        this.panel = new AccumulatorPanel(bottomComposite, (IAccumulatorSource)source, new ArrayList(), this.accumulatorLabelProvider, this.leftHeader, this.rightHeader);
        this.panel.addAccumulatedValuesChangeListener((IAccumulatedValuesChangeListener)this);
        this.setControl((Control)container);
        this.typeViewer.add(this.globalElements.toArray());
        this.typeViewer.add(this.globalTypes.toArray());
        this.setDefaults();
        this.checkStatus();
    }

    public void accumulatedValuesChanged(AccumulatorPanel source) {
        this.typesToCreate = source.getItemsMovedToSelected();
        this.checkStatus();
    }

    public Collection getTypesToConvert() {
        if (this.typesToCreate == null) {
            return Collections.EMPTY_LIST;
        }
        return this.typesToCreate;
    }

    private void initialize(Resource rsrc) {
        if (rsrc != null) {
            this.addComplexTypes(rsrc);
            this.xsdRsrc = rsrc;
        }
    }

    private void setDefaults() {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GlobalEntitiesPage.this.xsdRsrc == null) {
                    return;
                }
                ModelResource xsdMR = ModelerCore.getModelEditor().findModelResource(GlobalEntitiesPage.this.xsdRsrc);
                if (xsdMR != null) {
                    IContainer parentContainer = (IContainer)xsdMR.getParent().getResource();
                    if (parentContainer != null && parentContainer.getProject() != null) {
                        GlobalEntitiesPage.this.project = parentContainer.getProject();
                        GlobalEntitiesPage.this.containerText.setText(String.valueOf(GlobalEntitiesPage.this.project.getName()) + File.separator + parentContainer.getProjectRelativePath().toString());
                    }
                    GlobalEntitiesPage.this.fileText.setText(xsdMR.getPath().removeFileExtension().lastSegment());
                }
            }
        });
    }

    private void addComplexTypes(Resource xsdRsrc) {
        for (Object next : xsdRsrc.getContents()) {
            if (!(next instanceof XSDSchema)) continue;
            XSDSchema schema = (XSDSchema)next;
            for (Object child : schema.eContents()) {
                if (child instanceof XSDComplexTypeDefinition) {
                    this.globalTypes.add(child);
                    continue;
                }
                if (!(child instanceof XSDElementDeclaration)) continue;
                this.globalElements.add(child);
            }
        }
    }

    void checkStatus() {
        String container = this.getContainerName();
        if (CoreStringUtil.isEmpty((String)container)) {
            this.setMessage("No Model Location Selected", 3);
            this.currentStatus = 1;
            this.setPageComplete(false);
            return;
        }
        IProject project = this.getTargetProject();
        if (project == null) {
            this.currentStatus = 1;
            return;
        }
        if (!project.isOpen()) {
            this.currentStatus = 5;
            return;
        }
        try {
            if (project.getNature("org.teiid.designer.core.modelNature") == null) {
                this.currentStatus = 6;
                return;
            }
        }
        catch (CoreException coreException) {
            this.currentStatus = 6;
            return;
        }
        String fileText = this.getFileText();
        if (fileText.length() == 0) {
            this.currentStatus = 2;
            this.setMessage("No File Name Provided", 3);
            return;
        }
        IStatus status = ModelNameUtil.validate((String)fileText, (String)this.fileExtension, (IContainer)project, (int)7);
        if (status.getSeverity() == 4) {
            this.fileNameMessage = String.valueOf(ModelNameUtil.MESSAGES.INVALID_MODEL_NAME) + status.getMessage();
            this.currentStatus = 4;
            this.setMessage(this.fileNameMessage, 3);
            return;
        }
        if (this.globalElements.isEmpty() && this.globalTypes.isEmpty()) {
            this.setMessage(ModelerXsdUiConstants.Util.getString("ComplexSchemaTypesPage.none", new Object[0]), 3);
            this.setPageComplete(false);
            return;
        }
        if (this.typesToCreate == null || this.typesToCreate.isEmpty()) {
            this.setMessage(ModelerXsdUiConstants.Util.getString("ComplexSchemaTypesPage.noneSelected", new Object[0]), 3);
            this.setPageComplete(false);
            return;
        }
        this.setMessage(ModelerXsdUiConstants.Util.getString("ComplexSchemaTypesPage.done", new Object[0]), 0);
        this.setPageComplete(true);
    }

    void typesToConvertChanged() {
    }

    void typesToConvertRemoved(Collection values) {
        for (Object value : values) {
            this.typeViewer.add(value);
        }
    }

    void typesToConvertAdded(Collection values) {
        for (Object value : values) {
            this.typeViewer.remove(value);
        }
    }

    Collection getAvailableTypes() {
        int count = this.typeViewer.getTable().getItemCount();
        ArrayList<Object> values = new ArrayList<Object>(count);
        int i = 0;
        while (i < count) {
            Object value = this.typeViewer.getElementAt(i);
            values.add(value);
            ++i;
        }
        return values;
    }

    int getAvailableTypesCount() {
        return this.typeViewer.getTable().getItemCount();
    }

    Collection getSelectedAvailableTypes() {
        int[] selectionIndices = this.typeViewer.getTable().getSelectionIndices();
        ArrayList<Object> selectedValues = new ArrayList<Object>(selectionIndices.length);
        int i = 0;
        while (i < selectionIndices.length) {
            int index = selectionIndices[i];
            selectedValues.add(this.typeViewer.getElementAt(index));
            ++i;
        }
        return selectedValues;
    }

    int getSelectedAvailableTypeCount() {
        if (this.typeViewer != null) {
            return this.typeViewer.getTable().getSelectionCount();
        }
        return 0;
    }

    Control createTypeControl(Composite parent) {
        this.typeViewer = new TableViewer(parent, 2);
        this.typeViewer.setLabelProvider((IBaseLabelProvider)this.accumulatorLabelProvider);
        return this.typeViewer.getControl();
    }

    void addTypeSelectionListener(SelectionListener listener) {
        this.typeViewer.getTable().addSelectionListener(listener);
    }

    void handleBrowse() {
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)((IContainer)this.getTargetContainer()), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.containerText != null) {
            this.containerText.setText(folder.getFullPath().makeRelative().toString());
        }
        this.checkStatus();
    }

    public IProject getTargetProject() {
        IWorkspaceRoot root;
        IResource resource;
        IProject result = null;
        String containerName = this.getContainerName();
        if (!CoreStringUtil.isEmpty((String)containerName) && (resource = (root = ModelerCore.getWorkspace().getRoot()).findMember((IPath)new Path(containerName))).exists()) {
            result = resource.getProject();
        }
        return result;
    }

    public IResource getTargetContainer() {
        IWorkspaceRoot root;
        IResource resource;
        IResource result = null;
        String containerName = this.getContainerName();
        if (!CoreStringUtil.isEmpty((String)containerName) && (resource = (root = ModelerCore.getWorkspace().getRoot()).findMember((IPath)new Path(containerName))).exists()) {
            result = resource;
        }
        return result;
    }

    public String getContainerName() {
        String result = null;
        result = this.containerText.getText().trim();
        return result;
    }

    public String getFileName() {
        String result = this.fileText.getText().trim();
        if (!result.endsWith(this.fileExtension)) {
            result = String.valueOf(result) + this.fileExtension;
        }
        return result;
    }

    public String getFileText() {
        return this.fileText.getText().trim();
    }

    public IPath getFilePath() {
        return this.getTargetProject().getFullPath().append(String.valueOf(this.getFileText()) + ".xmi");
    }

    class GlobalEntitiesAccumulatorSource
    implements IAccumulatorSource {
        private final IStatus OK_STATUS = new StatusInfo("org.teiid.designer.xsd.ui");
        private final GlobalEntitiesPage caller;
        TableViewer viewer;

        public GlobalEntitiesAccumulatorSource(GlobalEntitiesPage cllr, Composite parent) {
            this.caller = cllr;
        }

        public void accumulatedValuesRemoved(Collection values) {
            this.caller.typesToConvertRemoved(values);
            this.caller.typesToConvertChanged();
        }

        public void accumulatedValuesAdded(Collection values) {
            this.caller.typesToConvertAdded(values);
            this.caller.typesToConvertChanged();
        }

        public Collection getAvailableValues() {
            return this.caller.getAvailableTypes();
        }

        public int getAvailableValuesCount() {
            return this.caller.getAvailableTypesCount();
        }

        public Collection getSelectedAvailableValues() {
            return this.caller.getSelectedAvailableTypes();
        }

        public int getSelectedAvailableValuesCount() {
            return this.caller.getSelectedAvailableTypeCount();
        }

        public Control createControl(Composite parent) {
            return this.caller.createTypeControl(parent);
        }

        public void addSelectionListener(SelectionListener listener) {
            this.caller.addTypeSelectionListener(listener);
        }

        public boolean supportsAddAll() {
            return true;
        }

        public IStatus getSelectionStatus() {
            return this.OK_STATUS;
        }
    }
}

