/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.designer.common.xsd.XsdHeader;
import org.teiid.designer.common.xsd.XsdHeaderReader;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.URLHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.ui.common.viewsupport.JobUtils;
import org.teiid.designer.ui.common.widget.ListMessageDialog;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;

public class XsdFileSystemImportUtil {
    private static final String I18N_PREFIX = "XsdFileSystemImportUtil";
    private static final String SEPARATOR = ".";
    private static final String FILE_SEPARATOR = File.separator;

    public static boolean importXsds(List xsdFiles, boolean addDependentXsds, IPath destinationFullPath, IWizardContainer container, IOverwriteQuery overwriteQuery, boolean createContainerStructure, boolean overwriteExistingResources) {
        return XsdFileSystemImportUtil.importXsds(xsdFiles, addDependentXsds, destinationFullPath, container, overwriteQuery, createContainerStructure, overwriteExistingResources, Collections.EMPTY_MAP);
    }

    public static boolean importXsds(List xsdFiles, boolean addDependentXsds, IPath destinationFullPath, IWizardContainer container, IOverwriteQuery overwriteQuery, boolean createContainerStructure, boolean overwriteExistingResources, Map fileToUserInfo) {
        Shell shell = container.getShell();
        if (xsdFiles.size() > 0) {
            if (addDependentXsds) {
                HashMap depFilesImportToPaths = new HashMap();
                ArrayList depFiles = new ArrayList(XsdFileSystemImportUtil.getDependentXsdFiles(xsdFiles, depFilesImportToPaths, fileToUserInfo));
                boolean OK_TO_CONTINUE = false;
                OK_TO_CONTINUE = depFiles.isEmpty() ? true : ListMessageDialog.openQuestion((Shell)shell, (String)XsdFileSystemImportUtil.getString("addingDependentXsds.title"), null, (String)XsdFileSystemImportUtil.getString("addingDependentXsds.message"), new ArrayList(depFilesImportToPaths.keySet()), null);
                if (OK_TO_CONTINUE) {
                    ArrayList allFiles = new ArrayList(xsdFiles.size() + depFiles.size());
                    allFiles.addAll(xsdFiles);
                    allFiles.addAll(depFiles);
                    File topLevelSourceDirectory = XsdFileSystemImportUtil.getTopLevelCommonFolder(allFiles);
                    XsdFileSystemImportUtil.addMissingFoldersToFileList(topLevelSourceDirectory, allFiles);
                    return XsdFileSystemImportUtil.importResources(allFiles, container, overwriteQuery, topLevelSourceDirectory, destinationFullPath, depFilesImportToPaths, createContainerStructure, overwriteExistingResources);
                }
                return false;
            }
            File topLevelSourceDirectory = XsdFileSystemImportUtil.getTopLevelCommonFolder(xsdFiles);
            return XsdFileSystemImportUtil.importResources(xsdFiles, container, overwriteQuery, topLevelSourceDirectory, destinationFullPath, null, createContainerStructure, overwriteExistingResources);
        }
        MessageDialog.openInformation((Shell)shell, (String)DataTransferMessages.DataTransfer_information, (String)DataTransferMessages.FileImport_noneSelected);
        return false;
    }

    private static Collection getDependentXsdFiles(Collection selectedFiles, Map depFilesImportToPaths, Map fileToUserInfo) {
        ArrayList modifiableList = new ArrayList();
        Iterator iter = selectedFiles.iterator();
        while (iter.hasNext()) {
            XsdFileSystemImportUtil.addDependentXsdFiles((File)iter.next(), modifiableList, selectedFiles, depFilesImportToPaths, fileToUserInfo);
        }
        return modifiableList;
    }

    private static void addDependentXsdFiles(File xsdFile, Collection modifiableList, Collection originalList, Map depFilesImportToPaths, Map fileToUserInfo) {
        XsdHeader header = null;
        try {
            header = XsdHeaderReader.readHeader((File)xsdFile);
        }
        catch (TeiidDesignerException theException) {
            ModelerXsdUiConstants.Util.log((Throwable)theException);
        }
        if (header != null) {
            String[] locations = header.getImportSchemaLocations();
            XsdFileSystemImportUtil.addDepFilesForLocations(locations, xsdFile, modifiableList, originalList, depFilesImportToPaths, fileToUserInfo);
            locations = header.getIncludeSchemaLocations();
            XsdFileSystemImportUtil.addDepFilesForLocations(locations, xsdFile, modifiableList, originalList, depFilesImportToPaths, fileToUserInfo);
        }
    }

    private static void addDepFilesForLocations(String[] locations, File xsdFile, Collection modifiableList, Collection originalList, Map depFilesImportToPaths, Map fileToUserInfo) {
        int i = 0;
        while (i != locations.length) {
            String location = locations[i];
            String absolutePath = XsdFileSystemImportUtil.getAbsolutePath(xsdFile, location);
            File f = new File(absolutePath);
            if (f.exists() && !XsdFileSystemImportUtil.listContainsFileByPath(modifiableList, f) && !XsdFileSystemImportUtil.listContainsFileByPath(originalList, f)) {
                modifiableList.add(f);
                depFilesImportToPaths.put(location, absolutePath);
                XsdFileSystemImportUtil.addDependentXsdFiles(f, modifiableList, originalList, depFilesImportToPaths, fileToUserInfo);
            } else {
                try {
                    URL url = new URL(absolutePath);
                    String filePath = url.getPath();
                    if (filePath.startsWith("/")) {
                        filePath = filePath.substring(1);
                    }
                    String userName = null;
                    String password = null;
                    boolean verifyHostname = true;
                    Object[] userInfo = (Object[])fileToUserInfo.get(xsdFile);
                    if (userInfo != null) {
                        userName = (String)userInfo[0];
                        password = (String)userInfo[1];
                        verifyHostname = (Boolean)userInfo[2];
                    }
                    f = URLHelper.createFileFromUrl((URL)url, (String)filePath, (String)userName, password, (boolean)verifyHostname);
                    modifiableList.add(f);
                    depFilesImportToPaths.put(location, f.getAbsolutePath());
                    XsdFileSystemImportUtil.addDependentXsdFiles(f, modifiableList, originalList, depFilesImportToPaths, fileToUserInfo);
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException ioe) {
                    ModelerXsdUiConstants.Util.log((Throwable)ioe);
                }
            }
            ++i;
        }
    }

    private static File getTopLevelCommonFolder(Collection allFiles) {
        String nextSegment = null;
        File nextFile2 = null;
        int minSegCount = 99;
        ArrayList<Object[]> segmentsList = new ArrayList<Object[]>();
        int minPathId = 0;
        for (File nextFile2 : allFiles) {
            ArrayList<String> segments = new ArrayList<String>();
            StringTokenizer textIter = new StringTokenizer(nextFile2.getAbsolutePath(), FILE_SEPARATOR);
            while (textIter.hasMoreTokens()) {
                nextSegment = textIter.nextToken().trim();
                segments.add(nextSegment);
            }
            segmentsList.add(segments.toArray());
            if (segments.size() >= minSegCount) continue;
            minSegCount = segments.size();
            minPathId = segmentsList.size() - 1;
        }
        Object[] segmentsArray = segmentsList.toArray();
        Object[] pathArray = null;
        Object[] minPathArray = (Object[])segmentsArray[minPathId];
        int j = 0;
        while (j < minSegCount) {
            String baseSeg = (String)minPathArray[j];
            String compareSeg = null;
            int i = 1;
            while (i < segmentsArray.length) {
                pathArray = (Object[])segmentsArray[i];
                compareSeg = (String)pathArray[j];
                if (!baseSeg.equalsIgnoreCase(compareSeg)) {
                    String topLevelFolder = null;
                    int k = 0;
                    while (k < j - 1) {
                        topLevelFolder = k == 0 ? minPathArray[k] + FILE_SEPARATOR : String.valueOf(topLevelFolder) + minPathArray[k] + FILE_SEPARATOR;
                        ++k;
                    }
                    topLevelFolder = String.valueOf(topLevelFolder) + minPathArray[j - 1];
                    return new File(topLevelFolder);
                }
                ++i;
            }
            ++j;
        }
        String topLevelFolder = null;
        int k = 0;
        while (k < minPathArray.length - 1) {
            topLevelFolder = k == 0 ? minPathArray[k] + FILE_SEPARATOR : String.valueOf(topLevelFolder) + minPathArray[k] + FILE_SEPARATOR;
            ++k;
        }
        if (minPathArray.length > 2) {
            topLevelFolder = String.valueOf(topLevelFolder) + minPathArray[minPathArray.length - 1];
        }
        return new File(topLevelFolder);
    }

    private static void addMissingFoldersToFileList(File topLevelFolder, Collection allFiles) {
        String nextSegment;
        File nextFile2 = null;
        ArrayList<String> topLevelSegments = new ArrayList<String>();
        StringTokenizer textIter = new StringTokenizer(topLevelFolder.getAbsolutePath(), FILE_SEPARATOR);
        while (textIter.hasMoreTokens()) {
            nextSegment = textIter.nextToken().trim();
            topLevelSegments.add(nextSegment);
        }
        Object[] topSegArray = topLevelSegments.toArray();
        int nBaseSegs = topSegArray.length;
        ArrayList<File> missingFolders = new ArrayList<File>();
        for (File nextFile2 : allFiles) {
            ArrayList<String> segments = new ArrayList<String>();
            StringTokenizer textIter2 = new StringTokenizer(nextFile2.getAbsolutePath(), FILE_SEPARATOR);
            while (textIter2.hasMoreTokens()) {
                nextSegment = textIter2.nextToken().trim();
                segments.add(nextSegment);
            }
            String thisPath = topLevelFolder.getAbsolutePath();
            File existingFolder = null;
            if (segments.size() <= nBaseSegs + 1) continue;
            Object[] thisSegArray = segments.toArray();
            int i = nBaseSegs;
            while (i < thisSegArray.length - 1) {
                thisPath = String.valueOf(thisPath) + FILE_SEPARATOR + thisSegArray[i];
                ++i;
            }
            existingFolder = new File(thisPath);
            if (existingFolder.exists() || XsdFileSystemImportUtil.listContainsFileByPath(missingFolders, existingFolder)) continue;
            missingFolders.add(existingFolder);
        }
        if (!missingFolders.isEmpty()) {
            ArrayList files = new ArrayList(allFiles);
            allFiles.clear();
            allFiles.addAll(missingFolders);
            allFiles.addAll(files);
        }
    }

    private static boolean listContainsFileByPath(Collection files, File file) {
        for (File nextFile : files) {
            if (!nextFile.getAbsolutePath().equals(file.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    private static String getAbsolutePath(File base, String relativePath) {
        URI baseLocation = URI.createFileURI((String)base.getAbsolutePath());
        URI relLocation = URI.createURI((String)relativePath, (boolean)false);
        if (baseLocation.isHierarchical() && !baseLocation.isRelative() && relLocation.isRelative()) {
            relLocation = relLocation.resolve(baseLocation);
        }
        if (relLocation.isFile()) {
            return relLocation.toFileString();
        }
        return URI.decode((String)relLocation.toString());
    }

    public static boolean importResources(List fileSystemObjects, IWizardContainer container, IOverwriteQuery overwriteQuery, File topLevelSourceDirectory, IPath destinationFullPath, Map depFilesImportToPaths, boolean createContainerStructure, boolean overwriteExistingResources) {
        ImportOperation operation = new ImportOperation(destinationFullPath, (Object)topLevelSourceDirectory, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, overwriteQuery, fileSystemObjects);
        operation.setContext(container.getShell());
        boolean autoBuildOn = ModelerCore.getWorkspace().isAutoBuilding();
        if (autoBuildOn) {
            JobUtils.setAutoBuild((boolean)false);
        }
        operation.setCreateContainerStructure(createContainerStructure);
        operation.setOverwriteResources(overwriteExistingResources);
        boolean importResult = XsdFileSystemImportUtil.executeImportOperation(operation, container);
        HashSet<Resource> emfResources = new HashSet<Resource>();
        for (Object nextObj : fileSystemObjects) {
            File targetXSDFile;
            String name;
            if (!(nextObj instanceof File) || ((File)nextObj).isDirectory() || (name = (targetXSDFile = (File)nextObj).getName()).indexOf(".xsd") <= -1) continue;
            Resource[] resources = null;
            try {
                Object content2;
                resources = ModelWorkspaceManager.getModelWorkspaceManager().getModelContainer().getResourceFinder().findByName(name, false, false);
                if (resources == null || resources.length != 1) continue;
                ModelResource mr = ModelUtilities.getModelResource((Resource)resources[0], (boolean)true);
                if (mr != null) {
                    emfResources.add(mr.getEmfResource());
                }
                if (depFilesImportToPaths == null || depFilesImportToPaths.isEmpty() || resources[0].getContents().size() != 1 || !((content2 = resources[0].getContents().get(0)) instanceof XSDSchema)) continue;
                boolean importChanged = false;
                for (Object content2 : ((XSDSchema)content2).getContents()) {
                    Path projectRelativeImportedXsdFilePath;
                    String relativeXsdLocation;
                    if (!(content2 instanceof XSDImport)) continue;
                    XSDImport xsdImport = (XSDImport)content2;
                    String xsdLocation = xsdImport.getSchemaLocation();
                    String absoluteImportLocation = (String)depFilesImportToPaths.get(xsdLocation);
                    String topLevelDirectoryPath = topLevelSourceDirectory.getPath();
                    if (!Platform.getOS().equals("win32") && topLevelDirectoryPath.charAt(0) != '/') {
                        topLevelDirectoryPath = String.valueOf('/') + topLevelDirectoryPath;
                    }
                    Path projectRelativeBaseXSDFilePath = new Path(targetXSDFile.getPath().substring(topLevelDirectoryPath.length() + 1));
                    if (absoluteImportLocation == null || xsdLocation.equals(relativeXsdLocation = ModelUtil.getRelativePath((IPath)(projectRelativeImportedXsdFilePath = new Path(absoluteImportLocation.substring(topLevelDirectoryPath.length() + 1))), (IPath)projectRelativeBaseXSDFilePath))) continue;
                    xsdImport.setSchemaLocation(relativeXsdLocation);
                    importChanged = true;
                }
                if (!importChanged) continue;
                mr.save(null, false);
            }
            catch (CoreException coreException) {}
        }
        Iterator iter = emfResources.iterator();
        while (iter.hasNext()) {
            ((Resource)iter.next()).setModified(false);
        }
        if (autoBuildOn) {
            JobUtils.setAutoBuild((boolean)true);
        }
        return importResult;
    }

    private static boolean executeImportOperation(ImportOperation op, IWizardContainer container) {
        try {
            container.run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException();
            String message = exception.getMessage();
            if (message == null) {
                message = NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_exceptionMessage, (Object)exception);
            }
            MessageDialog.openError((Shell)container.getShell(), (String)IDEWorkbenchMessages.WizardExportPage_internalErrorTitle, (String)message);
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)container.getShell(), (String)DataTransferMessages.FileImport_importProblems, null, (IStatus)status);
            return false;
        }
        return true;
    }

    private static String getString(String id) {
        return ModelerXsdUiConstants.Util.getString("XsdFileSystemImportUtil." + id, new Object[0]);
    }
}

