/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.teiid.designer.core.util.URLHelper;
import org.teiid.designer.ui.IHelpContextIds;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.designer.ui.common.widget.MessageLabel;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;

public class XsdUrlDialog
extends Dialog
implements IHelpContextIds,
ModelerXsdUiConstants {
    private static final String I18N_PREFIX = "XsdUrlDialog";
    private static final String SEPARATOR = ".";
    private Button btnOk;
    private IStatus currentStatus;
    private MessageLabel lblMsg;
    private String newValue;
    private String oldValue;
    private URL urlObject;
    private String userName;
    private String password;
    private boolean verifyHostname = true;
    private Text pwdText;
    private Text userText;
    private Button verifyHostnameCheckbox;

    private static String getString(String id) {
        return ModelerXsdUiConstants.Util.getString("XsdUrlDialog." + id, new Object[0]);
    }

    public XsdUrlDialog(Shell theParent) {
        super(theParent, XsdUrlDialog.getString("title"));
        this.setReturnCode(1);
        this.setSizeRelativeToScreen(55, 36);
        this.setCenterOnDisplay(true);
    }

    protected Button createButton(Composite theParent, int theId, String theLabel, boolean theDefaultButton) {
        Button btn = super.createButton(theParent, theId, theLabel, theDefaultButton);
        if (theId == 0) {
            this.btnOk = btn;
            this.updateButtonStatus();
        }
        this.btnOk.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent theEvent) {
            }

            public void widgetDefaultSelected(SelectionEvent theEvent) {
                XsdUrlDialog.this.okPressed();
            }
        });
        return btn;
    }

    protected void okPressed() {
        this.currentStatus = new Status(1, "org.teiid.designer.xsd.ui", 0, XsdUrlDialog.getString("0"), null);
        this.updateMessage();
        boolean resolved = true;
        try {
            this.userName = this.userText.getText();
            this.password = this.pwdText.getText();
            resolved = URLHelper.resolveUrl((URL)this.urlObject, (String)this.getUserName(), (String)this.getPassword(), null, (boolean)this.verifyHostname);
        }
        catch (Exception e) {
            resolved = false;
            ModelerXsdUiConstants.Util.log((Throwable)e);
            this.currentStatus = new Status(4, "org.teiid.designer.xsd.ui", 0, XsdUrlDialog.getString("2"), null);
        }
        this.updateMessage();
        if (resolved) {
            super.okPressed();
        }
    }

    protected Control createDialogArea(Composite theParent) {
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        pnlMain.setLayout((Layout)layout);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        pnlMain.setLayoutData((Object)new GridData(1808));
        this.createXsdUrlPanel(pnlMain);
        this.createUserPasswordPanel(pnlMain);
        return pnlMain;
    }

    private void createXsdUrlPanel(Composite theParent) {
        Composite panel = new Composite(theParent, 0);
        GridLayout layout = new GridLayout(2, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        WidgetFactory.createLabel((Composite)panel, (String)XsdUrlDialog.getString("label.text"), (int)128);
        Text txf = new Text(panel, 2048);
        txf.setLayoutData((Object)new GridData(768));
        txf.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                XsdUrlDialog.this.handleModifyText(theEvent);
            }
        });
        this.lblMsg = new MessageLabel(panel);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.lblMsg.setLayoutData((Object)gd);
        txf.setText(this.oldValue == null ? "" : this.oldValue);
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)panel, "org.teiid.designer.ui.namespaceUriRenameDialog");
    }

    private void createUserPasswordPanel(Composite theParent) {
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        pnl.setLayout((Layout)layout);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        pnl.setLayoutData((Object)new GridData(1808));
        Group optionsGroup = new Group(pnl, 0);
        layout = new GridLayout(2, false);
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(1808));
        optionsGroup.setText(XsdUrlDialog.getString("Optional"));
        WidgetFactory.createLabel((Composite)optionsGroup, (String)XsdUrlDialog.getString("label.user"));
        this.userText = WidgetFactory.createTextField((Composite)optionsGroup, (int)768);
        this.userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                XsdUrlDialog.this.userModified();
            }
        });
        WidgetFactory.createLabel((Composite)optionsGroup, (String)XsdUrlDialog.getString("label.password"));
        this.pwdText = WidgetFactory.createTextField((Composite)optionsGroup, (int)768);
        this.pwdText.setEchoChar('*');
        this.pwdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                XsdUrlDialog.this.passwordModified();
            }
        });
        this.verifyHostnameCheckbox = new Button((Composite)optionsGroup, 32);
        this.verifyHostnameCheckbox.setFont(optionsGroup.getFont());
        this.verifyHostnameCheckbox.setText(XsdUrlDialog.getString("verifyHostname.text"));
        this.verifyHostnameCheckbox.setSelection(true);
        this.verifyHostnameCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XsdUrlDialog.this.verifyHostnameChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public String getUrl() {
        String result = this.oldValue;
        int code = this.getReturnCode();
        if (code == 0 && this.currentStatus != null && this.currentStatus.getSeverity() != 4) {
            result = this.newValue;
        }
        return result;
    }

    public URL getUrlObject() {
        return this.urlObject;
    }

    public String getUserName() {
        if (this.userName == null) {
            return null;
        }
        return this.userName.trim();
    }

    public String getPassword() {
        if (this.password == null) {
            return null;
        }
        return this.password.trim();
    }

    public boolean verifyHostname() {
        return this.verifyHostname;
    }

    public void setUrlObject(URL urlObject) {
        this.urlObject = urlObject;
    }

    void passwordModified() {
        this.password = this.pwdText.getText();
    }

    void userModified() {
        this.userName = this.userText.getText();
    }

    void verifyHostnameChanged() {
        this.verifyHostname = this.verifyHostnameCheckbox.getSelection();
    }

    void handleModifyText(ModifyEvent theEvent) {
        this.newValue = ((Text)theEvent.widget).getText();
        this.currentStatus = new Status(0, "org.teiid.designer.xsd.ui", 0, "", null);
        URL url = null;
        try {
            url = URLHelper.buildURL((String)this.newValue);
            this.setUrlObject(url);
        }
        catch (MalformedURLException e) {
            this.currentStatus = new Status(4, "org.teiid.designer.xsd.ui", 0, XsdUrlDialog.getString("1"), (Throwable)e);
        }
        this.updateMessage();
        this.updateButtonStatus();
    }

    private void updateMessage() {
        this.lblMsg.setErrorStatus(this.currentStatus);
        this.lblMsg.pack(true);
        this.lblMsg.update();
    }

    private void updateButtonStatus() {
        if (this.btnOk != null) {
            this.btnOk.setEnabled(this.currentStatus != null && this.currentStatus.getSeverity() != 4);
        }
    }
}

