/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.wizards;

import java.io.File;
import java.net.Authenticator;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.URLHelper;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;
import org.teiid.designer.xsd.ui.wizards.XsdFileSystemImportUtil;
import org.teiid.designer.xsd.ui.wizards.XsdUrlDialog;

public class XsdUrlImportMainPage
extends AbstractWizardPage
implements IOverwriteQuery {
    private static final String I18N_PREFIX = "XsdUrlImportMainPage";
    private static final String SEPARATOR = ".";
    private TableViewer viewer;
    Map urlToUserInfo = new HashMap();
    private IAction addUrlAction;
    private IAction removeUrlAction;
    private Button addDependentXsdsCheckbox;
    private Button overwriteExistingResourcesCheckbox;
    private Text containerNameField;
    private IStructuredSelection defaultSelection;
    private boolean okToOverwriteTarget = false;

    public XsdUrlImportMainPage(IWorkbench theWorkbench, IStructuredSelection theSelection) {
        super(XsdUrlImportMainPage.class.getSimpleName(), XsdUrlImportMainPage.getString("title"));
        this.defaultSelection = theSelection;
    }

    private static String getString(String id) {
        return ModelerXsdUiConstants.Util.getString("XsdUrlImportMainPage." + id, new Object[0]);
    }

    public void createControl(Composite theParent) {
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        pnlMain.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)pnlMain);
        this.createUrlLocationsTable(pnlMain);
        this.createDestinationGroup(pnlMain);
        this.createOptionsPanel(pnlMain);
    }

    public boolean finish() {
        ArrayList<File> xsdFiles = new ArrayList<File>();
        URL url2 = null;
        HashMap fileToUserInfo = new HashMap();
        try {
            for (URL url2 : this.urlToUserInfo.keySet()) {
                Object[] userInfo = (Object[])this.urlToUserInfo.get(url2);
                String filePath = url2.getPath();
                if (filePath.startsWith("/")) {
                    filePath = filePath.substring(1);
                }
                File xsdFile = URLHelper.createFileFromUrl((URL)url2, (String)filePath, (String)((String)userInfo[0]), (String)((String)userInfo[1]), (boolean)((Boolean)userInfo[2]));
                xsdFiles.add(xsdFile);
                fileToUserInfo.put(xsdFile, this.urlToUserInfo.get(url2));
            }
        }
        catch (Exception e) {
            ModelerXsdUiConstants.Util.log((Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)XsdUrlImportMainPage.getString("error1.title"), (String)ModelerXsdUiConstants.Util.getString("XsdUrlImportMainPage.error1.message", (Object)url2));
            return false;
        }
        this.resetOKToOverwriteTarget();
        XsdFileSystemImportUtil.importXsds(xsdFiles, this.addDependentXsdsCheckbox.getSelection(), this.getContainerFullPath(), this.getContainer(), this, false, this.overwriteExistingResourcesCheckbox.getSelection(), fileToUserInfo);
        Authenticator.setDefault(null);
        return true;
    }

    private void resetOKToOverwriteTarget() {
        this.okToOverwriteTarget = false;
        if (this.overwriteExistingResourcesCheckbox.getSelection()) {
            this.okToOverwriteTarget = true;
        } else {
            IPath path = this.getContainerFullPath();
            IWorkspaceRoot root = ModelerCore.getWorkspace().getRoot();
            IResource theResource = root.findMember(path);
            if (theResource != null && theResource instanceof IContainer) {
                IResource[] containedResources = null;
                try {
                    containedResources = ((IContainer)theResource).members();
                }
                catch (CoreException coreException) {}
                if (containedResources != null && containedResources.length == 0) {
                    this.okToOverwriteTarget = true;
                }
            }
        }
    }

    public boolean isPageComplete() {
        if (this.urlToUserInfo.isEmpty()) {
            return false;
        }
        return this.validateDestinationFolder();
    }

    void handleModifyText() {
        this.getContainer().updateButtons();
    }

    private void createDestinationGroup(Composite parent) {
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        containerGroup.setFont(parent.getFont());
        Label resourcesLabel = new Label(containerGroup, 0);
        resourcesLabel.setText(XsdUrlImportMainPage.getString("folderLabel"));
        resourcesLabel.setFont(parent.getFont());
        this.containerNameField = new Text(containerGroup, 2052);
        this.containerNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XsdUrlImportMainPage.this.handleModifyText();
            }
        });
        GridData data = new GridData(768);
        this.containerNameField.setLayoutData((Object)data);
        this.containerNameField.setFont(parent.getFont());
        Button containerBrowseButton = new Button(containerGroup, 8);
        containerBrowseButton.setText(XsdUrlImportMainPage.getString("browse"));
        containerBrowseButton.setLayoutData((Object)new GridData(256));
        containerBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XsdUrlImportMainPage.this.handleContainerBrowseButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        containerBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(containerBrowseButton);
        if (this.defaultSelection != null) {
            Object resource;
            Object firstElement;
            IContainer currentResourceSelection = null;
            if (this.defaultSelection.size() == 1 && (firstElement = this.defaultSelection.getFirstElement()) instanceof IAdaptable && (resource = ((IAdaptable)firstElement).getAdapter(IResource.class)) != null) {
                currentResourceSelection = (IResource)resource;
            }
            if (currentResourceSelection != null) {
                if (currentResourceSelection.getType() == 1) {
                    currentResourceSelection = currentResourceSelection.getParent();
                }
                if (!currentResourceSelection.isAccessible()) {
                    currentResourceSelection = null;
                }
            }
            if (currentResourceSelection != null) {
                this.containerNameField.setText(currentResourceSelection.getFullPath().makeRelative().toString());
            }
        }
    }

    private final boolean validateDestinationFolder() {
        IPath containerPath = this.getContainerFullPath();
        if (containerPath == null) {
            this.setMessage(IDEWorkbenchMessages.WizardImportPage_specifyFolder);
            return false;
        }
        IContainer container = this.getSpecifiedContainer();
        if (container == null) {
            if (IDEWorkbenchPlugin.getPluginWorkspace().getRoot().exists(this.getContainerFullPath())) {
                return false;
            }
            IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
            IPath projectPath = containerPath.removeLastSegments(containerPath.segmentCount() - 1);
            if (workspace.getRoot().exists(projectPath)) {
                return true;
            }
            this.setErrorMessage(IDEWorkbenchMessages.WizardImportPage_projectNotExist);
            return false;
        }
        if (!container.isAccessible()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardImportPage_folderMustExist);
            return false;
        }
        if (container.getLocation() == null) {
            if (container.isLinked()) {
                this.setErrorMessage(IDEWorkbenchMessages.WizardImportPage_undefinedPathVariable);
            } else {
                this.setErrorMessage(IDEWorkbenchMessages.WizardImportPage_containerNotExist);
            }
            return false;
        }
        return true;
    }

    void handleContainerBrowseButtonPressed() {
        IPath containerPath = this.queryForContainer(this.getSpecifiedContainer(), IDEWorkbenchMessages.WizardImportPage_selectFolderLabel, IDEWorkbenchMessages.WizardImportPage_selectFolderTitle);
        if (containerPath != null) {
            this.setErrorMessage(null);
            this.containerNameField.setText(containerPath.makeRelative().toString());
        }
    }

    private IContainer getSpecifiedContainer() {
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IPath path = this.getContainerFullPath();
        if (workspace.getRoot().exists(path)) {
            IResource resource = workspace.getRoot().findMember(path);
            if (resource.getType() == 1) {
                return null;
            }
            return (IContainer)resource;
        }
        return null;
    }

    private IPath getContainerFullPath() {
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IPath testPath = this.getPathFromText(this.containerNameField);
        if (testPath.equals((Object)workspace.getRoot().getFullPath())) {
            return testPath;
        }
        IStatus result = workspace.validatePath(testPath.toString(), 14);
        if (result.isOK()) {
            return testPath;
        }
        return null;
    }

    protected IPath getPathFromText(Text textField) {
        String text = textField.getText();
        if (text.length() == 0) {
            return new Path(text);
        }
        return new Path(text).makeAbsolute();
    }

    private IPath queryForContainer(IContainer initialSelection, String msg, String title) {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getControl().getShell(), initialSelection, true, msg);
        if (title != null) {
            dialog.setTitle(title);
        }
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length == 1) {
            return (IPath)result[0];
        }
        return null;
    }

    private void createUrlLocationsTable(Composite theParent) {
        ViewForm viewForm = WidgetFactory.createViewForm((Composite)theParent, (int)2048, (int)1808, (int)1);
        viewForm.setTopLeft((Control)WidgetFactory.createLabel((Composite)viewForm, (String)XsdUrlImportMainPage.getString("label.table")));
        Composite pnl = WidgetFactory.createPanel((Composite)viewForm, (int)0, (int)1808);
        viewForm.setContent((Control)pnl);
        this.viewer = WidgetFactory.createTableViewer((Composite)pnl, (int)770);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object theInputElement) {
                return XsdUrlImportMainPage.this.urlToUserInfo.keySet().toArray();
            }

            public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
            }
        });
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object theElement) {
                return theElement.toString();
            }
        };
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent theEvent) {
                XsdUrlImportMainPage.this.handleTableSelectionChanged();
            }
        });
        this.createTableActions(WidgetFactory.createViewFormToolBar((ViewForm)viewForm));
        this.createTableContextMenu();
    }

    void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.removeUrlAction.setEnabled(!selection.isEmpty());
        this.getContainer().updateButtons();
    }

    private void createTableActions(IToolBarManager theToolBarMgr) {
        this.addUrlAction = new Action(XsdUrlImportMainPage.getString("action.addUrl"), 1){

            public void run() {
                XsdUrlImportMainPage.this.handleAddUrl();
            }
        };
        this.addUrlAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.addUrlAction.setToolTipText(XsdUrlImportMainPage.getString("action.addUrl.tip"));
        this.addUrlAction.setEnabled(true);
        theToolBarMgr.add(this.addUrlAction);
        this.removeUrlAction = new Action(XsdUrlImportMainPage.getString("action.removeUrl"), 1){

            public void run() {
                XsdUrlImportMainPage.this.handleRemoveUrl();
            }
        };
        this.removeUrlAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.removeUrlAction.setToolTipText(XsdUrlImportMainPage.getString("action.removeUrl.tip"));
        this.removeUrlAction.setEnabled(false);
        theToolBarMgr.add(this.removeUrlAction);
        theToolBarMgr.update(true);
    }

    protected void createTableContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.add(this.addUrlAction);
        mgr.add(this.removeUrlAction);
        Control table = this.viewer.getControl();
        table.setMenu(mgr.createContextMenu(table));
    }

    void handleAddUrl() {
        XsdUrlDialog dialog = new XsdUrlDialog(this.getShell());
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            URL newUrl = dialog.getUrlObject();
            this.urlToUserInfo.put(newUrl, new Object[]{dialog.getUserName(), dialog.getPassword(), new Boolean(dialog.verifyHostname())});
            this.viewer.add((Object)newUrl);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)newUrl), true);
        }
        this.handleTableSelectionChanged();
    }

    void handleRemoveUrl() {
        Object[] selectedUrls = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        int i = 0;
        while (i < selectedUrls.length) {
            this.urlToUserInfo.remove(selectedUrls[i]);
            ++i;
        }
        this.viewer.remove(selectedUrls);
        this.handleTableSelectionChanged();
    }

    private void createOptionsPanel(Composite theParent) {
        Group optionsGroup = new Group(theParent, 0);
        GridLayout layout = new GridLayout();
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setText(IDEWorkbenchMessages.WizardExportPage_options);
        optionsGroup.setFont(theParent.getFont());
        this.overwriteExistingResourcesCheckbox = new Button((Composite)optionsGroup, 32);
        this.overwriteExistingResourcesCheckbox.setFont(optionsGroup.getFont());
        this.overwriteExistingResourcesCheckbox.setText(DataTransferMessages.FileImport_overwriteExisting);
        this.addDependentXsdsCheckbox = new Button((Composite)optionsGroup, 32);
        this.addDependentXsdsCheckbox.setFont(optionsGroup.getFont());
        this.addDependentXsdsCheckbox.setText(XsdUrlImportMainPage.getString("addDependentXsdFiles.text"));
        this.addDependentXsdsCheckbox.setSelection(true);
    }

    public String queryOverwrite(String pathString) {
        if (this.okToOverwriteTarget) {
            return "YES";
        }
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_existsQuestion, (Object)pathString) : NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), IDEWorkbenchMessages.Question, null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }
}

