/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.imports.sap;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.fusesource.ide.imports.sap.Feature;
import org.fusesource.ide.imports.sap.IDoc3ImportSettings;
import org.fusesource.ide.imports.sap.ImportUtils;
import org.fusesource.ide.imports.sap.JCo3ImportSettings;
import org.fusesource.ide.imports.sap.SAPArchive;

public class SapLibrariesFeatureArchive
extends SAPArchive {
    private static final String FEATURE_LICENSE = "Red Hat, Inc. licenses these features and plugins to you under\ncertain open source licenses (or aggregations of such licenses), which\nin a particular case may include the Eclipse Public License, the GNU\nLesser General Public License, and/or certain other open source\nlicenses. For precise licensing details, consult the corresponding\nsource code, or contact Red Hat, Attn: General Counsel,\n100 East Davie St., Raleigh NC 27601 USA.\n";
    private static final String FEATURE_DESCRIPTION = "Provides SAP JCo3 and IDoc3 Libraries for JBoss Fuse SAP Tooling Suite installations.";
    private static final String FEATURE_PROVIDER_NAME = "JBoss by Red Hat";
    private static final String FEATURE_VERSION = "3.0.0";
    private static final String FEATURE_LABEL = "SAP JCo3 and IDoc3 Libraries";
    private static final String FEATURE_ID = "com.sap.conn";
    private static final String FEATURE_XML_ENTRY_NAME = "feature.xml";
    private static final String FEATURE_PROPERTIES_FILE_NAME = "feature.properties";
    private static final String FEATURE_PROPERTIES_FILE = "###############################################################################\n# Copyright (c) 2010-2015 Red Hat, Inc. and others.\n# All rights reserved. This program and the accompanying materials \n# are made available under the terms of the Eclipse Public License v1.0\n# which accompanies this distribution, and is available at\n# http://www.eclipse.org/legal/epl-v10.html\n# \n# Contributors:\n#     JBoss by Red Hat - Initial implementation.\n##############################################################################\n# feature.properties\n# contains externalized strings for feature.xml\n# \"%foo\" in feature.xml corresponds to the key \"foo\" in this file\n# java.io.Properties file (ISO 8859-1 with \"\\\" escapes)\n# This file should be translated.\n\n# \"featureName\" property - name of the feature\nfeatureName=SAP Libraries\n\n# \"providerName\" property - name of the company that provides the feature\nproviderName=JBoss by Red Hat\n\n# \"updateSiteName\" property - label for the update site\nupdateSiteName=SAP Libraries Update Site\n\ndevUpdateSiteName=SAP Libraries Development Update Site\n\n# \"description\" property - description of the feature\ndescription=Provides SAP JCo3 and IDoc3 Libraries for JBoss Fuse SAP Tooling Suite installations.\ncopyright=JBoss, Home of Professional Open Source Copyright (c) Red Hat, Inc., and individual contributors as indicated by the @authors tag, 2006-2015. See the copyright.txt in the distribution for a full listing of individual contributors.\n ";
    private static final String LICENSE_FILE_NAME = "license.html";
    private static final String LICENSE_FILE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">\n<html>\n\n<body>\n<p>Red Hat, Inc. licenses these features and plugins to you under\ncertain open source licenses (or aggregations of such licenses), which\nin a particular case may include the Eclipse Public License, the GNU\nLesser General Public License, and/or certain other open source\nlicenses. For precise licensing details, consult the corresponding\nsource code, or contact Red Hat, Attn: General Counsel,\n100 East Davie St., Raleigh NC 27601 USA.\n</p>\n</body>\n</html>";
    private JCo3ImportSettings jco3ImportSettings;
    private IDoc3ImportSettings idoc3ImportSettings;

    public JCo3ImportSettings getJco3ImportSettings() {
        return this.jco3ImportSettings;
    }

    public void setJco3ImportSettings(JCo3ImportSettings jco3ImportSettings) {
        this.jco3ImportSettings = jco3ImportSettings;
    }

    public IDoc3ImportSettings getIdoc3ImportSettings() {
        return this.idoc3ImportSettings;
    }

    public void setIdoc3ImportSettings(IDoc3ImportSettings idoc3ImportSettings) {
        this.idoc3ImportSettings = idoc3ImportSettings;
    }

    public void buildSAPLibrariesFeature() throws IOException {
        long lastModified = new Date().getTime();
        try (ZipOutputStream target = null;){
            try {
                String bundleFilename = ImportUtils.getFeatureBundleFilename();
                target = new JarOutputStream(new FileOutputStream(bundleFilename));
                byte[] manifest = this.createBundleManifestFile();
                this.addJarEntry((JarOutputStream)target, "META-INF/MANIFEST.MF", manifest, lastModified);
                byte[] featureXml = this.createFeatureXmlFile();
                this.addJarEntry((JarOutputStream)target, FEATURE_XML_ENTRY_NAME, featureXml, lastModified);
                this.addJarEntry((JarOutputStream)target, FEATURE_PROPERTIES_FILE_NAME, FEATURE_PROPERTIES_FILE.getBytes("UTF-8"), lastModified);
                this.addJarEntry((JarOutputStream)target, LICENSE_FILE_NAME, LICENSE_FILE.getBytes("UTF-8"), lastModified);
            }
            catch (Exception exception) {
                if (target != null) {
                    target.close();
                }
            }
        }
    }

    private byte[] createFeatureXmlFile() throws Exception {
        Feature feature = new Feature();
        feature.setId(FEATURE_ID);
        feature.setLabel(FEATURE_LABEL);
        feature.setVersion(FEATURE_VERSION);
        feature.setProviderName(FEATURE_PROVIDER_NAME);
        Feature.Description description = new Feature.Description();
        description.setContent(FEATURE_DESCRIPTION);
        feature.setDescription(description);
        Feature.Copyright copyright = new Feature.Copyright();
        copyright.setContent("Copyright 2015 Red Hat, Inc.");
        feature.setCopyright(copyright);
        Feature.License license = new Feature.License();
        license.setContent(FEATURE_LICENSE);
        feature.setLicense(license);
        ArrayList<Feature.Plugin> plugins = new ArrayList<Feature.Plugin>();
        Feature.Plugin plugin = new Feature.Plugin();
        plugin.setId(this.idoc3ImportSettings.getBundleSymbolicName());
        plugin.setVersion(this.idoc3ImportSettings.getArchiveVersion());
        plugin.setUnpack(false);
        plugins.add(plugin);
        plugin = new Feature.Plugin();
        plugin.setId(this.jco3ImportSettings.getBundleSymbolicName());
        plugin.setVersion(this.jco3ImportSettings.getArchiveVersion());
        plugin.setUnpack(false);
        plugins.add(plugin);
        plugin = new Feature.Plugin();
        plugin.setId(this.jco3ImportSettings.getFragmentSymbolicName());
        plugin.setVersion(this.jco3ImportSettings.getArchiveVersion());
        plugin.setOs(this.jco3ImportSettings.getJco3Archive().getType().getEclipseOS());
        plugin.setWs(this.jco3ImportSettings.getJco3Archive().getType().getEclipseWS());
        plugin.setArch(this.jco3ImportSettings.getJco3Archive().getType().getEclipseArch());
        plugin.setFragment(true);
        plugin.setUnpack(false);
        plugins.add(plugin);
        feature.setPlugins(plugins);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Feature.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        StringWriter stringWriter = new StringWriter();
        m.marshal((Object)feature, (Writer)stringWriter);
        return stringWriter.toString().getBytes("UTF-8");
    }

    private byte[] createBundleManifestFile() throws IOException {
        StringBuilder manifest = new StringBuilder();
        this.writeAttribute(manifest, Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        return manifest.toString().getBytes("UTF-8");
    }
}

