/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.imports.sap;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAndBundlesPublisherApplication;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.ide.imports.sap.Activator;
import org.fusesource.ide.imports.sap.IDoc3ImportSettings;
import org.fusesource.ide.imports.sap.ImportUtils;
import org.fusesource.ide.imports.sap.JCo3Archive;
import org.fusesource.ide.imports.sap.JCo3ImportSettings;
import org.fusesource.ide.imports.sap.Messages;
import org.fusesource.ide.imports.sap.SapLibrariesFeatureArchive;
import org.fusesource.ide.imports.sap.SapToolsPolicy;
import org.jboss.tools.foundation.core.properties.IPropertiesProvider;
import org.jboss.tools.foundation.core.properties.PropertiesHelper;

public class SapToolSuiteInstaller
implements IRunnableWithProgress {
    private static final String COMPRESS_FLAG = "-compress";
    private static final String PUBLISH_ARTIFACTS_FLAG = "-publishArtifacts";
    private static final String SOURCE_ARG = "-source";
    private static final String ARTIFACT_REPOSITORY_ARG = "-artifactRepository";
    private static final String METADATA_REPOSITORY_ARG = "-metadataRepository";
    private static final String DOT = ".";
    private static final String CONFIGS_ARG = "-configs";
    private static final String APPEND_FLAG = "-append";
    private static final String INTEGRATION_STACK_SAP_URL_PROP = "jboss.discovery.site.integration-stack-sap.url";
    private static final String INTEGRATION_STACK_SAP_FEATURE_PROP = "jboss.discovery.site.integration-stack-sap.feature";
    private SapLibrariesFeatureArchive sapLibrariesFeatureArchive;
    private JCo3ImportSettings jco3ImportSettings;
    private IDoc3ImportSettings idoc3ImportSettings;

    public SapToolSuiteInstaller(SapLibrariesFeatureArchive sapLibrariesFeatureArchive, JCo3ImportSettings jco3ImportSettings, IDoc3ImportSettings idoc3ImportSettings) {
        this.sapLibrariesFeatureArchive = sapLibrariesFeatureArchive;
        this.jco3ImportSettings = jco3ImportSettings;
        this.idoc3ImportSettings = idoc3ImportSettings;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)Messages.SapToolSuiteInstaller_InstallingJBossFuseSapToolSuite, (int)7);
        try {
            try {
                this.jco3ImportSettings.getJco3Archive().buildJCoPlugin(this.jco3ImportSettings);
                monitor.worked(1);
                this.checkCancelled((IProgressMonitor)monitor);
                this.jco3ImportSettings.getJco3Archive().buildJCoNativePlugin(this.jco3ImportSettings);
                monitor.worked(1);
                this.checkCancelled((IProgressMonitor)monitor);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                this.idoc3ImportSettings.getIdoc3Archive().buildIDoc3Plugin(this.idoc3ImportSettings);
                monitor.worked(1);
                this.checkCancelled((IProgressMonitor)monitor);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                this.sapLibrariesFeatureArchive.buildSAPLibrariesFeature();
                monitor.worked(1);
                this.checkCancelled((IProgressMonitor)monitor);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                final URI librariesRepositoryURI = ImportUtils.getTemporySapLibrariesRepository().toUri();
                String librariesRepositoryURL = librariesRepositoryURI.toString();
                String librariesRepositoryPath = ImportUtils.getTemporySapLibrariesRepository().toString();
                FeaturesAndBundlesPublisherApplication fabpa = new FeaturesAndBundlesPublisherApplication();
                JCo3Archive.JCoArchiveType type = this.jco3ImportSettings.getJco3Archive().getType();
                fabpa.run(new String[]{APPEND_FLAG, CONFIGS_ARG, String.valueOf(type.getEclipseWS()) + DOT + type.getEclipseOS() + DOT + type.getEclipseArch(), METADATA_REPOSITORY_ARG, librariesRepositoryURL, ARTIFACT_REPOSITORY_ARG, librariesRepositoryURL, SOURCE_ARG, librariesRepositoryPath, PUBLISH_ARTIFACTS_FLAG, COMPRESS_FLAG});
                monitor.worked(1);
                this.checkCancelled((IProgressMonitor)monitor);
                final IProvisioningAgent provisioningAgent = Activator.getProvisioningAgent();
                URI sapToolingSuiteRepositoryURI = this.getSapToolingUpdateSiteUrl();
                String sapToolingSuiteFeature = this.getSapToolingFeature();
                ProvisioningSession session = new ProvisioningSession(provisioningAgent);
                ProvisioningUI ui = new ProvisioningUI(session, "_SELF_", (Policy)new SapToolsPolicy());
                ui.loadArtifactRepository(librariesRepositoryURI, false, (IProgressMonitor)monitor);
                ui.loadArtifactRepository(sapToolingSuiteRepositoryURI, false, (IProgressMonitor)new NullProgressMonitor());
                IMetadataRepository librariesMetadataRepository = ui.loadMetadataRepository(librariesRepositoryURI, false, (IProgressMonitor)monitor);
                IMetadataRepository sapToolingMetadataRepository = ui.loadMetadataRepository(sapToolingSuiteRepositoryURI, false, (IProgressMonitor)new NullProgressMonitor());
                HashSet toInstall = new HashSet();
                toInstall.addAll(librariesMetadataRepository.query(QueryUtil.createIUGroupQuery(), (IProgressMonitor)monitor).toUnmodifiableSet());
                toInstall.addAll(sapToolingMetadataRepository.query(QueryUtil.createIUQuery((String)sapToolingSuiteFeature), (IProgressMonitor)monitor).toUnmodifiableSet());
                InstallOperation installOperation = ui.getInstallOperation(toInstall, new URI[]{librariesRepositoryURI, sapToolingSuiteRepositoryURI});
                IStatus status = installOperation.resolveModal((IProgressMonitor)monitor);
                monitor.worked(1);
                this.checkCancelled((IProgressMonitor)monitor);
                if (!status.isOK()) {
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.SapToolSuiteInstaller_JBossFuseSAPToolSuiteInstallFailed, (String)Messages.SapToolSuiteInstaller_UnableToPerformInstallationOfJBossFuseSAPToolSuite, (IStatus)status);
                    throw new InvocationTargetException(status.getException(), String.valueOf(Messages.SapToolSuiteInstaller_JBossFuseSapToolSuiteCouldNotBeInstalled) + status.getMessage());
                }
                final ProvisioningJob job = installOperation.getProvisioningJob((IProgressMonitor)new NullProgressMonitor());
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        IArtifactRepositoryManager artifactRepositoryManager = (IArtifactRepositoryManager)provisioningAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
                        IMetadataRepositoryManager metadataRepositoryManager = (IMetadataRepositoryManager)provisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
                        artifactRepositoryManager.removeRepository(librariesRepositoryURI);
                        metadataRepositoryManager.removeRepository(librariesRepositoryURI);
                        ImportUtils.deleteTemporarySapLibrariesRepository();
                        IStatus jobResult = job.getResult();
                        if (4 == jobResult.getSeverity()) {
                            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.SapToolSuiteInstaller_errorDuringInstallationTitle, (String)Messages.SapToolSuiteInstaller_errorDuringInstallationMessage, (IStatus)jobResult);
                        }
                    }
                });
                ui.schedule(job, 3);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e, e.getMessage());
            }
        }
        finally {
            monitor.done();
        }
    }

    public URI getSapToolingUpdateSiteUrl() throws InterruptedException {
        String sapToolingUpdateSite = System.getProperty(INTEGRATION_STACK_SAP_URL_PROP, null);
        if (sapToolingUpdateSite == null) {
            IPropertiesProvider propertiesProvider = PropertiesHelper.getPropertiesProvider();
            sapToolingUpdateSite = propertiesProvider.getValue(INTEGRATION_STACK_SAP_URL_PROP);
        }
        if (sapToolingUpdateSite == null) {
            throw new InterruptedException(String.format("No URL set for discovery catalog. Property %s is missing!", INTEGRATION_STACK_SAP_URL_PROP));
        }
        return URI.create(sapToolingUpdateSite);
    }

    public String getSapToolingFeature() throws InterruptedException {
        String sapToolingUpdateSite = System.getProperty(INTEGRATION_STACK_SAP_FEATURE_PROP, null);
        if (sapToolingUpdateSite == null) {
            IPropertiesProvider propertiesProvider = PropertiesHelper.getPropertiesProvider();
            sapToolingUpdateSite = propertiesProvider.getValue(INTEGRATION_STACK_SAP_FEATURE_PROP);
        }
        if (sapToolingUpdateSite == null) {
            throw new InterruptedException(String.format("No feature set for discovery catalog. Property %s is missing!", INTEGRATION_STACK_SAP_FEATURE_PROP));
        }
        return sapToolingUpdateSite;
    }

    protected void checkCancelled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }
}

