/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.editor;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jbpm.gd.common.editor.ActionRegistry;
import org.jbpm.gd.common.editor.GraphPage;

public class ActionBarContributor
extends MultiPageEditorActionBarContributor {
    private static final String[] WORKBENCH_ACTION_IDS = new String[]{ActionFactory.PRINT.getId(), ActionFactory.DELETE.getId(), ActionFactory.SAVE.getId(), ActionFactory.UNDO.getId(), ActionFactory.REDO.getId(), ActionFactory.CUT.getId(), ActionFactory.COPY.getId(), ActionFactory.PASTE.getId(), ActionFactory.SELECT_ALL.getId(), ActionFactory.FIND.getId(), IDEActionFactory.BOOKMARK.getId()};
    private static final String[] TEXTEDITOR_ACTION_IDS = new String[]{ITextEditorActionConstants.PRINT, ITextEditorActionConstants.DELETE, ITextEditorActionConstants.SAVE, ITextEditorActionConstants.UNDO, ITextEditorActionConstants.REDO, ITextEditorActionConstants.CUT, ITextEditorActionConstants.COPY, ITextEditorActionConstants.PASTE, ITextEditorActionConstants.SELECT_ALL, ITextEditorActionConstants.FIND, IDEActionFactory.BOOKMARK.getId()};

    public void setActivePage(IEditorPart activeEditor) {
        IActionBars actionBars = this.getActionBars();
        if (actionBars == null) {
            return;
        }
        if (activeEditor instanceof GraphPage) {
            this.hookGlobalGraphicalEditorActions((GraphPage)activeEditor, actionBars);
        } else if (activeEditor instanceof StructuredTextEditor) {
            this.hookGlobalXmlEditorActions((StructuredTextEditor)activeEditor, actionBars);
        }
        actionBars.updateActionBars();
    }

    private void hookGlobalXmlEditorActions(StructuredTextEditor part, IActionBars actionBars) {
        int i = 0;
        while (i < WORKBENCH_ACTION_IDS.length) {
            actionBars.setGlobalActionHandler(WORKBENCH_ACTION_IDS[i], part.getAction(TEXTEDITOR_ACTION_IDS[i]));
            ++i;
        }
    }

    private void hookGlobalGraphicalEditorActions(GraphPage part, IActionBars actionBars) {
        ActionRegistry registry = part.getEditor().getActionRegistry();
        int i = 0;
        while (i < WORKBENCH_ACTION_IDS.length) {
            IAction action = registry.getAction(WORKBENCH_ACTION_IDS[i]);
            actionBars.setGlobalActionHandler(WORKBENCH_ACTION_IDS[i], action);
            ++i;
        }
    }
}

