/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.editor;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NotationElementFactory;
import org.jbpm.gd.common.notation.NotationMapping;

public class CreationFactory
implements org.eclipse.gef.requests.CreationFactory {
    SemanticElement semanticElement;
    String elementId;
    SemanticElementFactory semanticElementFactory;
    NotationElementFactory notationElementFactory;

    public CreationFactory(String elementId, SemanticElementFactory semanticElementFactory, NotationElementFactory notationElementFactory) {
        this.elementId = elementId;
        this.semanticElementFactory = semanticElementFactory;
        this.notationElementFactory = notationElementFactory;
    }

    public CreationFactory(SemanticElement semanticElement, NotationElementFactory notationElementFactory) {
        this(semanticElement.getElementId(), semanticElement.getFactory(), notationElementFactory);
        this.semanticElement = semanticElement;
    }

    public Object getNewObject() {
        Dimension dimension;
        String notationElementId = NotationMapping.getNotationElementId(this.elementId);
        AbstractNotationElement notationElement = this.notationElementFactory.create(notationElementId);
        if (notationElement instanceof Node && (dimension = NotationMapping.getInitialDimension(this.elementId)) != null) {
            Rectangle constraint = ((Node)notationElement).getConstraint();
            constraint.setSize(new Dimension(dimension));
        }
        SemanticElement element = this.semanticElement != null ? this.semanticElement : this.semanticElementFactory.createById(this.elementId);
        notationElement.setSemanticElement(element);
        notationElement.register();
        return notationElement;
    }

    public Object getObjectType() {
        return this.elementId;
    }
}

