/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.editor;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.jbpm.gd.common.editor.ContextMenuProvider;
import org.jbpm.gd.common.editor.Editor;
import org.jbpm.gd.jpdl.Constants;

public abstract class GraphicalViewer
extends ScrollingGraphicalViewer {
    private Editor editor;

    public GraphicalViewer(Editor editor) {
        this.editor = editor;
        editor.getSelectionSynchronizer().addViewer((EditPartViewer)this);
        this.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler((org.eclipse.gef.GraphicalViewer)this));
        this.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        this.prepareGrid();
    }

    protected abstract void initEditPartFactory();

    private void prepareGrid() {
        this.getLayerManager().getLayer((Object)"Grid Layer").setForegroundColor(Constants.veryLightBlue);
        this.editor.getActionRegistry().registerAction((IAction)new ToggleGridAction((org.eclipse.gef.GraphicalViewer)this));
    }

    public void initControl(Composite parent) {
        super.createControl(parent);
        this.getControl().setBackground(ColorConstants.white);
        ContextMenuProvider provider = new ContextMenuProvider((EditPartViewer)this, this.editor.getActionRegistry());
        this.setContextMenu((MenuManager)provider);
        this.editor.getSite().registerContextMenu("org.jbpm.gd.common.graph.context", (MenuManager)provider, (ISelectionProvider)this);
        this.editor.getEditDomain().addViewer((EditPartViewer)this);
        this.initEditPartFactory();
        this.setContents(this.editor.getRootContainer());
    }

    public Dimension getDimension() {
        Rectangle rectangle = this.getControl().getBounds();
        return new Dimension(rectangle.width, rectangle.height);
    }

    public FigureCanvas getFigureCanvas() {
        return super.getFigureCanvas();
    }

    public Editor getEditor() {
        return this.editor;
    }
}

