/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.notation;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.jbpm.gd.common.editor.CreationFactory;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NodeContainer;

public class RootContainer
extends AbstractNotationElement
implements NodeContainer {
    Dimension dimension;
    List nodes = new ArrayList();
    protected List danglingEdges = new ArrayList();

    public void setDimension(Dimension newDimension) {
        Dimension oldDimension = this.dimension;
        this.dimension = newDimension;
        this.firePropertyChange("dimension", oldDimension, newDimension);
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
        node.setContainer(this);
        this.addArrivingEdges(node);
        this.addLeavingEdges(node);
        this.firePropertyChange("nodeAdd", null, node);
    }

    public void removeNode(Node node) {
        this.removeArrivingEdges(node);
        this.removeLeavingEdges(node);
        this.nodes.remove(node);
        node.setContainer(null);
        this.firePropertyChange("nodeRemove", node, null);
    }

    public List getNodes() {
        return this.nodes;
    }

    protected void removeNode(PropertyChangeEvent evt) {
        SemanticElement jpdlElement = (SemanticElement)evt.getOldValue();
        AbstractNotationElement notationElement = this.getRegisteredNotationElementFor(jpdlElement);
        if (notationElement != null) {
            jpdlElement.removePropertyChangeListener(notationElement);
            this.removeNode((Node)notationElement);
        }
    }

    protected void addNode(PropertyChangeEvent evt) {
        SemanticElement semanticElement = (SemanticElement)evt.getNewValue();
        AbstractNotationElement notationElement = this.getRegisteredNotationElementFor(semanticElement);
        if (notationElement == null) {
            CreationFactory factory = new CreationFactory(semanticElement, this.getFactory());
            notationElement = (AbstractNotationElement)factory.getNewObject();
        }
        this.addNode((Node)notationElement);
        semanticElement.addPropertyChangeListener(notationElement);
    }

    protected void addLeavingEdges(Node node) {
    }

    protected void addArrivingEdges(Node node) {
    }

    protected void removeArrivingEdges(Node node) {
        List list = node.getArrivingEdges();
        int i = 0;
        while (i < list.size()) {
            Edge edge = (Edge)list.get(i);
            node.removeArrivingEdge(edge);
            this.danglingEdges.add(edge);
            ++i;
        }
    }

    protected void removeLeavingEdges(Node node) {
        List list = node.getLeavingEdges();
        int i = 0;
        while (i < list.size()) {
            Edge edge = (Edge)list.get(i);
            Node target = edge.getTarget();
            if (target != null) {
                target.removeArrivingEdge(edge);
            }
            node.removeLeavingEdge(edge);
            SemanticElement semanticElement = edge.getSemanticElement();
            if (semanticElement != null) {
                semanticElement.removePropertyChangeListener(edge);
            }
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
    }
}

