/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.action;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.jbpm.gd.jpdl.deployment.ProcessArchiveBuilder;
import org.jbpm.gd.jpdl.editor.JpdlEditor;

public class SaveProcessArchiveAction
extends Action {
    private JpdlEditor jpdlEditor;

    public SaveProcessArchiveAction(JpdlEditor jpdlEditor) {
        this.jpdlEditor = jpdlEditor;
    }

    public void run() {
        try {
            byte[] processArchive = new ProcessArchiveBuilder(this.jpdlEditor).build();
            if (processArchive == null) {
                return;
            }
            SaveAsDialog saveAsDialog = new SaveAsDialog(this.jpdlEditor.getSite().getShell());
            saveAsDialog.open();
            IPath path = saveAsDialog.getResult();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), 0, null);
            } else if (!this.askIfOverwriteAllowed()) {
                return;
            }
            file.setContents((InputStream)new ByteArrayInputStream(processArchive), 0, null);
        }
        catch (CoreException coreException) {
            this.showSaveProcessArchiveException();
        }
    }

    private void showSaveProcessArchiveException() {
        MessageDialog dialog = new MessageDialog(this.jpdlEditor.getSite().getShell(), "Save Process Archive Failed", null, "The process archive could not be saved.", 1, new String[]{"OK"}, 0);
        dialog.open();
    }

    private boolean askIfOverwriteAllowed() {
        MessageDialog dialog = new MessageDialog(this.jpdlEditor.getSite().getShell(), "Overwrite Existing File?", null, "The chosen file exists. Is it OK to overwrite the contents?", 4, new String[]{"Yes", "No"}, 0);
        return dialog.open() == 0;
    }
}

