/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.command;

import org.eclipse.gef.commands.Command;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ProcessDefinition;
import org.jbpm.gd.jpdl.model.Task;

public class JpdlElementAddActionCommand
extends Command {
    private SemanticElement target;
    private String eventType;
    private Event event;
    private Action action;

    public void setTarget(SemanticElement target) {
        this.target = target;
    }

    public void setActionId(String actionId) {
        this.eventType = this.getEventType(actionId);
    }

    public void execute() {
        if (this.action == null) {
            this.createAction();
        }
        if (this.target instanceof Event) {
            this.addAction((Event)this.target);
        } else {
            this.addAction(this.target);
        }
    }

    public void undo() {
        if (this.target instanceof Event) {
            this.removeAction((Event)this.target);
        } else {
            this.removeAction(this.event);
            if (this.event.getActionElements().length == 0) {
                this.removeEvent(this.target);
            }
        }
    }

    private void createAction() {
        this.action = (Action)this.target.getFactory().createById("org.jbpm.gd.jpdl.action");
    }

    private void createEvent() {
        this.event = (Event)this.target.getFactory().createById("org.jbpm.gd.jpdl.event");
        this.event.setType(this.eventType);
    }

    private void addAction(Event event) {
        event.addActionElement(this.action);
    }

    private void removeAction(Event event) {
        event.removeActionElement(this.action);
    }

    private void removeEvent(SemanticElement element) {
        if (element instanceof ProcessDefinition) {
            ((ProcessDefinition)element).removeEvent(this.event);
        } else if (element instanceof AbstractNode) {
            ((AbstractNode)element).removeEvent(this.event);
        } else if (element instanceof Task) {
            ((Task)element).removeEvent(this.event);
        }
    }

    private void addAction(SemanticElement element) {
        if (this.event == null) {
            this.prepareEvent(element);
        }
        if (this.event.getActionElements().length == 0) {
            this.addEvent(element);
        }
        this.addAction(this.event);
    }

    private void addEvent(SemanticElement element) {
        if (element instanceof ProcessDefinition) {
            ((ProcessDefinition)element).addEvent(this.event);
        } else if (element instanceof AbstractNode) {
            ((AbstractNode)element).addEvent(this.event);
        } else if (element instanceof Task) {
            ((Task)element).addEvent(this.event);
        }
    }

    private Event[] getEvents(SemanticElement element) {
        if (element instanceof ProcessDefinition) {
            return ((ProcessDefinition)element).getEvents();
        }
        if (element instanceof AbstractNode) {
            return ((AbstractNode)element).getEvents();
        }
        if (element instanceof Task) {
            return ((Task)element).getEvents();
        }
        return new Event[0];
    }

    private void prepareEvent(SemanticElement element) {
        Event[] events = this.getEvents(element);
        int i = 0;
        while (i < events.length) {
            if (events[i].getType().equals(this.eventType)) {
                this.event = events[i];
            }
            ++i;
        }
        if (this.event == null) {
            this.createEvent();
        }
    }

    private String getEventType(String actionId) {
        if ("beforeSignal".equals(actionId)) {
            return "before-signal";
        }
        if ("afterSignal".equals(actionId)) {
            return "after-signal";
        }
        if ("nodeEnter".equals(actionId)) {
            return "node-enter";
        }
        if ("nodeLeave".equals(actionId)) {
            return "node-leave";
        }
        if ("processStart".equals(actionId)) {
            return "process-start";
        }
        if ("processEnd".equals(actionId)) {
            return "process-end";
        }
        return null;
    }
}

