/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.deployment;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.jbpm.gd.jpdl.Plugin;
import org.jbpm.gd.jpdl.deployment.ClassesAndResourcesContentProvider;
import org.jbpm.gd.jpdl.deployment.DeploymentInfo;
import org.jbpm.gd.jpdl.editor.JpdlEditor;

public class DeploymentForm {
    private static ILabelProvider LABELPROVIDER = new WorkbenchLabelProvider();
    private FormToolkit toolkit;
    private Composite composite;
    private JpdlEditor editor;
    private DeploymentInfo deploymentInfo;
    private ScrolledForm form;
    private Button includeProcessInfoFileButton;
    private Text processInfoFileText;
    private Button includeGraphicalInfoFileButton;
    private Text graphicalInfoFileText;
    private Button browseGraphicalInfoFileButton;
    private Button includeImageFileButton;
    private Text imageFileText;
    private Button browseImageFileButton;
    private Button additionalFilesAddButton;
    private Button additionalFilesRemoveButton;
    private Table additionalFilesList;
    private Button classesAndResourcesAddButton;
    private Button classesAndResourcesRemoveButton;
    private Table classesAndResourcesList;
    private Text serverNameText;
    private Text serverPortText;
    private Text serverDeployerText;
    private Button useCredentialsButton;
    private Text userNameText;
    private Text passwordText;
    private SelectionListener useCredentialsButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            DeploymentForm.this.userNameText.setEnabled(DeploymentForm.this.useCredentialsButton.getSelection());
            DeploymentForm.this.passwordText.setEnabled(DeploymentForm.this.useCredentialsButton.getSelection());
            DeploymentForm.this.deploymentInfo.setUseCredentials(DeploymentForm.this.useCredentialsButton.getSelection());
        }
    };
    private ModifyListener userNameTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            DeploymentForm.this.deploymentInfo.setUserName(DeploymentForm.this.userNameText.getText());
        }
    };
    private ModifyListener passwordTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            DeploymentForm.this.deploymentInfo.setPassword(DeploymentForm.this.passwordText.getText());
        }
    };
    private ModifyListener serverNameTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            DeploymentForm.this.deploymentInfo.setServerName(DeploymentForm.this.serverNameText.getText());
            DeploymentForm.this.editor.setDirty(true);
        }
    };
    private ModifyListener serverPortTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            DeploymentForm.this.deploymentInfo.setServerPort(DeploymentForm.this.serverPortText.getText());
            DeploymentForm.this.editor.setDirty(true);
        }
    };
    private ModifyListener serverDeployerTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            DeploymentForm.this.deploymentInfo.setServerDeployer(DeploymentForm.this.serverDeployerText.getText());
            DeploymentForm.this.editor.setDirty(true);
        }
    };
    private SelectionListener includeGraphicalInfoFileButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            boolean include = DeploymentForm.this.includeGraphicalInfoFileButton.getSelection();
            DeploymentForm.this.browseGraphicalInfoFileButton.setEnabled(include);
            if (include && DeploymentForm.this.graphicalInfoFileText.getData() != null) {
                DeploymentForm.this.deploymentInfo.setGraphicalInfoFile((IFile)DeploymentForm.this.graphicalInfoFileText.getData());
            } else {
                DeploymentForm.this.deploymentInfo.setGraphicalInfoFile(null);
            }
            DeploymentForm.this.editor.setDirty(true);
        }
    };
    private SelectionListener includeImageFileButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            boolean include = DeploymentForm.this.includeImageFileButton.getSelection();
            DeploymentForm.this.browseImageFileButton.setEnabled(include);
            if (include && DeploymentForm.this.imageFileText.getData() != null) {
                DeploymentForm.this.deploymentInfo.setImageFile((IFile)DeploymentForm.this.imageFileText.getData());
            } else {
                DeploymentForm.this.deploymentInfo.setImageFile(null);
            }
            DeploymentForm.this.editor.setDirty(true);
        }
    };
    private SelectionListener browseGraphicalInfoFileButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(null, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle("Graphical Info File Selection");
            dialog.setMessage("Select the graphical info file.");
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setValidator(DeploymentForm.this.fileSelectionStatusValidator);
            dialog.open();
            if (dialog.getFirstResult() != null && dialog.getFirstResult() instanceof IFile) {
                IFile file = (IFile)dialog.getFirstResult();
                DeploymentForm.this.graphicalInfoFileText.setText(file.getFullPath().toString());
                DeploymentForm.this.graphicalInfoFileText.setData((Object)file);
                DeploymentForm.this.deploymentInfo.setGraphicalInfoFile(file);
                DeploymentForm.this.editor.setDirty(true);
            }
        }
    };
    private SelectionListener browseImageFileButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(null, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle("Image File Selection");
            dialog.setMessage("Select the image file.");
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setValidator(DeploymentForm.this.fileSelectionStatusValidator);
            dialog.open();
            if (dialog.getFirstResult() != null && dialog.getFirstResult() instanceof IFile) {
                IFile file = (IFile)dialog.getFirstResult();
                DeploymentForm.this.imageFileText.setText(file.getFullPath().toString());
                DeploymentForm.this.imageFileText.setData((Object)file);
                DeploymentForm.this.deploymentInfo.setImageFile(file);
                DeploymentForm.this.editor.setDirty(true);
            }
        }
    };
    private SelectionListener additionalFilesListSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            DeploymentForm.this.additionalFilesRemoveButton.setEnabled(DeploymentForm.this.additionalFilesList.getSelectionCount() > 0);
        }
    };
    private SelectionListener additionaFilesAddButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(null, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle("Additional File Selection");
            dialog.setMessage("Select the additional file.");
            dialog.setAllowMultiple(false);
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setValidator(DeploymentForm.this.fileSelectionStatusValidator);
            dialog.open();
            if (dialog.getFirstResult() != null && dialog.getFirstResult() instanceof IFile) {
                IFile file = (IFile)dialog.getFirstResult();
                TableItem tableItem = new TableItem(DeploymentForm.this.additionalFilesList, 0);
                tableItem.setText(String.valueOf(LABELPROVIDER.getText((Object)file)) + " (" + file.getFullPath() + ")");
                tableItem.setImage(LABELPROVIDER.getImage((Object)file));
                DeploymentForm.this.deploymentInfo.addToAdditionalFiles(file);
                DeploymentForm.this.editor.setDirty(true);
            }
        }
    };
    private ISelectionStatusValidator fileSelectionStatusValidator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] arg0) {
            if (arg0.length == 1 && arg0[0] instanceof IFile) {
                return new Status(0, Plugin.getDefault().getBundle().getSymbolicName(), "Press OK to confirm.");
            }
            return new Status(4, Plugin.getDefault().getBundle().getSymbolicName(), "Select a single file.");
        }
    };
    private SelectionListener additionaFilesRemoveButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            int[] indices = DeploymentForm.this.additionalFilesList.getSelectionIndices();
            if (indices.length > 0) {
                TableItem tableItem = DeploymentForm.this.additionalFilesList.getItem(indices[0]);
                Object object = tableItem.getData();
                DeploymentForm.this.deploymentInfo.removeFromAdditionalFiles(object);
                DeploymentForm.this.additionalFilesList.remove(indices[0]);
                DeploymentForm.this.editor.setDirty(true);
            }
        }
    };
    private SelectionListener classesAndResourcesListSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            DeploymentForm.this.classesAndResourcesRemoveButton.setEnabled(DeploymentForm.this.classesAndResourcesList.getSelectionCount() > 0);
        }
    };
    private SelectionListener classesAndResourcesAddButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(null, (ILabelProvider)new JavaElementLabelProvider(), (ITreeContentProvider)new ClassesAndResourcesContentProvider());
            dialog.setTitle("Classes and Resources Selection");
            dialog.setAllowMultiple(false);
            dialog.setMessage("Select a class or resouce.");
            dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
            dialog.setValidator(DeploymentForm.this.classesAndResourcesSelectionStatusValidator);
            dialog.open();
            if (dialog.getFirstResult() != null) {
                IPath path = null;
                if (dialog.getFirstResult() instanceof IFile) {
                    path = ((IFile)dialog.getFirstResult()).getFullPath();
                } else if (dialog.getFirstResult() instanceof ICompilationUnit) {
                    path = ((ICompilationUnit)dialog.getFirstResult()).getPath();
                } else if (dialog.getFirstResult() instanceof IClassFile) {
                    path = ((IClassFile)dialog.getFirstResult()).getPath();
                }
                if (path != null) {
                    TableItem tableItem = new TableItem(DeploymentForm.this.classesAndResourcesList, 0);
                    tableItem.setData(dialog.getFirstResult());
                    tableItem.setText(String.valueOf(LABELPROVIDER.getText(dialog.getFirstResult())) + " (" + path + ")");
                    tableItem.setImage(LABELPROVIDER.getImage(dialog.getFirstResult()));
                    DeploymentForm.this.deploymentInfo.addToClassesAndResources(dialog.getFirstResult());
                    DeploymentForm.this.editor.setDirty(true);
                }
            }
        }
    };
    private ISelectionStatusValidator classesAndResourcesSelectionStatusValidator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] arg0) {
            if (arg0.length == 1 && (arg0[0] instanceof IFile || arg0[0] instanceof ICompilationUnit || arg0[0] instanceof IClassFile)) {
                return new Status(0, Plugin.getDefault().getBundle().getSymbolicName(), "Press OK to confirm.");
            }
            return new Status(4, Plugin.getDefault().getBundle().getSymbolicName(), "Select a single file.");
        }
    };
    private SelectionListener classesAndResourcesRemoveButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            int[] indices = DeploymentForm.this.classesAndResourcesList.getSelectionIndices();
            if (indices.length > 0) {
                TableItem tableItem = DeploymentForm.this.classesAndResourcesList.getItem(indices[0]);
                Object object = tableItem.getData();
                DeploymentForm.this.deploymentInfo.removeFromClassesAndResources(object);
                DeploymentForm.this.classesAndResourcesList.remove(indices[0]);
            }
        }
    };

    public DeploymentForm(FormToolkit toolkit, Composite composite, JpdlEditor editor) {
        this.toolkit = toolkit;
        this.composite = composite;
        this.editor = editor;
        this.deploymentInfo = editor.getDeploymentInfo();
    }

    public void create() {
        this.createMainForm();
        this.createMainFilesSection();
        this.createAdditionalFilesSection();
        this.createClassesAndResourcesSection();
        this.createUserCredentialsSection();
        this.createServerInfoSection();
    }

    private void createMainForm() {
        this.form = this.toolkit.createScrolledForm(this.composite);
        GridData layoutData = new GridData(1808);
        this.form.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        this.form.getBody().setLayout((Layout)layout);
        this.form.getBody().setLayoutData((Object)new GridData(1808));
    }

    private void createMainFilesSection() {
        Section mainFilesSection = this.toolkit.createSection(this.form.getBody(), 384);
        mainFilesSection.marginWidth = 5;
        mainFilesSection.setText("Main Process Files");
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        gridData.horizontalSpan = 2;
        mainFilesSection.setLayoutData((Object)gridData);
        Composite mainFilesClient = this.toolkit.createComposite((Composite)mainFilesSection);
        mainFilesSection.setClient((Control)mainFilesClient);
        mainFilesSection.setDescription("Check and select the files to be included in the deployment.");
        this.toolkit.paintBordersFor(mainFilesClient);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.numColumns = 3;
        mainFilesClient.setLayout((Layout)layout);
        this.createProcessInfoFileField(mainFilesClient);
        this.createGraphicalInfoFileField(mainFilesClient);
        this.createImageFileField(mainFilesClient);
    }

    private void createProcessInfoFileField(Composite parent) {
        this.includeProcessInfoFileButton = this.toolkit.createButton(parent, "Process Info File:", 32);
        this.includeProcessInfoFileButton.setSelection(true);
        this.includeProcessInfoFileButton.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.processInfoFileText = this.toolkit.createText(parent, "");
        this.processInfoFileText.setLayoutData((Object)new GridData(768));
        this.processInfoFileText.setEditable(false);
        this.toolkit.createLabel(parent, "");
    }

    private void createGraphicalInfoFileField(Composite parent) {
        this.includeGraphicalInfoFileButton = this.toolkit.createButton(parent, "Graphical Info File:", 32);
        this.includeGraphicalInfoFileButton.setSelection(true);
        this.includeGraphicalInfoFileButton.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.graphicalInfoFileText = this.toolkit.createText(parent, "");
        this.graphicalInfoFileText.setLayoutData((Object)new GridData(768));
        this.graphicalInfoFileText.setEditable(false);
        this.browseGraphicalInfoFileButton = this.toolkit.createButton(parent, "Browse...", 0);
    }

    private void createImageFileField(Composite parent) {
        this.includeImageFileButton = this.toolkit.createButton(parent, "Image File:", 32);
        this.includeImageFileButton.setSelection(true);
        this.includeImageFileButton.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.imageFileText = this.toolkit.createText(parent, "");
        this.imageFileText.setLayoutData((Object)new GridData(768));
        this.imageFileText.setEditable(false);
        this.browseImageFileButton = this.toolkit.createButton(parent, "Browse...", 0);
    }

    private void createAdditionalFilesSection() {
        Section additionalFilesSection = this.toolkit.createSection(this.form.getBody(), 384);
        additionalFilesSection.marginWidth = 5;
        additionalFilesSection.setText("Additional Files");
        GridData gridData = new GridData(768);
        additionalFilesSection.setLayoutData((Object)gridData);
        Composite additionalFilesClient = this.toolkit.createComposite((Composite)additionalFilesSection);
        additionalFilesSection.setClient((Control)additionalFilesClient);
        additionalFilesSection.setDescription("Add additional files such as forms that need to be included in the deployment.");
        this.toolkit.paintBordersFor(additionalFilesClient);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        additionalFilesClient.setLayout((Layout)layout);
        this.createAdditionalFilesList(additionalFilesClient);
        this.createAdditionalFilesButtons(additionalFilesClient);
    }

    private void createAdditionalFilesList(Composite parent) {
        this.additionalFilesList = this.toolkit.createTable(parent, 772);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 70;
        gridData.widthHint = 100;
        this.additionalFilesList.setLayoutData((Object)gridData);
    }

    private void createAdditionalFilesButtons(Composite parent) {
        Composite composite = this.toolkit.createComposite(parent);
        composite.setLayoutData((Object)new GridData(1040));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.additionalFilesAddButton = this.toolkit.createButton(composite, "Add...", 0);
        this.additionalFilesAddButton.setLayoutData((Object)new GridData(768));
        this.additionalFilesRemoveButton = this.toolkit.createButton(composite, "Remove", 0);
        this.additionalFilesRemoveButton.setEnabled(false);
    }

    private void createClassesAndResourcesSection() {
        Section classesAndResourcesSection = this.toolkit.createSection(this.form.getBody(), 384);
        classesAndResourcesSection.marginWidth = 5;
        classesAndResourcesSection.setText("Classes and Resources");
        GridData gridData = new GridData(768);
        classesAndResourcesSection.setLayoutData((Object)gridData);
        Composite classesAndResourcesClient = this.toolkit.createComposite((Composite)classesAndResourcesSection);
        classesAndResourcesSection.setClient((Control)classesAndResourcesClient);
        classesAndResourcesSection.setDescription("Add classes and/or resources that need to be included in the deployment.");
        this.toolkit.paintBordersFor(classesAndResourcesClient);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        classesAndResourcesClient.setLayout((Layout)layout);
        this.createClassesAndResourcesList(classesAndResourcesClient);
        this.createClassesAndResourcesButtons(classesAndResourcesClient);
    }

    private void createClassesAndResourcesList(Composite parent) {
        this.classesAndResourcesList = this.toolkit.createTable(parent, 772);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 70;
        gridData.widthHint = 100;
        this.classesAndResourcesList.setLayoutData((Object)gridData);
    }

    private void createClassesAndResourcesButtons(Composite parent) {
        Composite composite = this.toolkit.createComposite(parent);
        composite.setLayoutData((Object)new GridData(1040));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.classesAndResourcesAddButton = this.toolkit.createButton(composite, "Add", 0);
        this.classesAndResourcesAddButton.setLayoutData((Object)new GridData(768));
        this.classesAndResourcesRemoveButton = this.toolkit.createButton(composite, "Remove", 0);
        this.classesAndResourcesRemoveButton.setEnabled(false);
    }

    private void createUserCredentialsSection() {
        Section userCredentialsSection = this.toolkit.createSection(this.form.getBody(), 384);
        userCredentialsSection.marginWidth = 5;
        userCredentialsSection.setText("User Credentials");
        GridData gridData = new GridData(768);
        userCredentialsSection.setLayoutData((Object)gridData);
        Composite userCredentialsClient = this.toolkit.createComposite((Composite)userCredentialsSection);
        userCredentialsSection.setClient((Control)userCredentialsClient);
        userCredentialsSection.setDescription("Specify the user credentials for the chosen server.");
        this.toolkit.paintBordersFor(userCredentialsClient);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        userCredentialsClient.setLayout((Layout)layout);
        this.useCredentialsButton = this.toolkit.createButton(userCredentialsClient, "Use credentials", 32);
        this.useCredentialsButton.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 2;
        this.useCredentialsButton.setLayoutData((Object)buttonData);
        Label userNameLabel = this.toolkit.createLabel(userCredentialsClient, "Username:");
        userNameLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.userNameText = this.toolkit.createText(userCredentialsClient, "");
        this.userNameText.setLayoutData((Object)new GridData(768));
        Label passwordLabel = this.toolkit.createLabel(userCredentialsClient, "Password:");
        passwordLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.passwordText = this.toolkit.createText(userCredentialsClient, "", 0x400000);
        this.passwordText.setLayoutData((Object)new GridData(768));
    }

    private void createServerInfoSection() {
        Section serverInfoSection = this.toolkit.createSection(this.form.getBody(), 384);
        serverInfoSection.marginWidth = 5;
        serverInfoSection.setText("Server Settings");
        GridData gridData = new GridData(768);
        serverInfoSection.setLayoutData((Object)gridData);
        Composite serverInfoClient = this.toolkit.createComposite((Composite)serverInfoSection);
        serverInfoSection.setClient((Control)serverInfoClient);
        serverInfoSection.setDescription("Specify the settings of the server you wish to deploy to.");
        this.toolkit.paintBordersFor(serverInfoClient);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        serverInfoClient.setLayout((Layout)layout);
        Label serverNameLabel = this.toolkit.createLabel(serverInfoClient, "Server Name:");
        serverNameLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.serverNameText = this.toolkit.createText(serverInfoClient, "");
        this.serverNameText.setLayoutData((Object)new GridData(768));
        Label serverPortLabel = this.toolkit.createLabel(serverInfoClient, "Server Port:");
        serverPortLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.serverPortText = this.toolkit.createText(serverInfoClient, "");
        this.serverPortText.setLayoutData((Object)new GridData(768));
        Label serverDeployerLabel = this.toolkit.createLabel(serverInfoClient, "Server Deployer:");
        serverDeployerLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.serverDeployerText = this.toolkit.createText(serverInfoClient, "");
        this.serverDeployerText.setLayoutData((Object)new GridData(768));
    }

    public void refresh() {
        this.unhookListeners();
        this.updateControls();
        this.hookListeners();
    }

    private void unhookListeners() {
        this.includeGraphicalInfoFileButton.removeSelectionListener(this.includeGraphicalInfoFileButtonSelectionListener);
        this.browseGraphicalInfoFileButton.removeSelectionListener(this.browseGraphicalInfoFileButtonSelectionListener);
        this.includeImageFileButton.removeSelectionListener(this.includeImageFileButtonSelectionListener);
        this.browseImageFileButton.removeSelectionListener(this.browseImageFileButtonSelectionListener);
        this.additionalFilesList.removeSelectionListener(this.additionalFilesListSelectionListener);
        this.additionalFilesAddButton.removeSelectionListener(this.additionaFilesAddButtonSelectionListener);
        this.additionalFilesRemoveButton.removeSelectionListener(this.additionaFilesRemoveButtonSelectionListener);
        this.classesAndResourcesList.removeSelectionListener(this.classesAndResourcesListSelectionListener);
        this.classesAndResourcesAddButton.removeSelectionListener(this.classesAndResourcesAddButtonSelectionListener);
        this.classesAndResourcesRemoveButton.removeSelectionListener(this.classesAndResourcesRemoveButtonSelectionListener);
        this.serverNameText.removeModifyListener(this.serverNameTextListener);
        this.serverPortText.removeModifyListener(this.serverPortTextListener);
        this.serverDeployerText.removeModifyListener(this.serverDeployerTextListener);
        this.useCredentialsButton.removeSelectionListener(this.useCredentialsButtonSelectionListener);
        this.userNameText.removeModifyListener(this.userNameTextListener);
        this.passwordText.removeModifyListener(this.passwordTextListener);
    }

    private void updateControls() {
        this.updateProcessInfoFileControls();
        this.updateGraphicalInfoFileControls();
        this.updateImageFileControls();
        this.updateAdditionalFilesControls();
        this.updateClassesAndResourcesControls();
        this.updateUseCredentialsControls();
        this.updateServerInfoControls();
    }

    private void updateProcessInfoFileControls() {
        IFile processInfoFile = this.deploymentInfo.getProcessInfoFile();
        String value = "";
        if (processInfoFile != null) {
            value = processInfoFile.getFullPath().toString();
        }
        this.includeProcessInfoFileButton.setSelection(!"".equals(value));
        this.includeProcessInfoFileButton.setEnabled(false);
        this.processInfoFileText.setText(value);
    }

    private void updateGraphicalInfoFileControls() {
        IFile graphicalInfoFile = this.deploymentInfo.getGraphicalInfoFile();
        String value = "";
        if (graphicalInfoFile != null) {
            value = graphicalInfoFile.getFullPath().toString();
        }
        this.includeGraphicalInfoFileButton.setSelection(graphicalInfoFile != null);
        this.graphicalInfoFileText.setText(value);
        this.browseGraphicalInfoFileButton.setEnabled(graphicalInfoFile != null);
    }

    private void updateImageFileControls() {
        IFile imageFile = this.deploymentInfo.getImageFile();
        String value = "";
        if (imageFile != null) {
            value = imageFile.getFullPath().toString();
        }
        this.includeImageFileButton.setSelection(imageFile != null);
        this.imageFileText.setText(value);
        this.browseImageFileButton.setEnabled(imageFile != null);
    }

    private void updateAdditionalFilesControls() {
        Object[] additionalFiles;
        Object[] objectArray = additionalFiles = this.deploymentInfo.getAdditionalFiles();
        int n = additionalFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IFile) {
                IFile file = (IFile)object;
                TableItem tableItem = new TableItem(this.additionalFilesList, 0);
                tableItem.setText(String.valueOf(LABELPROVIDER.getText((Object)file)) + " (" + file.getFullPath() + ")");
                tableItem.setImage(LABELPROVIDER.getImage((Object)file));
                tableItem.setData(object);
            }
            ++n2;
        }
    }

    private void updateClassesAndResourcesControls() {
        Object[] classesAndResources;
        Object[] objectArray = classesAndResources = this.deploymentInfo.getClassesAndResources();
        int n = classesAndResources.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IPath path = null;
            if (object instanceof IFile) {
                path = ((IFile)object).getFullPath();
            } else if (object instanceof ICompilationUnit) {
                path = ((ICompilationUnit)object).getPath();
            } else if (object instanceof IClassFile) {
                path = ((IClassFile)object).getPath();
            }
            if (path != null) {
                TableItem tableItem = new TableItem(this.classesAndResourcesList, 0);
                tableItem.setData(object);
                tableItem.setText(String.valueOf(LABELPROVIDER.getText(object)) + " (" + path + ")");
                tableItem.setImage(LABELPROVIDER.getImage(object));
            }
            ++n2;
        }
    }

    private void updateUseCredentialsControls() {
        boolean useCredentials = this.deploymentInfo.getUseCredentials();
        this.useCredentialsButton.setSelection(useCredentials);
        String userName = this.deploymentInfo.getUserName();
        if (userName != null) {
            this.userNameText.setText(userName);
        }
        this.userNameText.setEnabled(useCredentials);
        String password = this.deploymentInfo.getPassword();
        if (password != null) {
            this.passwordText.setText(password);
        }
        this.passwordText.setEnabled(useCredentials);
    }

    private void updateServerInfoControls() {
        String serverDeployer;
        String serverPort;
        String serverName = this.deploymentInfo.getServerName();
        if (serverName != null) {
            this.serverNameText.setText(serverName);
        }
        if ((serverPort = this.deploymentInfo.getServerPort()) != null) {
            this.serverPortText.setText(serverPort);
        }
        if ((serverDeployer = this.deploymentInfo.getServerDeployer()) != null) {
            this.serverDeployerText.setText(serverDeployer);
        }
    }

    private void hookListeners() {
        this.includeGraphicalInfoFileButton.addSelectionListener(this.includeGraphicalInfoFileButtonSelectionListener);
        this.browseGraphicalInfoFileButton.addSelectionListener(this.browseGraphicalInfoFileButtonSelectionListener);
        this.includeImageFileButton.addSelectionListener(this.includeImageFileButtonSelectionListener);
        this.browseImageFileButton.addSelectionListener(this.browseImageFileButtonSelectionListener);
        this.additionalFilesList.addSelectionListener(this.additionalFilesListSelectionListener);
        this.additionalFilesAddButton.addSelectionListener(this.additionaFilesAddButtonSelectionListener);
        this.additionalFilesRemoveButton.addSelectionListener(this.additionaFilesRemoveButtonSelectionListener);
        this.classesAndResourcesList.addSelectionListener(this.classesAndResourcesListSelectionListener);
        this.classesAndResourcesAddButton.addSelectionListener(this.classesAndResourcesAddButtonSelectionListener);
        this.classesAndResourcesRemoveButton.addSelectionListener(this.classesAndResourcesRemoveButtonSelectionListener);
        this.serverNameText.addModifyListener(this.serverNameTextListener);
        this.serverPortText.addModifyListener(this.serverPortTextListener);
        this.serverDeployerText.addModifyListener(this.serverDeployerTextListener);
        this.useCredentialsButton.addSelectionListener(this.useCredentialsButtonSelectionListener);
        this.userNameText.addModifyListener(this.userNameTextListener);
        this.passwordText.addModifyListener(this.passwordTextListener);
    }
}

