/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.deployment;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jbpm.gd.jpdl.Logger;
import org.jbpm.gd.jpdl.editor.JpdlEditor;

public class ProcessArchiveBuilder {
    private JpdlEditor jpdlEditor;

    public ProcessArchiveBuilder(JpdlEditor jpdlEditor) {
        this.jpdlEditor = jpdlEditor;
    }

    public byte[] build() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            if (this.jpdlEditor.getDeploymentInfo() != null) {
                this.addProcessInfoFile(zipOutputStream);
                this.addGraphicalInfoFile(zipOutputStream);
                this.addProcessImageFile(zipOutputStream);
                this.addAdditionalFiles(zipOutputStream);
                this.addClassesAndResources(zipOutputStream);
            }
            zipOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            this.showBuildProcessArchiveException();
            return null;
        }
    }

    private void showBuildProcessArchiveException() {
        MessageDialog dialog = new MessageDialog(this.jpdlEditor.getSite().getShell(), "Build Process Archive Failed", null, "There was a problem creating the process archive to deploy.", 1, new String[]{"OK"}, 0);
        dialog.open();
    }

    private void addFile(ZipOutputStream zipOutputStream, IFile file, String entryName) throws Exception {
        InputStream inputStream;
        byte[] buffer = new byte[256];
        try {
            inputStream = file.getContents();
        }
        catch (CoreException e) {
            Logger.logError("CoreException getting contents of file " + file.getName(), e);
            throw e;
        }
        try {
            zipOutputStream.putNextEntry(new ZipEntry(entryName));
        }
        catch (IOException e) {
            Logger.logError("IOException creating entry '" + entryName + "'.", e);
        }
        try {
            int read;
            while ((read = inputStream.read(buffer)) != -1) {
                zipOutputStream.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            Logger.logError("IOException writing file '" + entryName + "'.", e);
        }
    }

    private void addProcessInfoFile(ZipOutputStream zipOutputStream) throws Exception {
        IFile processInfoFile = this.jpdlEditor.getDeploymentInfo().getProcessInfoFile();
        if (processInfoFile != null) {
            this.addFile(zipOutputStream, processInfoFile, "processdefinition.xml");
        }
    }

    private void addGraphicalInfoFile(ZipOutputStream zipOutputStream) throws Exception {
        IFile graphicalInfoFile = this.jpdlEditor.getDeploymentInfo().getGraphicalInfoFile();
        if (graphicalInfoFile != null) {
            this.addFile(zipOutputStream, graphicalInfoFile, "gpd.xml");
        }
    }

    private void addProcessImageFile(ZipOutputStream zipOutputStream) throws Exception {
        IFile processImageFile = this.jpdlEditor.getDeploymentInfo().getImageFile();
        if (processImageFile != null) {
            this.addFile(zipOutputStream, processImageFile, "processimage.jpg");
        }
    }

    private void addAdditionalFiles(ZipOutputStream zipOutputStream) throws Exception {
        Object[] additionalFiles = this.jpdlEditor.getDeploymentInfo().getAdditionalFiles();
        if (additionalFiles == null) {
            return;
        }
        int i = 0;
        while (i < additionalFiles.length) {
            if (additionalFiles[i] instanceof IFile) {
                IFile file = (IFile)additionalFiles[i];
                this.addFile(zipOutputStream, file, file.getName());
            }
            ++i;
        }
    }

    private void addClassesAndResources(ZipOutputStream zipOutputStream) throws Exception {
        Object[] classesAndResources = this.jpdlEditor.getDeploymentInfo().getClassesAndResources();
        if (classesAndResources == null) {
            return;
        }
        int i = 0;
        while (i < classesAndResources.length) {
            if (classesAndResources[i] instanceof IFile) {
                this.addFile(zipOutputStream, (IFile)classesAndResources[i]);
            } else if (classesAndResources[i] instanceof ICompilationUnit) {
                this.addCompilationUnit(zipOutputStream, (ICompilationUnit)classesAndResources[i]);
            } else if (classesAndResources[i] instanceof IClassFile) {
                this.addClassFile(zipOutputStream, (IClassFile)classesAndResources[i]);
            }
            ++i;
        }
    }

    private void addFile(ZipOutputStream zipOutputStream, String name, ClassLoader classLoader) throws Exception {
        int read;
        byte[] buff = new byte[256];
        zipOutputStream.putNextEntry(new ZipEntry("classes/" + name));
        InputStream is = classLoader.getResourceAsStream(name);
        while ((read = is.read(buff)) != -1) {
            zipOutputStream.write(buff, 0, read);
        }
        is.close();
    }

    private void addFile(ZipOutputStream zipOutputStream, IFile file) throws Exception {
        this.addFile(zipOutputStream, this.getResourceName((IResource)file), this.getClassLoader());
    }

    private void addCompilationUnit(ZipOutputStream zipOutputStream, ICompilationUnit compilationUnit) throws Exception {
        String name = this.getResourceName(compilationUnit.getResource());
        name = String.valueOf(name.substring(0, name.lastIndexOf(".java"))) + ".class";
        ClassLoader classLoader = this.getClassLoader();
        this.addFile(zipOutputStream, name, classLoader);
        this.addInnerClasses(zipOutputStream, name, classLoader);
    }

    private String[] getNestedClassNames(String name, ClassLoader classLoader) {
        final String className = String.valueOf(name.substring(name.lastIndexOf(47) + 1, name.length() - 6)) + '$';
        URL url = classLoader.getResource(name);
        File file = new File(url.getFile());
        File folder = new File(file.getParent());
        return folder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(className);
            }
        });
    }

    private void addInnerClasses(ZipOutputStream zipOutputStream, String name, ClassLoader classLoader) throws Exception {
        String[] nestedClassNames = this.getNestedClassNames(name, classLoader);
        if (nestedClassNames == null) {
            return;
        }
        int i = 0;
        while (i < nestedClassNames.length) {
            String fileName = String.valueOf(name.substring(0, name.lastIndexOf("/") + 1)) + nestedClassNames[i];
            this.addFile(zipOutputStream, fileName, classLoader);
            ++i;
        }
    }

    private void addClassFile(ZipOutputStream zipOutputStream, IClassFile classFile) throws Exception {
        String name = String.valueOf(classFile.getParent().getElementName().replace('.', '/')) + "/" + classFile.getElementName();
        zipOutputStream.putNextEntry(new ZipEntry("classes/" + name));
        zipOutputStream.write(classFile.getBytes());
    }

    private ClassLoader getClassLoader() throws Exception {
        return new URLClassLoader(this.getProjectClasspathUrls(), this.getClass().getClassLoader());
    }

    private URL[] getProjectClasspathUrls() throws Exception {
        URL[] urls = new URL[]{};
        IProject project = this.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return urls;
        }
        String[] pathArray = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        urls = new URL[pathArray.length];
        int i = 0;
        while (i < pathArray.length) {
            urls[i] = new File(pathArray[i]).toURI().toURL();
            ++i;
        }
        return urls;
    }

    private IProject getProject() {
        IEditorInput editorInput = this.jpdlEditor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return null;
        }
        IFile file = ((IFileEditorInput)editorInput).getFile();
        return file.getProject();
    }

    private IPackageFragmentRoot getPackageFragmentRoot(IResource resource) {
        IPackageFragmentRoot root = null;
        IResource r = resource;
        while (r != null) {
            IJavaElement javaElement = JavaCore.create((IResource)r);
            if (javaElement != null && javaElement instanceof IPackageFragmentRoot) {
                root = (IPackageFragmentRoot)javaElement;
                break;
            }
            r = r.getParent();
        }
        return root;
    }

    private String getResourceName(IResource resource) {
        IPackageFragmentRoot root = this.getPackageFragmentRoot(resource);
        if (root == null) {
            return null;
        }
        int index = root.getResource().getProjectRelativePath().toString().length() + 1;
        return resource.getProjectRelativePath().toString().substring(index);
    }
}

