/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.editor;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jbpm.gd.common.editor.AbstractContentProvider;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NodeContainer;
import org.jbpm.gd.common.notation.RootContainer;
import org.jbpm.gd.jpdl.Plugin;
import org.jbpm.gd.jpdl.deployment.DeploymentInfo;
import org.jbpm.gd.jpdl.editor.JpdlEditor;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;
import org.jbpm.gd.jpdl.prefs.PreferencesConstants;

public class JpdlContentProvider
extends AbstractContentProvider
implements PreferencesConstants {
    JpdlEditor jpdlEditor;

    public JpdlContentProvider(JpdlEditor jpdlEditor) {
        this.jpdlEditor = jpdlEditor;
    }

    public String getNotationInfoFileName(String semanticInfoFileName) {
        if ("processdefinition.xml".equals(semanticInfoFileName)) {
            return "gpd.xml";
        }
        if (semanticInfoFileName.endsWith("jpdl.xml")) {
            int index = semanticInfoFileName.indexOf("jpdl.xml");
            return "." + semanticInfoFileName.substring(0, index) + "gpd.xml";
        }
        return super.getNotationInfoFileName(semanticInfoFileName);
    }

    public String getDiagramImageFileName(String semanticInfoFileName) {
        if ("processdefinition.xml".equals(semanticInfoFileName)) {
            return "processimage.jpg";
        }
        if (semanticInfoFileName.endsWith("jpdl.xml")) {
            int index = semanticInfoFileName.indexOf("jpdl.xml");
            return String.valueOf(semanticInfoFileName.substring(0, index)) + "jpg";
        }
        return super.getDiagramImageFileName(semanticInfoFileName);
    }

    protected void addNodes(NodeContainer nodeContainer, Element notationInfo) {
        NodeElementContainer nodeElementContainer = (NodeElementContainer)nodeContainer.getSemanticElement();
        this.addNodes(nodeContainer, nodeElementContainer.getNodeElements(), notationInfo);
    }

    protected void addEdges(Node node, Element notationInfo) {
        NodeElement nodeElement = (NodeElement)node.getSemanticElement();
        this.addEdges(node, nodeElement.getTransitions(), notationInfo);
    }

    protected SemanticElement getEdgeSemanticElement(Node node, Element notationInfo, int index) {
        Transition[] transitions = ((NodeElement)node.getSemanticElement()).getTransitions();
        return index < transitions.length ? transitions[index] : null;
    }

    protected SemanticElement getNodeSemanticElement(NodeContainer nodeContainer, Element notationInfo, int index) {
        NodeElementContainer nodeElementContainer = (NodeElementContainer)nodeContainer.getSemanticElement();
        return nodeElementContainer.getNodeElementByName(notationInfo.attributeValue("name"));
    }

    protected SemanticElement findDestination(Edge edge, Node source) {
        NodeContainer notationElement = source.getContainer();
        String pathCopy = ((Transition)edge.getSemanticElement()).getTo();
        while (pathCopy.length() > 3 && "../".equals(pathCopy.substring(0, 3)) && notationElement != null) {
            notationElement = ((Node)((Object)notationElement)).getContainer();
            pathCopy = pathCopy.substring(3);
        }
        if (notationElement == null) {
            return null;
        }
        SemanticElement parent = notationElement.getSemanticElement();
        StringTokenizer tokenizer = new StringTokenizer(pathCopy, "/");
        while (parent != null && tokenizer.hasMoreTokens()) {
            if (!(parent instanceof NodeElementContainer)) {
                return null;
            }
            parent = ((NodeElementContainer)parent).getNodeElementByName(tokenizer.nextToken());
        }
        return (NodeElement)parent;
    }

    protected void write(RootContainer rootContainer, Element element) {
        super.write(rootContainer, element);
        this.writeDeploymentInfo(this.jpdlEditor.getDeploymentInfo(), element);
    }

    private void writeDeploymentInfo(DeploymentInfo deploymentInfo, Element element) {
        Object[] additionalFiles;
        Element el;
        Object[] classesAndResources;
        if (deploymentInfo.isEmpty()) {
            return;
        }
        Element deploymentElement = this.addElement(element, "deployment");
        if (deploymentInfo.getGraphicalInfoFile() != null) {
            this.addAttribute(deploymentElement, "graphicalInfoFile", deploymentInfo.getGraphicalInfoFile().getFullPath().toString());
        }
        if (deploymentInfo.getImageFile() != null) {
            this.addAttribute(deploymentElement, "imageFile", deploymentInfo.getImageFile().getFullPath().toString());
        }
        if (deploymentInfo.getServerName() != null) {
            this.addAttribute(deploymentElement, "serverName", deploymentInfo.getServerName());
        }
        if (deploymentInfo.getServerPort() != null) {
            this.addAttribute(deploymentElement, "serverPort", deploymentInfo.getServerPort());
        }
        if (deploymentInfo.getServerDeployer() != null) {
            this.addAttribute(deploymentElement, "serverDeployer", deploymentInfo.getServerDeployer());
        }
        if ((classesAndResources = deploymentInfo.getClassesAndResources()).length > 0) {
            Element classesAndResourcesElement = this.addElement(deploymentElement, "classesAndResources");
            int i = 0;
            while (i < classesAndResources.length) {
                String value = null;
                String type = null;
                if (classesAndResources[i] instanceof ICompilationUnit) {
                    value = ((ICompilationUnit)classesAndResources[i]).getPath().toString();
                    type = "java";
                } else if (classesAndResources[i] instanceof IClassFile) {
                    value = ((IClassFile)classesAndResources[i]).getHandleIdentifier();
                    type = "class";
                } else if (classesAndResources[i] instanceof IFile) {
                    value = ((IFile)classesAndResources[i]).getFullPath().toString();
                    type = "file";
                }
                if (value != null) {
                    el = this.addElement(classesAndResourcesElement, "element");
                    this.addAttribute(el, "type", type);
                    this.addAttribute(el, "value", value);
                }
                ++i;
            }
        }
        if ((additionalFiles = deploymentInfo.getAdditionalFiles()).length > 0) {
            Element filesAndFoldersElement = this.addElement(deploymentElement, "additionalFiles");
            int i = 0;
            while (i < additionalFiles.length) {
                if (additionalFiles[i] instanceof IFile) {
                    IFile file = (IFile)additionalFiles[i];
                    el = this.addElement(filesAndFoldersElement, "element");
                    this.addAttribute(el, "value", file.getFullPath().toString());
                }
                ++i;
            }
        }
    }

    protected void initializeDeploymentInfo(DeploymentInfo deploymentInfo, IEditorInput editorInput) {
        try {
            IFile file = this.getNotationInfoFile(((IFileEditorInput)editorInput).getFile());
            InputStreamReader reader = new InputStreamReader(file.getContents());
            Element rootElement = new SAXReader().read((Reader)reader).getRootElement();
            this.processDeploymentInfo(deploymentInfo, rootElement, (IFileEditorInput)editorInput);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected void processDeploymentInfo(DeploymentInfo deploymentInfo, Element element, IFileEditorInput editorInput) {
        Element deploymentElement = element.element("deployment");
        this.processProcessInfoFile(deploymentInfo, deploymentElement, editorInput);
        this.processGraphicalInfoFile(deploymentInfo, deploymentElement, editorInput);
        this.processImageFile(deploymentInfo, deploymentElement, editorInput);
        this.processClassesAndResources(deploymentInfo, deploymentElement, editorInput);
        this.processAdditionalFiles(deploymentInfo, deploymentElement, editorInput);
        this.processServerInfo(deploymentInfo, deploymentElement, editorInput);
    }

    protected void processServerInfo(DeploymentInfo deploymentInfo, Element deploymentElement, IFileEditorInput editorInput) {
        if (deploymentElement == null) {
            return;
        }
        IPreferenceStore prefs = Plugin.getDefault().getPreferenceStore();
        this.processServerName(deploymentInfo, deploymentElement.attribute("serverName"), prefs);
        this.processServerPort(deploymentInfo, deploymentElement.attribute("serverPort"), prefs);
        this.processServerDeployer(deploymentInfo, deploymentElement.attribute("serverDeployer"), prefs);
    }

    private void processServerName(DeploymentInfo deploymentInfo, Attribute attribute, IPreferenceStore prefs) {
        if (attribute == null) {
            deploymentInfo.setServerName(prefs.getString("server name"));
        } else {
            deploymentInfo.setServerName(attribute.getValue());
        }
    }

    private void processServerPort(DeploymentInfo deploymentInfo, Attribute attribute, IPreferenceStore prefs) {
        if (attribute == null) {
            deploymentInfo.setServerPort(prefs.getString("server port"));
        } else {
            deploymentInfo.setServerPort(attribute.getValue());
        }
    }

    private void processServerDeployer(DeploymentInfo deploymentInfo, Attribute attribute, IPreferenceStore prefs) {
        if (attribute == null) {
            deploymentInfo.setServerDeployer(prefs.getString("server deployer"));
        } else {
            deploymentInfo.setServerDeployer(attribute.getValue());
        }
    }

    protected void processProcessInfoFile(DeploymentInfo deploymentInfo, Element deploymentElement, IFileEditorInput editorInput) {
        deploymentInfo.setProcessInfoFile(editorInput.getFile());
    }

    protected void processGraphicalInfoFile(DeploymentInfo deploymentInfo, Element deploymentElement, IFileEditorInput editorInput) {
        IResource resource;
        if (deploymentElement == null) {
            return;
        }
        Attribute attribute = deploymentElement.attribute("graphicalInfoFile");
        if (attribute == null) {
            attribute = deploymentElement.attribute("gpdFile");
        }
        IFile graphicalInfoFile = null;
        if (attribute != null && attribute.getValue() != null && (resource = editorInput.getFile().getWorkspace().getRoot().findMember((IPath)new Path(attribute.getValue()))) instanceof IFile) {
            graphicalInfoFile = (IFile)resource;
        }
        deploymentInfo.setGraphicalInfoFile(graphicalInfoFile);
    }

    protected void processImageFile(DeploymentInfo deploymentInfo, Element deploymentElement, IFileEditorInput editorInput) {
        IResource resource;
        if (deploymentElement == null) {
            return;
        }
        Attribute attribute = deploymentElement.attribute("imageFile");
        IFile imageFile = null;
        if (attribute != null && attribute.getValue() != null && (resource = editorInput.getFile().getWorkspace().getRoot().findMember((IPath)new Path(attribute.getValue()))) instanceof IFile) {
            imageFile = (IFile)resource;
        }
        deploymentInfo.setImageFile(imageFile);
    }

    protected void processClassesAndResources(DeploymentInfo deploymentInfo, Element deploymentElement, IFileEditorInput editorInput) {
        if (deploymentElement == null) {
            return;
        }
        Element classesAndResourcesElement = deploymentElement.element("classesAndResources");
        if (classesAndResourcesElement == null) {
            return;
        }
        List elements = classesAndResourcesElement.elements("element");
        int i = 0;
        while (i < elements.size()) {
            IResource resource;
            Element element = (Element)elements.get(i);
            String type = element.attributeValue("type");
            String value = element.attributeValue("value");
            if ("java".equals(type)) {
                IJavaElement javaElement;
                resource = editorInput.getFile().getWorkspace().getRoot().findMember((IPath)new Path(value));
                if (resource instanceof IFile && (javaElement = JavaCore.create((IFile)((IFile)resource))) instanceof ICompilationUnit) {
                    deploymentInfo.addToClassesAndResources(javaElement);
                }
            } else if ("class".equals(type)) {
                IJavaElement javaElement = JavaCore.create((String)value);
                if (javaElement instanceof IClassFile) {
                    deploymentInfo.addToClassesAndResources(javaElement);
                }
            } else if ("file".equals(type) && (resource = editorInput.getFile().getWorkspace().getRoot().findMember((IPath)new Path(value))) instanceof IFile) {
                deploymentInfo.addToClassesAndResources(resource);
            }
            ++i;
        }
    }

    protected void processAdditionalFiles(DeploymentInfo deploymentInfo, Element deploymentElement, IFileEditorInput editorInput) {
        if (deploymentElement == null) {
            return;
        }
        Element additionalFilesElement = deploymentElement.element("additionalFiles");
        if (additionalFilesElement == null) {
            additionalFilesElement = deploymentElement.element("filesAndFolders");
        }
        if (additionalFilesElement == null) {
            return;
        }
        List elements = additionalFilesElement.elements("element");
        int i = 0;
        while (i < elements.size()) {
            String value = ((Element)elements.get(i)).attributeValue("value");
            IResource resource = editorInput.getFile().getWorkspace().getRoot().findMember((IPath)new Path(value));
            if (resource instanceof IFile) {
                deploymentInfo.addToAdditionalFiles(resource);
            }
            ++i;
        }
    }
}

