/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.editor;

import org.eclipse.core.runtime.IPath;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.jbpm.gd.common.editor.ContentProvider;
import org.jbpm.gd.common.editor.Editor;
import org.jbpm.gd.common.editor.GraphicalViewer;
import org.jbpm.gd.common.editor.OutlineViewer;
import org.jbpm.gd.common.editor.SelectionSynchronizer;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.deployment.DeploymentInfo;
import org.jbpm.gd.jpdl.editor.JpdlContentProvider;
import org.jbpm.gd.jpdl.editor.JpdlDeploymenEditorPage;
import org.jbpm.gd.jpdl.editor.JpdlSelectionSynchronizer;
import org.jbpm.gd.jpdl.model.ProcessDefinition;
import org.jbpm.gd.jpdl.part.JpdlEditorOutlineEditPartFactory;
import org.jbpm.gd.jpdl.part.JpdlGraphicalEditPartFactory;

public class JpdlEditor
extends Editor {
    private JpdlDeploymenEditorPage deploymentInfoEditorPage;
    private DeploymentInfo deploymentInfo;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.initPartName();
    }

    private void initPartName() {
        String fileName;
        FileEditorInput fileInput = (FileEditorInput)this.getEditorInput();
        String processName = fileName = fileInput.getFile().getName();
        if ("processdefinition.xml".equals(fileName)) {
            IPath path = fileInput.getPath().removeLastSegments(1);
            path = path.removeFirstSegments(path.segmentCount() - 1);
            processName = path.lastSegment();
        } else if (fileName.endsWith(".jpdl.xml")) {
            int index = fileName.indexOf(".jpdl.xml");
            processName = fileName.substring(0, index);
        }
        this.setPartName(processName);
    }

    protected SelectionSynchronizer createSelectionSynchronizer() {
        return new JpdlSelectionSynchronizer();
    }

    protected ContentProvider createContentProvider() {
        return new JpdlContentProvider(this);
    }

    protected GraphicalViewer createGraphicalViewer() {
        return new GraphicalViewer(this){

            protected void initEditPartFactory() {
                this.setEditPartFactory(new JpdlGraphicalEditPartFactory());
            }
        };
    }

    protected OutlineViewer createOutlineViewer() {
        return new OutlineViewer(this){

            protected void initEditPartFactory() {
                this.getViewer().setEditPartFactory((EditPartFactory)new JpdlEditorOutlineEditPartFactory());
            }
        };
    }

    protected void createPages() {
        super.createPages();
        this.initDeploymentInfoPage();
    }

    protected void initDeploymentInfoPage() {
        ((JpdlContentProvider)this.getContentProvider()).initializeDeploymentInfo(this.getDeploymentInfo(), this.getEditorInput());
        this.deploymentInfoEditorPage = new JpdlDeploymenEditorPage(this);
        this.addPage(1, (IEditorPart)this.deploymentInfoEditorPage, "Deployment");
    }

    protected SemanticElement createMainElement() {
        return this.getSemanticElementFactory().createById("org.jbpm.gd.jpdl.processDefinition");
    }

    public ProcessDefinition getProcessDefinition() {
        return (ProcessDefinition)this.getRootContainer().getSemanticElement();
    }

    public DeploymentInfo getDeploymentInfo() {
        if (this.deploymentInfo == null) {
            this.deploymentInfo = new DeploymentInfo();
        }
        return this.deploymentInfo;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty() || super.isSaveOnCloseNeeded();
    }
}

