/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.notation;

import java.beans.PropertyChangeEvent;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NodeContainer;
import org.jbpm.gd.common.notation.RootContainer;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.ProcessDefinition;

public class JpdlEdge
extends Edge {
    private RootContainer getRootContainer() {
        Node source = this.getSource();
        if (source == null) {
            return null;
        }
        NodeContainer container = source.getContainer();
        while (container != null && container instanceof Node) {
            container = ((Node)((Object)container)).getContainer();
        }
        return (RootContainer)container;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String eventName = evt.getPropertyName();
        if (eventName.equals("to")) {
            Node targetNode;
            Node oldTargetNode;
            if (this.getSource() == null) {
                return;
            }
            RootContainer rootContainer = this.getRootContainer();
            if (rootContainer == null) {
                return;
            }
            ProcessDefinition processDefinition = (ProcessDefinition)rootContainer.getSemanticElement();
            if (processDefinition == null) {
                return;
            }
            NodeElement newTarget = processDefinition.getNodeElementByName((String)evt.getNewValue());
            NodeElement oldTarget = processDefinition.getNodeElementByName((String)evt.getOldValue());
            if (oldTarget != null && (oldTargetNode = (Node)this.getRegisteredNotationElementFor(oldTarget)) != null) {
                oldTargetNode.removeArrivingEdge(this);
            }
            if (newTarget != null && (targetNode = (Node)this.getRegisteredNotationElementFor(newTarget)) != null) {
                targetNode.addArrivingEdge(this);
            }
            this.getSource().propertyChange(new PropertyChangeEvent(this, "leavingEdgeRefresh", null, null));
        } else {
            super.propertyChange(evt);
        }
    }
}

