/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.notation;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jbpm.gd.common.editor.CreationFactory;
import org.jbpm.gd.common.model.NamedElement;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.AbstractNodeContainer;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

public class JpdlNodeContainer
extends AbstractNodeContainer {
    public void propertyChange(PropertyChangeEvent evt) {
        String eventName = evt.getPropertyName();
        if (eventName.equals("name")) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            this.updateArrivingEdges((String)evt.getNewValue());
        } else if (eventName.equals("nodeElementAdd")) {
            SemanticElement jpdlElement = (SemanticElement)evt.getNewValue();
            AbstractNotationElement notationElement = this.getRegisteredNotationElementFor(jpdlElement);
            if (notationElement == null) {
                CreationFactory factory = new CreationFactory(jpdlElement, this.getFactory());
                notationElement = (AbstractNotationElement)factory.getNewObject();
            }
            this.addNode((Node)notationElement);
            jpdlElement.addPropertyChangeListener(notationElement);
        } else if (eventName.equals("nodeElementRemove")) {
            SemanticElement jpdlElement = (SemanticElement)evt.getOldValue();
            AbstractNotationElement notationElement = this.getRegisteredNotationElementFor(jpdlElement);
            if (notationElement != null) {
                jpdlElement.removePropertyChangeListener(notationElement);
                this.removeNode((Node)notationElement);
            }
        } else if (eventName.equals("transitionAdd")) {
            Transition transition = (Transition)evt.getNewValue();
            Edge edge = (Edge)this.getRegisteredNotationElementFor(transition);
            if (edge == null) {
                CreationFactory factory = new CreationFactory(transition, this.getFactory());
                edge = (Edge)factory.getNewObject();
            }
            this.addLeavingEdge(edge);
            transition.addPropertyChangeListener(edge);
            Node targetNode = this.getDestinationNode(transition.getTo());
            if (targetNode != null) {
                targetNode.addArrivingEdge(edge);
            }
        } else if (eventName.equals("transitionRemove")) {
            Transition transition = (Transition)evt.getOldValue();
            Edge edge = (Edge)this.getRegisteredNotationElementFor(transition);
            if (edge != null) {
                Node targetNode = edge.getTarget();
                if (targetNode != null) {
                    transition.removePropertyChangeListener(edge);
                    targetNode.removeArrivingEdge(edge);
                }
                this.removeLeavingEdge(edge);
            }
        } else {
            super.propertyChange(evt);
        }
    }

    private Node getDestinationNode(String to) {
        NotationElement runner = this.getContainer();
        SemanticElement jpdlElement = null;
        StringTokenizer tokenizer = new StringTokenizer(to, "/");
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if ("..".equals(nextToken)) {
                if (runner != null && runner instanceof Node) {
                    runner = ((Node)runner).getContainer();
                    continue;
                }
                runner = null;
                break;
            }
            if (jpdlElement == null) {
                jpdlElement = runner.getSemanticElement();
            }
            if (jpdlElement instanceof NodeElementContainer) {
                jpdlElement = ((NodeElementContainer)jpdlElement).getNodeElementByName(nextToken);
                runner = (Node)this.getRegisteredNotationElementFor(jpdlElement);
                continue;
            }
            runner = null;
            break;
        }
        return (Node)runner;
    }

    protected void addArrivingEdges(Node node) {
        ArrayList<Edge> list = new ArrayList<Edge>(this.danglingEdges);
        int i = 0;
        while (i < this.danglingEdges.size()) {
            Edge edge;
            String to;
            String name = ((NamedElement)node.getSemanticElement()).getName();
            if (name.equals(to = ((Transition)(edge = (Edge)this.danglingEdges.get(i)).getSemanticElement()).getTo())) {
                list.add(edge);
                node.addArrivingEdge(edge);
            }
            ++i;
        }
        this.danglingEdges.removeAll(list);
    }

    private void updateArrivingEdges(String to) {
        List edges = this.getArrivingEdges();
        int i = 0;
        while (i < edges.size()) {
            Edge edge = (Edge)edges.get(i);
            edge.getSemanticElement().removePropertyChangeListener(edge);
            ((Transition)edge.getSemanticElement()).setTo(to);
            edge.getSemanticElement().addPropertyChangeListener(edge);
            ++i;
        }
    }
}

