/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.prefs;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jbpm.gd.jpdl.Plugin;
import org.jbpm.gd.jpdl.prefs.PreferencesConstants;

public class ServerDeploymentPage
extends PreferencePage
implements IWorkbenchPreferencePage,
PreferencesConstants {
    private Text nameText;
    private Text portText;
    private Text deployerText;
    private Text usernameText;
    private Text passwordText;
    private Button useCredentialsCheckbox;

    public ServerDeploymentPage() {
        this.setPreferenceStore(Plugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite clientArea = this.createClientArea(parent);
        this.createServerNameField(clientArea);
        this.createServerPortField(clientArea);
        this.createServerDeployerField(clientArea);
        this.createServerCredentialsCheckBox(clientArea);
        this.createServerCredentialsGroup(clientArea);
        return null;
    }

    private void createServerCredentialsGroup(Composite parent) {
        Group serverCredentialsGroup = new Group(parent, 2048);
        serverCredentialsGroup.setLayout((Layout)new GridLayout(2, false));
        this.createUserNameField((Composite)serverCredentialsGroup);
        this.createUserPasswordField((Composite)serverCredentialsGroup);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        serverCredentialsGroup.setLayoutData((Object)data);
    }

    private void createUserNameField(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText("Username:");
        String username = this.getPreferenceStore().getString("user name");
        this.usernameText = new Text(parent, 2048);
        this.usernameText.setLayoutData((Object)new GridData(768));
        this.usernameText.setText(this.useCredentialsCheckbox.getSelection() ? username : "");
    }

    private void createUserPasswordField(Composite parent) {
        Label passwordLabel = new Label(parent, 0);
        passwordLabel.setText("Password:");
        String password = this.getPreferenceStore().getString("password");
        this.passwordText = new Text(parent, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(768));
        this.passwordText.setText(this.useCredentialsCheckbox.getSelection() ? password : "");
    }

    private void createServerCredentialsCheckBox(Composite parent) {
        this.useCredentialsCheckbox = new Button(parent, 32);
        this.useCredentialsCheckbox.setText("Use credentials");
        this.useCredentialsCheckbox.setSelection(this.getPreferenceStore().getBoolean("use credentials"));
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.useCredentialsCheckbox.setLayoutData((Object)data);
        this.useCredentialsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerDeploymentPage.this.usernameText.setEnabled(ServerDeploymentPage.this.useCredentialsCheckbox.getSelection());
                ServerDeploymentPage.this.passwordText.setEnabled(ServerDeploymentPage.this.useCredentialsCheckbox.getSelection());
            }
        });
    }

    private void createServerNameField(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText("Server name:");
        this.nameText = new Text(parent, 2048);
        String serverName = this.getPreferenceStore().getString("server name");
        this.nameText.setText(serverName == null || "".equals(serverName) ? "localhost" : serverName);
        this.nameText.setLayoutData((Object)new GridData(768));
    }

    private void createServerPortField(Composite parent) {
        Label portLabel = new Label(parent, 0);
        portLabel.setText("Server port:");
        this.portText = new Text(parent, 2048);
        String serverPort = this.getPreferenceStore().getString("server port");
        this.portText.setText(serverPort == null || "".equals(serverPort) ? "8080" : serverPort);
        this.portText.setLayoutData((Object)new GridData(768));
    }

    private void createServerDeployerField(Composite parent) {
        Label deployerLabel = new Label(parent, 0);
        deployerLabel.setText("Server deployer:");
        this.deployerText = new Text(parent, 2048);
        String serverDeployer = this.getPreferenceStore().getString("server deployer");
        this.deployerText.setText(serverDeployer == null || "".equals(serverDeployer) ? "/jbpm-console/upload" : serverDeployer);
        this.deployerText.setLayoutData((Object)new GridData(768));
    }

    private Composite createClientArea(Composite parent) {
        Composite clientArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        clientArea.setLayoutData((Object)gridData);
        return clientArea;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("server name", this.nameText.getText());
        this.getPreferenceStore().setValue("server port", this.portText.getText());
        this.getPreferenceStore().setValue("server deployer", this.deployerText.getText());
        this.getPreferenceStore().setValue("use credentials", this.useCredentialsCheckbox.getSelection());
        this.getPreferenceStore().setValue("user name", this.useCredentialsCheckbox.getSelection() ? this.usernameText.getText() : "");
        this.getPreferenceStore().setValue("password", this.useCredentialsCheckbox.getSelection() ? this.passwordText.getText() : "");
        return true;
    }

    public void performDefaults() {
        this.nameText.setText("localhost");
        this.portText.setText("8080");
        this.deployerText.setText("jbpm-console/upload");
        this.useCredentialsCheckbox.setSelection(false);
        this.usernameText.setText(null);
        this.passwordText.setText(null);
        this.getPreferenceStore().setValue("server name", "localhost");
        this.getPreferenceStore().setValue("server port", "8080");
        this.getPreferenceStore().setValue("server deployer", "/jbpm-console/upload");
        this.getPreferenceStore().setValue("use credentials", false);
        this.getPreferenceStore().setValue("user name", "");
        this.getPreferenceStore().setValue("password", "");
    }
}

