/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;
import org.jbpm.gd.common.properties.AbstractPropertySection;
import org.jbpm.gd.common.util.SharedImages;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.ActionElementContainer;
import org.jbpm.gd.jpdl.model.CancelTimer;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.model.EsbElement;
import org.jbpm.gd.jpdl.model.EsbNotifier;
import org.jbpm.gd.jpdl.model.MailAction;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.properties.ActionConfigurationComposite;
import org.jbpm.gd.jpdl.properties.ActionElementContainerSectionActionBarContributor;
import org.jbpm.gd.jpdl.properties.CancelTimerConfigurationComposite;
import org.jbpm.gd.jpdl.properties.EsbConfigurationComposite;
import org.jbpm.gd.jpdl.properties.MailActionConfigurationComposite;
import org.jbpm.gd.jpdl.properties.ScriptConfigurationComposite;
import org.jbpm.gd.jpdl.properties.TimerConfigurationComposite;

public class ActionElementContainerSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private ActionElementContainer actionElementContainer;
    private ActionElement selectedActionElement;
    private ActionElementContainerSectionActionBarContributor actionBarContributor;
    private Table actionElementTable;
    private HashMap detailsPages = new HashMap();
    private ActionConfigurationComposite actionConfigurationComposite;
    private ScriptConfigurationComposite scriptConfigurationComposite;
    private TimerConfigurationComposite createTimerConfigurationComposite;
    private CancelTimerConfigurationComposite cancelTimerConfigurationComposite;
    private MailActionConfigurationComposite mailActionConfigurationComposite;
    private EsbConfigurationComposite esbConfigurationComposite;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.actionBarContributor = new ActionElementContainerSectionActionBarContributor(this);
        this.tabbedPropertySheetPage = aTabbedPropertySheetPage;
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.createMasterArea(composite);
        this.createDetailsArea(composite);
    }

    private void createMasterArea(Composite composite) {
        this.actionElementTable = this.getWidgetFactory().createTable(composite, 68356);
        this.actionElementTable.setLayoutData((Object)this.createActionElementTableLayoutData());
        this.actionElementTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionElementContainerSection.this.handleActionTableSelected();
            }
        });
        this.actionBarContributor.createPopupMenu((Composite)this.actionElementTable);
    }

    private void createDetailsArea(Composite composite) {
        this.createActionPage(composite);
        this.createScriptPage(composite);
        this.createCreateTimerPage(composite);
        this.createCancelTimerPage(composite);
        this.createMailPage(composite);
        this.createEsbPage(composite);
    }

    private void createActionPage(Composite composite) {
        Composite actionPage = this.getWidgetFactory().createComposite(composite);
        actionPage.setLayout((Layout)new FormLayout());
        actionPage.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.detailsPages.put("org.jbpm.gd.jpdl.action", actionPage);
        this.actionConfigurationComposite = ActionConfigurationComposite.create(this.getWidgetFactory(), actionPage);
    }

    private void createScriptPage(Composite composite) {
        Composite scriptPage = this.getWidgetFactory().createComposite(composite);
        scriptPage.setLayout((Layout)new FormLayout());
        scriptPage.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.detailsPages.put("org.jbpm.gd.jpdl.script", scriptPage);
        this.scriptConfigurationComposite = ScriptConfigurationComposite.create(this.getWidgetFactory(), scriptPage);
    }

    private void createCreateTimerPage(Composite composite) {
        Composite createTimerPage = this.getWidgetFactory().createComposite(composite);
        createTimerPage.setLayout((Layout)new FormLayout());
        createTimerPage.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.detailsPages.put("org.jbpm.gd.jpdl.createTimer", createTimerPage);
        this.createTimerConfigurationComposite = TimerConfigurationComposite.create(this.getWidgetFactory(), createTimerPage);
    }

    private void createCancelTimerPage(Composite composite) {
        Composite cancelTimerPage = this.getWidgetFactory().createComposite(composite);
        cancelTimerPage.setLayout((Layout)new FormLayout());
        cancelTimerPage.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.detailsPages.put("org.jbpm.gd.jpdl.cancelTimer", cancelTimerPage);
        this.cancelTimerConfigurationComposite = CancelTimerConfigurationComposite.create(this.getWidgetFactory(), cancelTimerPage);
    }

    private void createMailPage(Composite composite) {
        Composite mailPage = this.getWidgetFactory().createComposite(composite);
        mailPage.setLayout((Layout)new FormLayout());
        mailPage.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.detailsPages.put("org.jbpm.gd.jpdl.mail", mailPage);
        this.mailActionConfigurationComposite = MailActionConfigurationComposite.create(this.getWidgetFactory(), mailPage);
    }

    private void createEsbPage(Composite composite) {
        Composite esbPage = this.getWidgetFactory().createComposite(composite);
        esbPage.setLayout((Layout)new FormLayout());
        esbPage.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.detailsPages.put("org.jbpm.gd.jpdl.esbNotifier", esbPage);
        this.esbConfigurationComposite = EsbConfigurationComposite.create(this.getWidgetFactory(), esbPage);
    }

    private void handleActionTableSelected() {
        TableItem[] selectedItems = this.actionElementTable.getSelection();
        if (selectedItems.length == 0) {
            this.unSelectAll();
        } else {
            this.selectActionElement((ActionElement)selectedItems[0].getData());
        }
        this.updateDetailsArea();
    }

    private void updateDetailsArea() {
        String key = this.getSelectedKey();
        for (String candidate : this.detailsPages.keySet()) {
            ((Composite)this.detailsPages.get(candidate)).setVisible(candidate.equals(key));
        }
    }

    private String getSelectedKey() {
        String result = null;
        if (this.selectedActionElement != null) {
            result = this.selectedActionElement.getElementId();
        }
        return result;
    }

    private void clearControls() {
        this.actionElementTable.removeAll();
        Iterator iter = this.detailsPages.values().iterator();
        while (iter.hasNext()) {
            ((Composite)iter.next()).setVisible(false);
        }
    }

    private void selectActionElement(ActionElement actionElement) {
        if (actionElement == this.getSelectedActionElement()) {
            return;
        }
        this.actionBarContributor.setRemoveEnabled(actionElement != null);
        if (this.selectedActionElement != null) {
            this.selectedActionElement.removePropertyChangeListener(this);
        }
        this.selectedActionElement = actionElement;
        this.updateActionElementDetails();
        if (actionElement != null) {
            actionElement.addPropertyChangeListener(this);
        }
    }

    private void updateActionElementDetails() {
        if (this.selectedActionElement instanceof EsbNotifier) {
            this.esbConfigurationComposite.setEsbElement((EsbElement)((Object)this.selectedActionElement));
        } else if (this.selectedActionElement instanceof Action) {
            this.actionConfigurationComposite.setAction((Action)this.selectedActionElement);
        } else if (this.selectedActionElement instanceof Script) {
            this.scriptConfigurationComposite.setScript((Script)this.selectedActionElement);
        } else if (this.selectedActionElement instanceof CreateTimer) {
            this.createTimerConfigurationComposite.setTimer((CreateTimer)this.selectedActionElement);
        } else if (this.selectedActionElement instanceof CancelTimer) {
            this.cancelTimerConfigurationComposite.setCancelTimer((CancelTimer)this.selectedActionElement);
        } else if (this.selectedActionElement instanceof MailAction) {
            this.mailActionConfigurationComposite.setMailAction((MailAction)this.selectedActionElement);
        }
    }

    private FormData createActionElementTableLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(20, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    private FormData createDetailsAreaLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.actionElementTable, 0);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
            AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
            this.setActionElementContainer((ActionElementContainer)notationElement.getSemanticElement());
        } else if (input instanceof OutlineEditPart) {
            this.setActionElementContainer((ActionElementContainer)((OutlineEditPart)input).getModel());
        }
    }

    private void setActionElementContainer(ActionElementContainer newActionElementContainer) {
        if (this.actionElementContainer == newActionElementContainer) {
            return;
        }
        if (this.actionElementContainer != null) {
            this.actionElementContainer.removePropertyChangeListener(this);
        }
        this.clearControls();
        this.actionElementContainer = newActionElementContainer;
        if (this.actionElementContainer != null) {
            this.updateActionElementTable();
            this.actionElementContainer.addPropertyChangeListener(this);
        }
    }

    private void unSelectAll() {
        if (this.somethingSelected()) {
            this.selectActionElement(null);
        }
    }

    private boolean somethingSelected() {
        return this.getSelectedActionElement() != null;
    }

    private void updateActionElementTable() {
        ActionElement[] actionElements = this.actionElementContainer.getActionElements();
        int i = 0;
        while (i < actionElements.length) {
            TableItem tableItem = new TableItem(this.actionElementTable, 0);
            tableItem.setText(this.getLabel(actionElements[i]));
            tableItem.setData((Object)actionElements[i]);
            tableItem.setImage(SharedImages.INSTANCE.getImage(actionElements[i].getIconDescriptor()));
            ++i;
        }
    }

    private String getLabel(ActionElement actionElement) {
        String refName;
        String result = actionElement.getName();
        if (result != null && !"".equals(result)) {
            return result;
        }
        if (actionElement instanceof Action && (refName = ((Action)actionElement).getRefName()) != null && !"".equals(refName)) {
            return refName;
        }
        result = actionElement.getLabel();
        return result != null ? result.toLowerCase() : actionElement.getElementId();
    }

    public TabbedPropertySheetPage getTabbedPropertySheetPage() {
        return this.tabbedPropertySheetPage;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.actionElementTable.isDisposed()) {
            return;
        }
        if ("actionElementAdd".equals(evt.getPropertyName())) {
            TableItem tableItem = new TableItem(this.actionElementTable, 0);
            ActionElement actionElement = (ActionElement)evt.getNewValue();
            tableItem.setText(this.getLabel(actionElement));
            tableItem.setData((Object)actionElement);
            tableItem.setImage(SharedImages.INSTANCE.getImage(actionElement.getIconDescriptor()));
            this.actionElementTable.setSelection(tableItem);
            this.actionElementTable.notifyListeners(13, new Event());
        } else if ("actionElementRemove".equals(evt.getPropertyName())) {
            TableItem tableItem = this.getItemToRemove(evt.getOldValue());
            if (tableItem != null) {
                tableItem.dispose();
                this.actionElementTable.notifyListeners(13, new Event());
            }
        } else if ("name".equals(evt.getPropertyName()) || "refName".equals(evt.getPropertyName())) {
            if (this.actionElementTable.getSelectionCount() != 1) {
                return;
            }
            TableItem tableItem = this.actionElementTable.getSelection()[0];
            if (tableItem.getData() == evt.getSource()) {
                tableItem.setText(this.getLabel((ActionElement)tableItem.getData()));
            }
        }
    }

    private TableItem getItemToRemove(Object object) {
        int i = 0;
        while (i < this.actionElementTable.getItemCount()) {
            if (this.actionElementTable.getItem(i).getData() == object) {
                return this.actionElementTable.getItem(i);
            }
            ++i;
        }
        return null;
    }

    public ActionElement getSelectedActionElement() {
        return this.selectedActionElement;
    }

    public void aboutToBeShown() {
        this.actionBarContributor.activateContributions();
    }

    public void aboutToBeHidden() {
        this.actionBarContributor.deactivateContributions();
    }

    public ActionElementContainer getActionElementContainer() {
        return this.actionElementContainer;
    }
}

