/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Action;

public class ActionNameConfigurationComposite
implements SelectionListener,
FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Label nameLabel;
    private Text nameText;
    private Button referenceButton;
    private Action action;

    public static ActionNameConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        ActionNameConfigurationComposite result = new ActionNameConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private ActionNameConfigurationComposite() {
    }

    public void setAction(Action action) {
        if (this.action == action) {
            return;
        }
        this.unhookSelectionListener();
        this.clearControls();
        this.action = action;
        if (action != null) {
            this.updateControls();
            this.hookSelectionListener();
        }
    }

    private void hookSelectionListener() {
        this.nameText.addFocusListener((FocusListener)this);
        this.referenceButton.addSelectionListener((SelectionListener)this);
    }

    private void unhookSelectionListener() {
        this.nameText.removeFocusListener((FocusListener)this);
        this.referenceButton.removeSelectionListener((SelectionListener)this);
    }

    private void clearControls() {
        this.nameText.setText("");
        this.referenceButton.setSelection(false);
    }

    private void updateControls() {
        String name = this.action.getRefName();
        if (name != null) {
            this.referenceButton.setSelection(true);
        } else {
            this.referenceButton.setSelection(false);
            name = this.action.getName();
        }
        this.nameText.setText(name == null ? "" : name);
    }

    private void create() {
        this.nameLabel = this.widgetFactory.createLabel(this.parent, "Name");
        this.nameText = this.widgetFactory.createText(this.parent, "");
        this.referenceButton = this.widgetFactory.createButton(this.parent, "Reference", 32);
        this.nameLabel.setLayoutData((Object)this.createNameLabelLayoutData());
        this.nameText.setLayoutData((Object)this.createNameTextLayoutData());
        this.referenceButton.setLayoutData((Object)this.createReferenceButtonLayoutData());
    }

    private FormData createNameTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.top = new FormAttachment(0, 5);
        data.right = new FormAttachment((Control)this.referenceButton, 0);
        return data;
    }

    private FormData createNameLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 7);
        return data;
    }

    private FormData createReferenceButtonLayoutData() {
        FormData data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 7);
        return data;
    }

    private String getNameText() {
        String text = this.nameText.getText();
        if ("".equals(text)) {
            text = null;
        }
        return text;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.referenceButton) {
            this.updateActionName();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.nameText) {
            this.updateActionName();
        }
    }

    private void updateActionName() {
        if (this.referenceButton.getSelection()) {
            this.action.setRefName(this.getNameText());
            this.action.setName(null);
        } else {
            this.action.setName(this.getNameText());
            this.action.setRefName(null);
        }
    }
}

