/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;
import org.jbpm.gd.common.properties.AbstractPropertySection;
import org.jbpm.gd.jpdl.Plugin;
import org.jbpm.gd.jpdl.model.Condition;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.Transition;

public class ConditionSection
extends AbstractPropertySection
implements SelectionListener,
FocusListener {
    private Label conditionLabel;
    private CCombo conditionCombo;
    private Label label;
    private Text expressionText;
    private Text scriptText;
    private Transition transition;
    private static final String CONDITION_ON_TRANSITION_WARNING = "Invalid condition: transitions with conditions only valid if the source node is a decision!";
    private Label warningLabel;
    private Boolean hideTransitionConditionWarnings;
    IPropertyChangeListener preferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("transition condition warn")) {
                ConditionSection.this.hideTransitionConditionWarnings = null;
            }
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite clientArea = this.getWidgetFactory().createFlatFormComposite(parent);
        this.warningLabel = this.getWidgetFactory().createLabel(clientArea, "");
        this.warningLabel.setForeground(ColorConstants.red);
        this.conditionLabel = this.getWidgetFactory().createLabel(clientArea, "Condition Type");
        this.conditionCombo = this.getWidgetFactory().createCCombo(clientArea);
        this.conditionCombo.setEditable(false);
        this.label = this.getWidgetFactory().createLabel(clientArea, "");
        this.expressionText = this.getWidgetFactory().createText(clientArea, "");
        this.scriptText = this.getWidgetFactory().createText(clientArea, "", 768);
        this.warningLabel.setLayoutData((Object)this.createWarningLabelLayoutData());
        this.conditionLabel.setLayoutData((Object)this.createConditionLabelLayoutData());
        this.conditionCombo.setLayoutData((Object)this.createConditionComboLayoutData());
        this.label.setLayoutData((Object)this.createLabelLayoutData());
        this.expressionText.setLayoutData((Object)this.createExpressionTextLayoutData());
        this.scriptText.setLayoutData((Object)this.createScriptTextLayoutData());
        this.hookListeners();
        this.refresh();
    }

    private void hookListeners() {
        this.conditionCombo.addSelectionListener((SelectionListener)this);
        this.expressionText.addSelectionListener((SelectionListener)this);
        this.expressionText.addFocusListener((FocusListener)this);
        this.scriptText.addSelectionListener((SelectionListener)this);
        this.scriptText.addFocusListener((FocusListener)this);
        Plugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferenceListener);
    }

    public void dispose() {
        Plugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
        super.dispose();
    }

    private void updateConditionCombo() {
        if (this.transition == null) {
            this.conditionCombo.setItems(new String[]{"Unconditional"});
        } else if (this.getHideTransitionConditionWarning().booleanValue()) {
            this.conditionCombo.setItems(new String[]{"Unconditional", "Expression", "Script"});
        } else if (this.transition.getSource() instanceof Decision) {
            this.conditionCombo.setItems(new String[]{"Unconditional", "Expression", "Script"});
        } else if (this.transition.getCondition() != null) {
            if (this.transition.getCondition().getExpression() != null) {
                this.conditionCombo.setItems(new String[]{"Unconditional", "Expression"});
            } else if (this.transition.getCondition().getScript() != null) {
                this.conditionCombo.setItems(new String[]{"Unconditional", "Script"});
            }
        } else {
            this.conditionCombo.setItems(new String[]{"Unconditional"});
        }
    }

    private void updateWarningLabel() {
        if (this.getHideTransitionConditionWarning().booleanValue()) {
            this.warningLabel.setText("");
        } else if (this.transition == null || this.transition.getCondition() == null || this.transition.getSource() == null || this.transition.getSource() instanceof Decision) {
            this.warningLabel.setText("");
        } else if (this.transition.getCondition() != null && !(this.transition.getSource() instanceof Decision)) {
            this.warningLabel.setText(CONDITION_ON_TRANSITION_WARNING);
        } else {
            this.warningLabel.setText("");
        }
    }

    private FormData createWarningLabelLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 5);
        result.right = new FormAttachment(100, -5);
        result.top = new FormAttachment((Control)this.conditionCombo, 10);
        return result;
    }

    private FormData createConditionLabelLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 5);
        result.top = new FormAttachment(0, 5);
        return result;
    }

    private FormData createConditionComboLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment((Control)this.conditionLabel, 5);
        result.top = new FormAttachment(0, 5);
        return result;
    }

    private FormData createLabelLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 5);
        result.right = new FormAttachment(100, -5);
        result.top = new FormAttachment((Control)this.warningLabel, 10);
        return result;
    }

    private FormData createExpressionTextLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 5);
        result.right = new FormAttachment(100, -5);
        result.top = new FormAttachment((Control)this.label, 0);
        return result;
    }

    private FormData createScriptTextLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 5);
        result.right = new FormAttachment(100, -5);
        result.top = new FormAttachment((Control)this.label, 0);
        result.height = 100;
        return result;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
            AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
            input = notationElement.getSemanticElement();
        } else if (input instanceof OutlineEditPart) {
            input = ((OutlineEditPart)input).getModel();
        }
        if (input instanceof Transition) {
            this.transition = (Transition)input;
            this.refresh();
        }
    }

    public void refresh() {
        this.updateConditionCombo();
        this.updateWarningLabel();
        if (this.transition == null || this.transition.getCondition() == null) {
            this.conditionCombo.setText("Unconditional");
            this.label.setText("");
            this.expressionText.setText("");
            this.expressionText.setVisible(false);
            this.scriptText.setText("");
            this.scriptText.setVisible(false);
        } else {
            Condition condition = this.transition.getCondition();
            if (condition != null && condition.getExpression() != null) {
                this.conditionCombo.setText("Expression");
                this.label.setText("Condition");
                this.expressionText.setText(condition.getExpression());
                this.expressionText.setVisible(true);
                this.scriptText.setText("");
                this.scriptText.setVisible(false);
            } else if (condition != null && condition.getScript() != null) {
                this.conditionCombo.setText("Script");
                this.label.setText("Script");
                this.scriptText.setText(condition.getScript());
                this.scriptText.setVisible(true);
                this.expressionText.setText("");
                this.expressionText.setVisible(false);
            } else {
                this.conditionCombo.setText("Unknown");
                this.label.setText("");
                this.expressionText.setVisible(false);
                this.scriptText.setVisible(false);
            }
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.expressionText) {
            this.handleExpressionTextChanged();
        } else if (e.widget == this.scriptText) {
            this.handleScriptTextChanged();
        }
    }

    private void handleExpressionTextChanged() {
        if (this.transition != null && this.transition.getCondition() != null) {
            this.transition.getCondition().setExpression(this.expressionText.getText());
        }
    }

    private void handleScriptTextChanged() {
        if (this.transition != null && this.transition.getCondition() != null) {
            this.transition.getCondition().setScript(this.scriptText.getText());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.conditionCombo) {
            this.handleConditionComboSelected();
        }
    }

    private void handleConditionComboSelected() {
        if ("Expression".equals(this.conditionCombo.getText())) {
            this.updateWarningLabel();
            this.label.setText("Expression");
            this.scriptText.setVisible(false);
            this.expressionText.setVisible(true);
            if (this.transition != null) {
                this.updateCondition();
            }
        } else if ("Script".equals(this.conditionCombo.getText())) {
            this.updateWarningLabel();
            this.label.setText("Script");
            this.expressionText.setVisible(false);
            this.scriptText.setVisible(true);
            if (this.transition != null) {
                this.updateCondition();
            }
        } else {
            this.warningLabel.setText("");
            this.label.setText("");
            this.expressionText.setVisible(false);
            this.scriptText.setVisible(false);
            if (this.transition != null) {
                this.transition.setCondition(null);
            }
        }
    }

    private void updateCondition() {
        Condition condition = this.transition.getCondition();
        if (condition == null) {
            condition = (Condition)this.transition.getFactory().createById("org.jbpm.gd.jpdl.condition");
            this.transition.setCondition(condition);
        }
        if ("Expression".equals(this.conditionCombo.getText())) {
            condition.setScript(null);
            condition.setExpression(this.expressionText.getText());
        } else if ("Script".equals(this.conditionCombo.getText())) {
            condition.setExpression(null);
            condition.setScript(this.scriptText.getText());
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.expressionText) {
            this.handleExpressionTextChanged();
        } else if (e.widget == this.scriptText) {
            this.handleScriptTextChanged();
        }
    }

    private Boolean getHideTransitionConditionWarning() {
        if (this.hideTransitionConditionWarnings == null) {
            this.hideTransitionConditionWarnings = Plugin.getDefault().getPreferenceStore().getBoolean("transition condition warn");
        }
        return this.hideTransitionConditionWarnings;
    }
}

