/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.dialog.ChooseDelegationClassDialog;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.Handler;
import org.jbpm.gd.jpdl.properties.DelegationConfigurationComposite;

public class DecisionConfigurationComposite
implements SelectionListener,
FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Decision decision;
    private Label decisionConfigurationTypeLabel;
    private CCombo decisionConfigurationTypeCombo;
    private Composite delegationComposite;
    private DelegationConfigurationComposite delegationConfigurationComposite;
    private Composite expressionComposite;
    private Label expressionLabel;
    private Text expressionText;
    private String selectedDecisionType;

    public static DecisionConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        DecisionConfigurationComposite result = new DecisionConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setDecision(Decision decision) {
        if (this.decision == decision) {
            return;
        }
        this.unhookListeners();
        this.clearControls();
        this.decision = decision;
        if (decision != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.decisionConfigurationTypeCombo.addSelectionListener((SelectionListener)this);
        this.expressionText.addFocusListener((FocusListener)this);
    }

    private void unhookListeners() {
        this.decisionConfigurationTypeCombo.removeSelectionListener((SelectionListener)this);
        this.expressionText.removeFocusListener((FocusListener)this);
    }

    private void clearControls() {
        this.decisionConfigurationTypeCombo.setText("");
        this.delegationConfigurationComposite.setDelegation(null);
        this.expressionText.setText("");
    }

    private void updateControls() {
        if (this.decision.getHandler() != null) {
            this.decisionConfigurationTypeCombo.setText("delegation");
            this.delegationConfigurationComposite.setDelegation(this.decision.getHandler());
            this.delegationComposite.setVisible(true);
        } else if (this.decision.getExpression() != null) {
            this.decisionConfigurationTypeCombo.setText("expression");
            this.expressionText.setText(this.decision.getExpression());
            this.expressionComposite.setVisible(true);
        } else {
            this.decisionConfigurationTypeCombo.setText("");
            this.expressionComposite.setVisible(false);
            this.delegationComposite.setVisible(false);
        }
    }

    private void create() {
        this.createMain();
        this.createExpression();
        this.createDelegation();
        this.initializeLayouts();
    }

    private void createMain() {
        this.decisionConfigurationTypeLabel = this.widgetFactory.createLabel(this.parent, "Choose Type");
        this.decisionConfigurationTypeCombo = this.widgetFactory.createCCombo(this.parent);
        this.decisionConfigurationTypeCombo.setItems(new String[]{"", "expression", "delegation"});
        this.decisionConfigurationTypeCombo.setEditable(false);
    }

    private void createDelegation() {
        this.delegationComposite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.delegationComposite.setVisible(false);
        this.delegationConfigurationComposite = DelegationConfigurationComposite.create(this.widgetFactory, this.delegationComposite, this.createChooseDecisionHandlerDialog());
    }

    private ChooseDelegationClassDialog createChooseDecisionHandlerDialog() {
        return new ChooseDelegationClassDialog(this.parent.getShell(), "org.jbpm.graph.node.DecisionHandler", "Choose Decision Handler", "Choose a decision handler from the list");
    }

    private void createExpression() {
        this.expressionComposite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.expressionComposite.setVisible(false);
        this.expressionLabel = this.widgetFactory.createLabel(this.expressionComposite, "Expression");
        this.expressionText = this.widgetFactory.createText(this.expressionComposite, "");
    }

    private void initializeLayouts() {
        this.decisionConfigurationTypeLabel.setLayoutData((Object)this.createConfigurationTypeLabelLayoutData());
        this.decisionConfigurationTypeCombo.setLayoutData((Object)this.createConfigurationTypeComboLayoutData());
        this.delegationComposite.setLayoutData((Object)this.createDelegationCompositeLayoutData());
        this.expressionComposite.setLayoutData((Object)this.createExpressionCompositeLayoutData());
        this.expressionLabel.setLayoutData((Object)this.createExpressionLabelLayoutData());
        this.expressionText.setLayoutData((Object)this.createExpressionTextLayoutData());
    }

    private FormData createExpressionLabelLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 0);
        result.left = new FormAttachment(0, 0);
        return result;
    }

    private FormData createExpressionTextLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 0);
        result.left = new FormAttachment((Control)this.expressionLabel, 0);
        result.right = new FormAttachment(100, 0);
        return result;
    }

    private FormData createConfigurationTypeLabelLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 2);
        result.left = new FormAttachment(0, 0);
        return result;
    }

    private FormData createConfigurationTypeComboLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.decisionConfigurationTypeLabel, 0);
        result.left = new FormAttachment(0, 0);
        return result;
    }

    private FormData createDelegationCompositeLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, -2);
        result.left = new FormAttachment((Control)this.decisionConfigurationTypeCombo, -2);
        result.right = new FormAttachment(100, 0);
        return result;
    }

    private FormData createExpressionCompositeLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, -2);
        result.left = new FormAttachment((Control)this.decisionConfigurationTypeCombo, -2);
        result.right = new FormAttachment(100, 0);
        return result;
    }

    private void updateExpressionText() {
        this.decision.setExpression(this.expressionText.getText());
    }

    private void updateControlVisibility() {
        this.delegationComposite.setVisible("delegation".equals(this.decisionConfigurationTypeCombo.getText()));
        this.expressionComposite.setVisible("expression".equals(this.decisionConfigurationTypeCombo.getText()));
    }

    private void handleConfigurationTypeComboSelected() {
        String selection = this.decisionConfigurationTypeCombo.getText();
        if (selection.equals(this.selectedDecisionType)) {
            return;
        }
        this.selectedDecisionType = selection;
        this.updateControlVisibility();
        if (this.decision != null) {
            this.removeExpressionAndHandlerInfo();
            this.updateExpressionAndHandlerInfo();
        }
    }

    private void updateExpressionAndHandlerInfo() {
        if ("expression".equals(this.selectedDecisionType)) {
            this.decision.setExpression(this.expressionText.getText());
        } else if ("delegation".equals(this.selectedDecisionType)) {
            Handler handler = (Handler)this.decision.getFactory().createById("org.jbpm.gd.jpdl.handler");
            this.decision.setHandler(handler);
            this.delegationConfigurationComposite.setDelegation(handler);
        }
    }

    private void removeExpressionAndHandlerInfo() {
        this.decision.setExpression(null);
        this.decision.setHandler(null);
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.expressionText) {
            this.updateExpressionText();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.decisionConfigurationTypeCombo) {
            this.handleConfigurationTypeComboSelected();
        }
    }
}

