/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.EsbElement;
import org.jbpm.gd.jpdl.properties.EsbGeneralConfigurationComposite;
import org.jbpm.gd.jpdl.properties.EsbInputOutputConfigurationComposite;

public class EsbConfigurationComposite {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private EsbElement esbElement;
    private CTabFolder actionTabFolder;
    private CTabItem outputTabItem;
    private Composite outputTabControl;
    private EsbGeneralConfigurationComposite esbGeneralConfigurationComposite;
    private EsbInputOutputConfigurationComposite esbInputConfigurationComposite;
    private EsbInputOutputConfigurationComposite esbOutputConfigurationComposite;

    public static EsbConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        EsbConfigurationComposite result = new EsbConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setEsbElement(EsbElement esbElement) {
        if (this.esbElement == esbElement) {
            return;
        }
        this.unhookListeners();
        this.clearControls();
        this.esbElement = esbElement;
        if (esbElement != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    public EsbElement getEsbElement() {
        return this.esbElement;
    }

    private void unhookListeners() {
    }

    private void hookListeners() {
    }

    private void clearControls() {
        this.esbGeneralConfigurationComposite.setEsbElement(null);
        this.esbInputConfigurationComposite.setEsbElement(null);
        if (this.outputTabItem != null) {
            this.esbOutputConfigurationComposite.setEsbElement(null);
            this.outputTabItem.dispose();
        }
    }

    private void updateControls() {
        this.esbGeneralConfigurationComposite.setEsbElement(this.esbElement);
        this.esbInputConfigurationComposite.setEsbElement(this.esbElement);
        if (!this.esbElement.isOneWay()) {
            this.createOutputTabItem();
            this.esbOutputConfigurationComposite.setEsbElement(this.esbElement);
        }
    }

    private void create() {
        this.actionTabFolder = this.widgetFactory.createTabFolder(this.parent, 2176);
        this.actionTabFolder.setLayoutData((Object)this.createEsbNodeTabFolderLayoutData());
        this.createGeneralTabItem();
        this.createInputTabItem();
        this.actionTabFolder.setSelection(0);
    }

    private void createGeneralTabItem() {
        CTabItem generalTabItem = this.widgetFactory.createTabItem(this.actionTabFolder, 0);
        generalTabItem.setText("General");
        Composite generalTabControl = this.widgetFactory.createFlatFormComposite((Composite)this.actionTabFolder);
        this.esbGeneralConfigurationComposite = EsbGeneralConfigurationComposite.create(this.widgetFactory, generalTabControl);
        generalTabItem.setControl((Control)generalTabControl);
    }

    private void createInputTabItem() {
        CTabItem inputTabItem = this.widgetFactory.createTabItem(this.actionTabFolder, 0);
        inputTabItem.setText("Input");
        Composite inputTabControl = this.widgetFactory.createFlatFormComposite((Composite)this.actionTabFolder);
        this.esbInputConfigurationComposite = EsbInputOutputConfigurationComposite.create(this.widgetFactory, inputTabControl, EsbInputOutputConfigurationComposite.INPUT_CONFIGURATION);
        inputTabItem.setControl((Control)inputTabControl);
    }

    private void createOutputTabItem() {
        this.outputTabItem = this.widgetFactory.createTabItem(this.actionTabFolder, 0);
        this.outputTabItem.setText("Output");
        if (this.outputTabControl == null) {
            this.outputTabControl = this.widgetFactory.createFlatFormComposite((Composite)this.actionTabFolder);
            this.esbOutputConfigurationComposite = EsbInputOutputConfigurationComposite.create(this.widgetFactory, this.outputTabControl, EsbInputOutputConfigurationComposite.OUTPUT_CONFIGURATION);
        }
        this.outputTabItem.setControl((Control)this.outputTabControl);
    }

    private FormData createEsbNodeTabFolderLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 0);
        result.right = new FormAttachment(100, 0);
        result.top = new FormAttachment(0, 0);
        result.bottom = new FormAttachment(100, 0);
        return result;
    }
}

