/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.EsbElement;

public class EsbGeneralConfigurationComposite
implements FocusListener,
SelectionListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Label serviceNameLabel;
    private Text serviceNameText;
    private Label categoryNameLabel;
    private Text categoryNameText;
    private Label replyToFaultToLabel;
    private CCombo replyToFaultToCombo;
    private EsbElement esbElement;

    public static EsbGeneralConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        EsbGeneralConfigurationComposite result = new EsbGeneralConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private EsbGeneralConfigurationComposite() {
    }

    public void setEsbElement(EsbElement esbElement) {
        if (this.esbElement == esbElement) {
            return;
        }
        this.unhookListeners();
        this.clearControls();
        this.esbElement = esbElement;
        if (esbElement != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.serviceNameText.addFocusListener((FocusListener)this);
        this.categoryNameText.addFocusListener((FocusListener)this);
        this.replyToFaultToCombo.addSelectionListener((SelectionListener)this);
    }

    private void unhookListeners() {
        this.serviceNameText.removeFocusListener((FocusListener)this);
        this.categoryNameText.removeFocusListener((FocusListener)this);
        this.replyToFaultToCombo.removeSelectionListener((SelectionListener)this);
    }

    private void clearControls() {
        this.serviceNameText.setText("");
        this.categoryNameText.setText("");
        this.replyToFaultToCombo.setText("");
    }

    private void updateControls() {
        this.serviceNameText.setText(this.esbElement.getServiceName() == null ? "" : this.esbElement.getServiceName());
        this.categoryNameText.setText(this.esbElement.getCategoryName() == null ? "" : this.esbElement.getCategoryName());
        this.replyToFaultToCombo.setText(this.esbElement.getReplyToOriginator() == null ? "" : this.esbElement.getReplyToOriginator());
    }

    private void create() {
        this.serviceNameLabel = this.widgetFactory.createLabel(this.parent, "Service");
        this.serviceNameText = this.widgetFactory.createText(this.parent, "");
        this.categoryNameLabel = this.widgetFactory.createLabel(this.parent, "Category");
        this.categoryNameText = this.widgetFactory.createText(this.parent, "");
        this.replyToFaultToLabel = this.widgetFactory.createLabel(this.parent, "Reply/Fault");
        this.replyToFaultToCombo = this.widgetFactory.createCCombo(this.parent);
        this.replyToFaultToCombo.add("");
        this.replyToFaultToCombo.add("reply");
        this.replyToFaultToCombo.add("fault");
        this.replyToFaultToCombo.setText("");
        this.serviceNameLabel.setLayoutData((Object)this.createServiceNameLabelLayoutData());
        this.serviceNameText.setLayoutData((Object)this.createServiceNameTextLayoutData());
        this.categoryNameLabel.setLayoutData((Object)this.createCategoryNameLabelLayoutData());
        this.categoryNameText.setLayoutData((Object)this.createCategoryNameTextLayoutData());
        this.replyToFaultToLabel.setLayoutData((Object)this.createReplyToFaultToLabelLayoutData());
        this.replyToFaultToCombo.setLayoutData((Object)this.createReplyToFaultToComboLayoutData());
    }

    private FormData createReplyToFaultToLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.categoryNameText, 5);
        return data;
    }

    private FormData createReplyToFaultToComboLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.replyToFaultToLabel, 5);
        data.top = new FormAttachment((Control)this.categoryNameText, 0);
        return data;
    }

    private FormData createServiceNameTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.replyToFaultToLabel, 5);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    private FormData createCategoryNameTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.replyToFaultToLabel, 5);
        data.top = new FormAttachment((Control)this.serviceNameText, 0);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    private FormData createServiceNameLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 5);
        return data;
    }

    private FormData createCategoryNameLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.serviceNameText, 5);
        return data;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.serviceNameText) {
            this.updateServiceName();
        } else if (e.widget == this.categoryNameText) {
            this.updateCategoryName();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.replyToFaultToCombo) {
            this.updateReplyToFaultTo();
        }
    }

    private void updateServiceName() {
        String name = this.serviceNameText.getText();
        if ("".equals(name)) {
            name = null;
        }
        this.esbElement.setServiceName(name);
    }

    private void updateCategoryName() {
        String name = this.categoryNameText.getText();
        if ("".equals(name)) {
            name = null;
        }
        this.esbElement.setCategoryName(name);
    }

    private void updateReplyToFaultTo() {
        String value = this.replyToFaultToCombo.getText();
        if ("".equals(value)) {
            value = null;
        }
        this.esbElement.setReplyToOriginator(value);
    }
}

